/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.Index;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgreSQLDB
extends BaseDB {
    private static String[] _POSTGRESQL = new String[]{"--", "true", "false", "'01/01/1970'", "current_timestamp", " bytea", " bool", " timestamp", " double precision", " integer", " bigint", " text", " text", " varchar", "", "commit"};
    private static PostgreSQLDB _instance = new PostgreSQLDB();

    public static DB getInstance() {
        return _instance;
    }

    @Override
    public String buildSQL(String template) throws IOException {
        template = this.convertTimestamp(template);
        template = this.replaceTemplate(template, this.getTemplate());
        template = this.reword(template);
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Index> getIndexes() throws SQLException {
        ArrayList<Index> indexes = new ArrayList<Index>();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("select indexname, tablename, indexdef from pg_indexes ");
            sb.append("where indexname like 'liferay_%' or indexname like ");
            sb.append("'ix_%'");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                String indexName = rs.getString("indexname");
                String tableName = rs.getString("tablename");
                String indexSQL = rs.getString("indexdef").toLowerCase().trim();
                boolean unique = true;
                if (indexSQL.startsWith("create index ")) {
                    unique = false;
                }
                indexes.add(new Index(indexName, tableName, unique));
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return indexes;
    }

    protected PostgreSQLDB() {
        super("postgresql");
    }

    @Override
    protected String buildCreateFileContent(String databaseName, int population) throws IOException {
        String suffix = this.getSuffix(population);
        StringBuilder sb = new StringBuilder();
        sb.append("drop database " + databaseName + ";\n");
        sb.append("create database " + databaseName + " encoding = 'UNICODE';\n");
        sb.append("\\c " + databaseName + ";\n\n");
        sb.append(FileUtil.read((String)("../sql/portal" + suffix + "/portal" + suffix + "-postgresql.sql")));
        sb.append("\n\n");
        sb.append(FileUtil.read((String)"../sql/indexes/indexes-postgresql.sql"));
        sb.append("\n\n");
        sb.append(FileUtil.read((String)"../sql/sequences/sequences-postgresql.sql"));
        return sb.toString();
    }

    @Override
    protected String getServerName() {
        return "postgresql";
    }

    @Override
    protected String[] getTemplate() {
        return _POSTGRESQL;
    }

    @Override
    protected String reword(String data) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String[] template;
            if (line.startsWith(ALTER_COLUMN_NAME)) {
                template = this.buildColumnNameTokens(line);
                line = StringUtil.replace((String)"alter table @table@ rename @old-column@ to @new-column@;", (String[])REWORD_TEMPLATE, (String[])template);
            } else if (line.startsWith(ALTER_COLUMN_TYPE)) {
                template = this.buildColumnTypeTokens(line);
                line = StringUtil.replace((String)"alter table @table@ alter @old-column@ type @type@ using @old-column@::@type@;", (String[])REWORD_TEMPLATE, (String[])template);
            } else if (line.indexOf(DROP_PRIMARY_KEY) != -1) {
                String[] tokens = StringUtil.split((String)line, (String)" ");
                line = StringUtil.replace((String)"alter table @table@ drop constraint @table@_pkey;", (String)"@table@", (String)tokens[2]);
            }
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        return sb.toString();
    }
}

