/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.Index;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLServerDB
extends BaseDB {
    private static String[] _SQL_SERVER = new String[]{"--", "1", "0", "'19700101'", "GetDate()", " image", " bit", " datetime", " float", " int", " bigint", " nvarchar(2000)", " ntext", " nvarchar", "  identity(1,1)", "go"};
    private static final int _SQL_SERVER_2000 = 8;
    private static boolean _SUPPORTS_ALTER_COLUMN_TYPE;
    private static SQLServerDB _instance;

    public static DB getInstance() {
        return _instance;
    }

    @Override
    public String buildSQL(String template) throws IOException {
        template = this.convertTimestamp(template);
        template = this.replaceTemplate(template, this.getTemplate());
        template = this.reword(template);
        template = StringUtil.replace((String)template, (String)"\ngo;\n", (String)"\ngo\n");
        template = StringUtil.replace((String)template, (String[])new String[]{"\\\\", "\\'", "\\\"", "\\n", "\\r"}, (String[])new String[]{"\\", "''", "\"", "\n", "\r"});
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Index> getIndexes() throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        ArrayList<Index> indexes;
        block4: {
            indexes = new ArrayList<Index>();
            con = null;
            ps = null;
            rs = null;
            con = DataAccess.getConnection();
            DatabaseMetaData metaData = con.getMetaData();
            if (metaData.getDatabaseMajorVersion() > 8) break block4;
            List<Index> list = null;
            DataAccess.cleanUp((Connection)con, ps, rs);
            return list;
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("select sys.tables.name as table_name, ");
            sb.append("sys.indexes.name as index_name, is_unique from ");
            sb.append("sys.indexes inner join sys.tables on ");
            sb.append("sys.tables.object_id = sys.indexes.object_id where ");
            sb.append("sys.indexes.name like 'LIFERAY_%' or sys.indexes.name ");
            sb.append("like 'IX_%'");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                String indexName = rs.getString("index_name");
                String tableName = rs.getString("table_name");
                boolean unique = !rs.getBoolean("is_unique");
                indexes.add(new Index(indexName, tableName, unique));
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return indexes;
    }

    @Override
    public boolean isSupportsAlterColumnType() {
        return _SUPPORTS_ALTER_COLUMN_TYPE;
    }

    protected SQLServerDB() {
        super("sqlserver");
    }

    @Override
    protected String buildCreateFileContent(String databaseName, int population) throws IOException {
        String suffix = this.getSuffix(population);
        StringBuilder sb = new StringBuilder();
        sb.append("drop database " + databaseName + ";\n");
        sb.append("create database " + databaseName + ";\n");
        sb.append("\n");
        sb.append("go\n");
        sb.append("\n");
        sb.append("use " + databaseName + ";\n\n");
        sb.append(FileUtil.read((String)("../sql/portal" + suffix + "/portal" + suffix + "-sql-server.sql")));
        sb.append("\n\n");
        sb.append(FileUtil.read((String)"../sql/indexes/indexes-sql-server.sql"));
        sb.append("\n\n");
        sb.append(FileUtil.read((String)"../sql/sequences/sequences-sql-server.sql"));
        return sb.toString();
    }

    @Override
    protected String getServerName() {
        return "sql-server";
    }

    @Override
    protected String[] getTemplate() {
        return _SQL_SERVER;
    }

    @Override
    protected String reword(String data) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String[] template;
            if (line.startsWith(ALTER_COLUMN_NAME)) {
                template = this.buildColumnNameTokens(line);
                line = StringUtil.replace((String)"exec sp_rename '@table@.@old-column@', '@new-column@', 'column';", (String[])REWORD_TEMPLATE, (String[])template);
            } else if (line.startsWith(ALTER_COLUMN_TYPE)) {
                template = this.buildColumnTypeTokens(line);
                line = StringUtil.replace((String)"alter table @table@ alter column @old-column@ @type@;", (String[])REWORD_TEMPLATE, (String[])template);
            }
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        return sb.toString();
    }

    static {
        _instance = new SQLServerDB();
    }
}

