/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.Reader;

public class SybaseDB
extends BaseDB {
    protected static String DROP_COLUMN = "drop column";
    private static String[] _SYBASE = new String[]{"--", "1", "0", "'19700101'", "getdate()", " image", " int", " datetime", " float", " int", " decimal(20,0)", " varchar(1000)", " text", " varchar", "  identity(1,1)", "go"};
    private static SybaseDB _instance = new SybaseDB();

    public static DB getInstance() {
        return _instance;
    }

    public String buildSQL(String template) throws IOException {
        template = this.convertTimestamp(template);
        template = this.replaceTemplate(template, this.getTemplate());
        template = this.reword(template);
        template = StringUtil.replace((String)template, (String)");\n", (String)")\ngo\n");
        template = StringUtil.replace((String)template, (String)"\ngo;\n", (String)"\ngo\n");
        template = StringUtil.replace((String)template, (String[])new String[]{"\\\\", "\\'", "\\\"", "\\n", "\\r"}, (String[])new String[]{"\\", "''", "\"", "\n", "\r"});
        return template;
    }

    protected SybaseDB() {
        super("sybase");
    }

    protected String buildCreateFileContent(String databaseName, int population) throws IOException {
        String suffix = this.getSuffix(population);
        StringBuilder sb = new StringBuilder();
        sb = new StringBuilder();
        sb.append("use master\n");
        sb.append("exec sp_dboption '" + databaseName + "', " + "'allow nulls by default' , true\n");
        sb.append("go\n\n");
        sb.append("exec sp_dboption '" + databaseName + "', " + "'select into/bulkcopy/pllsort' , true\n");
        sb.append("go\n\n");
        sb.append("use " + databaseName + "\n\n");
        sb.append(FileUtil.read((String)("../sql/portal" + suffix + "/portal" + suffix + "-sybase.sql")));
        sb.append("\n\n");
        sb.append(FileUtil.read((String)"../sql/indexes/indexes-sybase.sql"));
        sb.append("\n\n");
        sb.append(FileUtil.read((String)"../sql/sequences/sequences-sybase.sql"));
        return sb.toString();
    }

    protected String getServerName() {
        return "sybase";
    }

    protected String[] getTemplate() {
        return _SYBASE;
    }

    protected String reword(String data) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String[] template;
            if (line.indexOf(DROP_COLUMN) != -1) {
                line = StringUtil.replace((String)line, (String)" drop column ", (String)" drop ");
            }
            if (line.startsWith(ALTER_COLUMN_NAME)) {
                template = this.buildColumnNameTokens(line);
                line = StringUtil.replace((String)"exec sp_rename '@table@.@old-column@', '@new-column@', 'column';", (String[])REWORD_TEMPLATE, (String[])template);
            } else if (line.startsWith(ALTER_COLUMN_TYPE)) {
                template = this.buildColumnTypeTokens(line);
                line = StringUtil.replace((String)"alter table @table@ alter column @old-column@ @type@;", (String[])REWORD_TEMPLATE, (String[])template);
            }
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        return sb.toString();
    }
}

