/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.jdbc.aop;

import com.liferay.portal.dao.jdbc.aop.DynamicDataSourceTargetSource;
import com.liferay.portal.dao.jdbc.aop.Operation;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;

public class DynamicDataSourceTransactionInterceptor
extends TransactionInterceptor {
    private DynamicDataSourceTargetSource _dynamicDataSourceTargetSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Class<?> targetClass = null;
        if (methodInvocation.getThis() != null) {
            targetClass = methodInvocation.getThis().getClass();
        }
        Method targetMethod = methodInvocation.getMethod();
        TransactionAttributeSource transactionAttributeSource = this.getTransactionAttributeSource();
        TransactionAttribute transactionAttribute = transactionAttributeSource.getTransactionAttribute(targetMethod, targetClass);
        if (transactionAttribute != null && transactionAttribute.isReadOnly()) {
            this._dynamicDataSourceTargetSource.setOperation(Operation.READ);
        } else {
            this._dynamicDataSourceTargetSource.setOperation(Operation.WRITE);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(targetClass.getName());
        sb.append(".");
        sb.append(targetMethod.getName());
        this._dynamicDataSourceTargetSource.pushMethod(sb.toString());
        Object returnValue = null;
        try {
            returnValue = super.invoke(methodInvocation);
        }
        finally {
            this._dynamicDataSourceTargetSource.popMethod();
        }
        return returnValue;
    }

    public void setDynamicDataSourceTargetSource(DynamicDataSourceTargetSource dynamicDataSourceTargetSource) {
        this._dynamicDataSourceTargetSource = dynamicDataSourceTargetSource;
    }
}

