/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.jdbc.util;

import com.liferay.portal.kernel.jndi.JNDIUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.SortedProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.util.Enumeration;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.dbcp.BasicDataSourceFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import uk.org.primrose.pool.datasource.GenericDataSourceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceFactoryBean
extends AbstractFactoryBean {
    private static Log _log = LogFactoryUtil.getLog(DataSourceFactoryBean.class);
    private Properties _properties;
    private String _propertyPrefix;

    public Object createInstance() throws Exception {
        Properties properties = this._properties;
        properties = properties == null ? PropsUtil.getProperties(this._propertyPrefix, true) : PropertiesUtil.getProperties((Properties)properties, (String)this._propertyPrefix, (boolean)true);
        String jndiName = properties.getProperty("jndi.name");
        if (Validator.isNotNull((String)jndiName)) {
            try {
                return JNDIUtil.lookup((Context)new InitialContext(), (String)jndiName);
            }
            catch (Exception e) {
                _log.error((Object)("Unable to lookup " + jndiName), (Throwable)e);
            }
        }
        DataSource dataSource = null;
        String liferayPoolProvider = PropsValues.JDBC_DEFAULT_LIFERAY_POOL_PROVIDER;
        dataSource = liferayPoolProvider.equals("c3po") ? this.createDataSourceC3PO(properties) : (liferayPoolProvider.equals("dbcp") ? this.createDataSourceDBCP(properties) : this.createDataSourcePrimrose(properties));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Creating data source " + dataSource.getClass().getName()));
            SortedProperties sortedProperties = new SortedProperties(properties);
            _log.debug((Object)("Properties for prefix " + this._propertyPrefix));
            sortedProperties.list(System.out);
        }
        return dataSource;
    }

    public Class<?> getObjectType() {
        return DataSource.class;
    }

    public void setProperties(Properties properties) {
        this._properties = properties;
    }

    public void setPropertyPrefix(String propertyPrefix) {
        this._propertyPrefix = propertyPrefix;
    }

    public void setPropertyPrefixLookup(String propertyPrefixLookup) {
        this._propertyPrefix = PropsUtil.get(propertyPrefixLookup);
    }

    protected DataSource createDataSourceC3PO(Properties properties) throws Exception {
        ComboPooledDataSource comboPooledDataSource = new ComboPooledDataSource();
        comboPooledDataSource.setIdentityToken(this._propertyPrefix);
        Enumeration<?> enu = properties.propertyNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            String value = properties.getProperty(key);
            if (key.equalsIgnoreCase("driverClassName")) {
                key = "driverClass";
            } else if (key.equalsIgnoreCase("url")) {
                key = "jdbcUrl";
            } else if (key.equalsIgnoreCase("username")) {
                key = "user";
            }
            BeanUtils.setProperty((Object)comboPooledDataSource, (String)key, (Object)value);
        }
        return comboPooledDataSource;
    }

    protected DataSource createDataSourceDBCP(Properties properties) throws Exception {
        return BasicDataSourceFactory.createDataSource((Properties)properties);
    }

    protected DataSource createDataSourcePrimrose(Properties properties) throws Exception {
        properties.setProperty("poolName", this._propertyPrefix);
        Enumeration<?> enu = properties.propertyNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            String value = properties.getProperty(key);
            if (key.equalsIgnoreCase("driverClassName")) {
                key = "driverClass";
            } else if (key.equalsIgnoreCase("url")) {
                key = "driverURL";
            } else if (key.equalsIgnoreCase("username")) {
                key = "user";
            }
            properties.setProperty(key, value);
        }
        GenericDataSourceFactory genericDataSourceFactory = new GenericDataSourceFactory();
        return genericDataSourceFactory.loadPool(this._propertyPrefix, properties);
    }
}

