/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.common;

import com.liferay.portal.kernel.cache.CacheRegistry;
import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InitialThreadLocal;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.map.LRUMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityCacheImpl
implements CacheRegistryItem,
EntityCache {
    public static final String CACHE_NAME = EntityCache.class.getName();
    private static Log _log = LogFactoryUtil.getLog(EntityCacheImpl.class);
    private static ThreadLocal<LRUMap> _localCache;
    private static boolean _localCacheAvailable;
    private static ThreadLocal<Boolean> _localCacheEnabled;
    private MultiVMPool _multiVMPool;
    private Map<String, PortalCache> _portalCaches = new ConcurrentHashMap<String, PortalCache>();

    public void afterPropertiesSet() {
        CacheRegistry.register((CacheRegistryItem)this);
    }

    public void clearCache() {
        PortalCache[] portalCaches;
        this.clearLocalCache();
        for (PortalCache portalCache : portalCaches = this._portalCaches.values().toArray(new PortalCache[this._portalCaches.size()])) {
            portalCache.removeAll();
        }
    }

    public void clearCache(String className) {
        this.clearLocalCache();
        PortalCache portalCache = this._getPortalCache(className);
        portalCache.removeAll();
    }

    public void clearLocalCache() {
        if (_localCacheEnabled.get().booleanValue()) {
            Map localCache = (Map)_localCache.get();
            localCache.clear();
        }
    }

    public String getRegistryName() {
        return CACHE_NAME;
    }

    public Object getResult(boolean entityCacheEnabled, Class<?> classObj, Serializable primaryKeyObj, SessionFactory sessionFactory) {
        if (!(PropsValues.VALUE_OBJECT_ENTITY_CACHE_ENABLED && entityCacheEnabled && CacheRegistry.isActive())) {
            return null;
        }
        Object result = null;
        Map localCache = null;
        String localCacheKey = null;
        if (_localCacheEnabled.get().booleanValue()) {
            localCache = (Map)_localCache.get();
            localCacheKey = this._encodeLocalCacheKey(classObj, primaryKeyObj);
            result = localCache.get(localCacheKey);
        }
        if (result == null) {
            String cacheKey;
            PortalCache portalCache = this._getPortalCache(classObj.getName());
            result = portalCache.get(cacheKey = this._encodeCacheKey(primaryKeyObj));
            if (result == null) {
                result = "";
                portalCache.put(cacheKey, result);
            }
            if (_localCacheEnabled.get().booleanValue()) {
                localCache.put(localCacheKey, result);
            }
        }
        if (result != null) {
            result = this._objectToResult(result);
        }
        return result;
    }

    public void invalidate() {
        this.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object loadResult(boolean entityCacheEnabled, Class<?> classObj, Serializable primaryKeyObj, SessionFactory sessionFactory) {
        if (!(PropsValues.VALUE_OBJECT_ENTITY_CACHE_ENABLED && entityCacheEnabled && CacheRegistry.isActive())) {
            Session session = null;
            try {
                session = sessionFactory.openSession();
                Object object = session.load(classObj, primaryKeyObj);
                return object;
            }
            finally {
                sessionFactory.closeSession(session);
            }
        }
        Object result = null;
        Map localCache = null;
        String localCacheKey = null;
        if (_localCacheEnabled.get().booleanValue()) {
            localCache = (Map)_localCache.get();
            localCacheKey = this._encodeLocalCacheKey(classObj, primaryKeyObj);
            result = localCache.get(localCacheKey);
        }
        if (result == null) {
            String cacheKey;
            PortalCache portalCache = this._getPortalCache(classObj.getName());
            result = portalCache.get(cacheKey = this._encodeCacheKey(primaryKeyObj));
            if (result == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Load " + classObj + " " + primaryKeyObj + " from session"));
                }
                Session session = null;
                try {
                    session = sessionFactory.openSession();
                    result = session.load(classObj, primaryKeyObj);
                }
                finally {
                    if (result == null) {
                        result = "";
                    }
                    result = this._objectToResult(result);
                    portalCache.put(cacheKey, result);
                    sessionFactory.closeSession(session);
                }
            }
            if (_localCacheEnabled.get().booleanValue()) {
                localCache.put(localCacheKey, result);
            }
        }
        result = this._objectToResult(result);
        return result;
    }

    public void putResult(boolean entityCacheEnabled, Class<?> classObj, Serializable primaryKeyObj, Object result) {
        if (!(PropsValues.VALUE_OBJECT_ENTITY_CACHE_ENABLED && entityCacheEnabled && CacheRegistry.isActive() && result != null)) {
            return;
        }
        result = this._objectToResult(result);
        if (_localCacheEnabled.get().booleanValue()) {
            Map localCache = (Map)_localCache.get();
            String localCacheKey = this._encodeLocalCacheKey(classObj, primaryKeyObj);
            localCache.put(localCacheKey, result);
        }
        PortalCache portalCache = this._getPortalCache(classObj.getName());
        String cacheKey = this._encodeCacheKey(primaryKeyObj);
        portalCache.put(cacheKey, result);
    }

    public void removeResult(boolean entityCacheEnabled, Class<?> classObj, Serializable primaryKeyObj) {
        if (!(PropsValues.VALUE_OBJECT_ENTITY_CACHE_ENABLED && entityCacheEnabled && CacheRegistry.isActive())) {
            return;
        }
        if (_localCacheEnabled.get().booleanValue()) {
            Map localCache = (Map)_localCache.get();
            String localCacheKey = this._encodeLocalCacheKey(classObj, primaryKeyObj);
            localCache.remove(localCacheKey);
        }
        PortalCache portalCache = this._getPortalCache(classObj.getName());
        String cacheKey = this._encodeCacheKey(primaryKeyObj);
        portalCache.remove(cacheKey);
    }

    public void setLocalCacheEnabled(boolean localCacheEnabled) {
        if (_localCacheAvailable) {
            _localCacheEnabled.set(localCacheEnabled);
        }
    }

    public void setMultiVMPool(MultiVMPool multiVMPool) {
        this._multiVMPool = multiVMPool;
    }

    private String _encodeCacheKey(Serializable primaryKeyObj) {
        return String.valueOf(primaryKeyObj);
    }

    private String _encodeGroupKey(String className) {
        return CACHE_NAME.concat(".").concat(className);
    }

    private String _encodeLocalCacheKey(Class<?> classObj, Serializable primaryKeyObj) {
        return classObj.getName().concat(".").concat(primaryKeyObj.toString());
    }

    private PortalCache _getPortalCache(String className) {
        String groupKey = this._encodeGroupKey(className);
        PortalCache portalCache = this._portalCaches.get(groupKey);
        if (portalCache == null) {
            portalCache = this._multiVMPool.getCache(groupKey, PropsValues.VALUE_OBJECT_ENTITY_BLOCKING_CACHE);
            this._portalCaches.put(groupKey, portalCache);
        }
        return portalCache;
    }

    private Object _objectToResult(Object result) {
        if (result instanceof String) {
            return null;
        }
        result = ((BaseModel)result).clone();
        BaseModel model = (BaseModel)result;
        model.setCachedModel(true);
        return model;
    }

    static {
        _localCacheEnabled = new InitialThreadLocal((Object)Boolean.FALSE);
        if (PropsValues.VALUE_OBJECT_ENTITY_THREAD_LOCAL_CACHE_MAX_SIZE > 0) {
            _localCache = new InitialThreadLocal((Object)new LRUMap(PropsValues.VALUE_OBJECT_ENTITY_THREAD_LOCAL_CACHE_MAX_SIZE));
            _localCacheAvailable = true;
        }
    }
}

