/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.common;

import com.liferay.portal.kernel.cache.CacheKVP;
import com.liferay.portal.kernel.cache.CacheRegistry;
import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.util.InitialThreadLocal;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.map.LRUMap;

public class FinderCacheImpl
implements CacheRegistryItem,
FinderCache {
    public static final String CACHE_NAME = FinderCache.class.getName();
    private static final String _ARGS_SEPARATOR = "_A_";
    private static final String _PARAMS_SEPARATOR = "_P_";
    private static ThreadLocal<LRUMap> _localCache;
    private static boolean _localCacheAvailable;
    private static ThreadLocal<Boolean> _localCacheEnabled;
    private MultiVMPool _multiVMPool;
    private Map<String, PortalCache> _portalCaches = new ConcurrentHashMap<String, PortalCache>();

    public void afterPropertiesSet() {
        CacheRegistry.register((CacheRegistryItem)this);
    }

    public void clearCache() {
        PortalCache[] portalCaches;
        this.clearLocalCache();
        for (PortalCache portalCache : portalCaches = this._portalCaches.values().toArray(new PortalCache[this._portalCaches.size()])) {
            portalCache.removeAll();
        }
    }

    public void clearCache(String className) {
        this.clearLocalCache();
        PortalCache portalCache = this._getPortalCache(className);
        portalCache.removeAll();
    }

    public void clearLocalCache() {
        if (_localCacheEnabled.get().booleanValue()) {
            Map localCache = (Map)_localCache.get();
            localCache.clear();
        }
    }

    public String getRegistryName() {
        return CACHE_NAME;
    }

    public Object getResult(FinderPath finderPath, Object[] args, SessionFactory sessionFactory) {
        String cacheKey;
        PortalCache portalCache;
        if (!(PropsValues.VALUE_OBJECT_FINDER_CACHE_ENABLED && finderPath.isFinderCacheEnabled() && CacheRegistry.isActive())) {
            return null;
        }
        Object primaryKey = null;
        Map localCache = null;
        String localCacheKey = null;
        if (_localCacheEnabled.get().booleanValue()) {
            localCache = (Map)_localCache.get();
            localCacheKey = this._encodeLocalCacheKey(finderPath.getClassName(), finderPath.getMethodName(), finderPath.getParams(), args);
            primaryKey = localCache.get(localCacheKey);
        }
        if (primaryKey == null && (primaryKey = (portalCache = this._getPortalCache(finderPath.getClassName())).get(cacheKey = this._encodeCacheKey(finderPath.getMethodName(), finderPath.getParams(), args))) != null && _localCacheEnabled.get().booleanValue()) {
            localCache.put(localCacheKey, primaryKey);
        }
        if (primaryKey != null) {
            return this._primaryKeyToResult(finderPath, sessionFactory, primaryKey);
        }
        return null;
    }

    public void invalidate() {
        this.clearCache();
    }

    public void putResult(FinderPath finderPath, Object[] args, Object result) {
        if (!(PropsValues.VALUE_OBJECT_FINDER_CACHE_ENABLED && finderPath.isFinderCacheEnabled() && CacheRegistry.isActive() && result != null)) {
            return;
        }
        Object primaryKey = this._resultToPrimaryKey(result);
        if (_localCacheEnabled.get().booleanValue()) {
            Map localCache = (Map)_localCache.get();
            String localCacheKey = this._encodeLocalCacheKey(finderPath.getClassName(), finderPath.getMethodName(), finderPath.getParams(), args);
            localCache.put(localCacheKey, primaryKey);
        }
        PortalCache portalCache = this._getPortalCache(finderPath.getClassName());
        String cacheKey = this._encodeCacheKey(finderPath.getMethodName(), finderPath.getParams(), args);
        portalCache.put(cacheKey, primaryKey);
    }

    public void removeResult(FinderPath finderPath, Object[] args) {
        if (!(PropsValues.VALUE_OBJECT_FINDER_CACHE_ENABLED && finderPath.isFinderCacheEnabled() && CacheRegistry.isActive())) {
            return;
        }
        if (_localCacheEnabled.get().booleanValue()) {
            Map localCache = (Map)_localCache.get();
            String localCacheKey = this._encodeLocalCacheKey(finderPath.getClassName(), finderPath.getMethodName(), finderPath.getParams(), args);
            localCache.remove(localCacheKey);
        }
        PortalCache portalCache = this._getPortalCache(finderPath.getClassName());
        String cacheKey = this._encodeCacheKey(finderPath.getMethodName(), finderPath.getParams(), args);
        portalCache.remove(cacheKey);
    }

    public void setLocalCacheEnabled(boolean localCacheEnabled) {
        if (_localCacheAvailable) {
            _localCacheEnabled.set(localCacheEnabled);
        }
    }

    public void setMultiVMPool(MultiVMPool multiVMPool) {
        this._multiVMPool = multiVMPool;
    }

    private String _encodeCacheKey(String methodName, String[] params, Object[] args) {
        StringBundler sb = new StringBundler((params.length + args.length) * 2 + 3);
        sb.append(methodName);
        sb.append(_PARAMS_SEPARATOR);
        for (String param : params) {
            sb.append(".");
            sb.append(param);
        }
        sb.append(_ARGS_SEPARATOR);
        for (Object arg : args) {
            sb.append(".");
            sb.append(String.valueOf(arg));
        }
        return sb.toString();
    }

    private String _encodeGroupKey(String className) {
        return CACHE_NAME.concat(".").concat(className);
    }

    private String _encodeLocalCacheKey(String className, String methodName, String[] params, Object[] args) {
        StringBundler sb = new StringBundler((params.length + args.length) * 2 + 5);
        sb.append(className);
        sb.append(".");
        sb.append(methodName);
        sb.append(_PARAMS_SEPARATOR);
        for (String param : params) {
            sb.append(".");
            sb.append(param);
        }
        sb.append(_ARGS_SEPARATOR);
        for (Object arg : args) {
            sb.append(".");
            sb.append(String.valueOf(arg));
        }
        return sb.toString();
    }

    private PortalCache _getPortalCache(String className) {
        String groupKey = this._encodeGroupKey(className);
        PortalCache portalCache = this._portalCaches.get(groupKey);
        if (portalCache == null) {
            portalCache = this._multiVMPool.getCache(groupKey, PropsValues.VALUE_OBJECT_FINDER_BLOCKING_CACHE);
            this._portalCaches.put(groupKey, portalCache);
        }
        return portalCache;
    }

    private Object _primaryKeyToResult(FinderPath finderPath, SessionFactory sessionFactory, Object primaryKey) {
        if (primaryKey instanceof CacheKVP) {
            CacheKVP cacheKVP = (CacheKVP)primaryKey;
            Class modelClass = cacheKVP.getModelClass();
            Serializable primaryKeyObj = cacheKVP.getPrimaryKeyObj();
            return EntityCacheUtil.loadResult((boolean)finderPath.isEntityCacheEnabled(), (Class)modelClass, (Serializable)primaryKeyObj, (SessionFactory)sessionFactory);
        }
        if (primaryKey instanceof List) {
            List cachedList = (List)primaryKey;
            ArrayList<Object> list = new ArrayList<Object>(cachedList.size());
            for (Object curPrimaryKey : cachedList) {
                Object result = this._primaryKeyToResult(finderPath, sessionFactory, curPrimaryKey);
                list.add(result);
            }
            return list;
        }
        return primaryKey;
    }

    private Object _resultToPrimaryKey(Object result) {
        if (result instanceof BaseModel) {
            BaseModel model = (BaseModel)result;
            Class<?> modelClass = model.getClass();
            Serializable primaryKeyObj = model.getPrimaryKeyObj();
            return new CacheKVP(modelClass, primaryKeyObj);
        }
        if (result instanceof List) {
            List list = (List)result;
            ArrayList<Object> cachedList = new ArrayList<Object>(list.size());
            for (Object curResult : list) {
                Object primaryKey = this._resultToPrimaryKey(curResult);
                cachedList.add(primaryKey);
            }
            return cachedList;
        }
        return result;
    }

    static {
        _localCacheEnabled = new InitialThreadLocal((Object)Boolean.FALSE);
        if (PropsValues.VALUE_OBJECT_FINDER_THREAD_LOCAL_CACHE_MAX_SIZE > 0) {
            _localCache = new InitialThreadLocal((Object)new LRUMap(PropsValues.VALUE_OBJECT_FINDER_THREAD_LOCAL_CACHE_MAX_SIZE));
            _localCacheAvailable = true;
        }
    }
}

