/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.common;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.PropsValues;
import java.util.HashMap;
import java.util.Map;

public class SQLTransformer {
    private static final String _LOWER_CLOSE = ")";
    private static final String _LOWER_OPEN = "lower(";
    private static Log _log = LogFactoryUtil.getLog(SQLTransformer.class);
    private static SQLTransformer _instance = new SQLTransformer();
    private Map<String, String> _sqlMap = new HashMap<String, String>();
    private boolean _vendorMySQL;

    public static String transform(String sql) {
        return _instance._transform(sql);
    }

    private SQLTransformer() {
        DB db = DBFactoryUtil.getDB();
        if (db.getType().equals("mysql")) {
            this._vendorMySQL = true;
        }
    }

    private String _removeLower(String sql) {
        StringBuilder sb;
        String newSQL;
        block5: {
            int x = sql.indexOf(_LOWER_OPEN);
            if (x == -1) {
                return sql;
            }
            newSQL = this._sqlMap.get(sql);
            if (newSQL != null) {
                return newSQL;
            }
            sb = new StringBuilder(sql.length());
            int y = 0;
            do {
                sb.append(sql.substring(y, x));
                y = sql.indexOf(_LOWER_CLOSE, x);
                if (y == -1) {
                    sb.append(sql.substring(x));
                    break block5;
                }
                sb.append(sql.substring(x + _LOWER_OPEN.length(), y));
            } while ((x = sql.indexOf(_LOWER_OPEN, ++y)) != -1);
            sb.append(sql.substring(y));
        }
        newSQL = sb.toString();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Original SQL " + sql));
            _log.debug((Object)("Modified SQL " + newSQL));
        }
        this._sqlMap.put(sql, newSQL);
        return newSQL;
    }

    private String _transform(String sql) {
        if (sql == null) {
            return sql;
        }
        if (this._vendorMySQL && !PropsValues.DATABASE_MYSQL_FUNCTION_LOWER_ENABLED) {
            sql = this._removeLower(sql);
        }
        return sql;
    }
}

