/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.portal.dao.orm.hibernate.CacheWrapper;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Properties;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;

public class CacheProviderWrapper
implements CacheProvider {
    private static Log _log = LogFactoryUtil.getLog(CacheProviderWrapper.class);
    private CacheProvider _cacheProvider;

    public CacheProviderWrapper(String cacheProvider) {
        try {
            this._cacheProvider = (CacheProvider)Class.forName(cacheProvider).newInstance();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public CacheProviderWrapper(CacheProvider cacheProvider) {
        this._cacheProvider = cacheProvider;
    }

    public Cache buildCache(String regionName, Properties properties) throws CacheException {
        return new CacheWrapper(this._cacheProvider.buildCache(regionName, properties));
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return this._cacheProvider.isMinimalPutsEnabledByDefault();
    }

    public long nextTimestamp() {
        return this._cacheProvider.nextTimestamp();
    }

    public void start(Properties properties) throws CacheException {
        this._cacheProvider.start(properties);
    }

    public void stop() {
        this._cacheProvider.stop();
    }
}

