/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.PropsUtil;
import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import java.util.Map;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.Timestamper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSCache
implements Cache {
    private static Log _log = LogFactoryUtil.getLog(OSCache.class);
    private static GeneralCacheAdministrator _cache = new GeneralCacheAdministrator(PropsUtil.getProperties());
    private int _refreshPeriod;
    private String _cron;
    private String _regionName;
    private String[] _regionGroups;

    public OSCache(int refreshPeriod, String cron, String region) {
        this._refreshPeriod = refreshPeriod;
        this._cron = cron;
        this._regionName = region;
        this._regionGroups = new String[]{region};
    }

    public void clear() throws CacheException {
        _cache.flushGroup(this._regionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws CacheException {
        GeneralCacheAdministrator generalCacheAdministrator = _cache;
        synchronized (generalCacheAdministrator) {
            _cache.destroy();
        }
    }

    public Object get(Object key) throws CacheException {
        String keyString = this._encodeKey(key);
        try {
            return _cache.getFromCache(keyString, this._refreshPeriod, this._cron);
        }
        catch (NeedsRefreshException nre) {
            _cache.cancelUpdate(keyString);
            return null;
        }
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public long getElementCountInMemory() {
        return -1L;
    }

    public String getRegionName() {
        return this._regionName;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public int getTimeout() {
        return -1;
    }

    public void lock(Object key) throws CacheException {
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public void put(Object key, Object value) throws CacheException {
        _cache.putInCache(this._encodeKey(key), value, this._regionGroups);
    }

    public Object read(Object key) throws CacheException {
        return this.get(key);
    }

    public void remove(Object key) throws CacheException {
        _cache.flushEntry(this._encodeKey(key));
    }

    public Map<Object, Object> toMap() {
        return null;
    }

    public void unlock(Object key) throws CacheException {
    }

    public void update(Object key, Object value) throws CacheException {
        _cache.flushEntry(this._encodeKey(key));
        this.put(key, value);
    }

    private String _encodeKey(Object key) {
        String keyString = String.valueOf(key);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Key " + keyString));
        }
        return keyString;
    }
}

