/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.portal.dao.orm.hibernate.CacheWrapper;
import com.liferay.portal.dao.orm.hibernate.OSCache;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.util.PropsUtil;
import java.util.Properties;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.Timestamper;
import org.hibernate.util.StringHelper;

public class OSCacheProvider
implements CacheProvider {
    public static final String OSCACHE_REFRESH_PERIOD = "refresh.period";
    public static final String OSCACHE_CRON = "cron";

    public Cache buildCache(String region, Properties properties) throws CacheException {
        int refreshPeriod = GetterUtil.getInteger((String)PropsUtil.get(StringHelper.qualify((String)region, (String)OSCACHE_REFRESH_PERIOD)), (int)-1);
        String cron = PropsUtil.get(StringHelper.qualify((String)region, (String)OSCACHE_CRON));
        return new CacheWrapper(new OSCache(refreshPeriod, cron, region));
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return false;
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public void start(Properties properties) throws CacheException {
    }

    public void stop() {
    }
}

