/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.portal.dao.orm.hibernate.CacheModeTranslator;
import com.liferay.portal.dao.orm.hibernate.ExceptionTranslator;
import com.liferay.portal.dao.orm.hibernate.ScrollableResultsImpl;
import com.liferay.portal.kernel.dao.orm.CacheMode;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.ScrollableResults;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryImpl
implements Query {
    private org.hibernate.Query _query;

    public QueryImpl(org.hibernate.Query query) {
        this._query = query;
    }

    public int executeUpdate() throws ORMException {
        try {
            return this._query.executeUpdate();
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    public Iterator<?> iterate() throws ORMException {
        return this.iterate(true);
    }

    public Iterator<?> iterate(boolean unmodifiable) throws ORMException {
        try {
            return this.list(unmodifiable).iterator();
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    public List<?> list() throws ORMException {
        return this.list(true);
    }

    public List<?> list(boolean unmodifiable) throws ORMException {
        try {
            List list = this._query.list();
            if (unmodifiable) {
                return new UnmodifiableList(list);
            }
            return ListUtil.copy((List)list);
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    public ScrollableResults scroll() throws ORMException {
        try {
            return new ScrollableResultsImpl(this._query.scroll());
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    public Query setBoolean(int pos, boolean value) {
        this._query.setBoolean(pos, value);
        return this;
    }

    public Query setCacheable(boolean cacheable) {
        this._query.setCacheable(cacheable);
        return this;
    }

    public Query setCacheMode(CacheMode cacheMode) {
        this._query.setCacheMode(CacheModeTranslator.translate(cacheMode));
        return this;
    }

    public Query setCacheRegion(String cacheRegion) {
        this._query.setCacheRegion(cacheRegion);
        return this;
    }

    public Query setDouble(int pos, double value) {
        this._query.setDouble(pos, value);
        return this;
    }

    public Query setFirstResult(int firstResult) {
        this._query.setFirstResult(firstResult);
        return this;
    }

    public Query setFloat(int pos, float value) {
        this._query.setFloat(pos, value);
        return this;
    }

    public Query setInteger(int pos, int value) {
        this._query.setInteger(pos, value);
        return this;
    }

    public Query setLong(int pos, long value) {
        this._query.setLong(pos, value);
        return this;
    }

    public Query setMaxResults(int maxResults) {
        this._query.setMaxResults(maxResults);
        return this;
    }

    public Query setSerializable(int pos, Serializable value) {
        this._query.setSerializable(pos, value);
        return this;
    }

    public Query setShort(int pos, short value) {
        this._query.setShort(pos, value);
        return this;
    }

    public Query setString(int pos, String value) {
        this._query.setString(pos, value);
        return this;
    }

    public Query setTimestamp(int pos, Timestamp value) {
        this._query.setTimestamp(pos, (Date)value);
        return this;
    }

    public Object uniqueResult() throws ORMException {
        try {
            return this._query.uniqueResult();
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }
}

