/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.shard;

import com.liferay.counter.service.persistence.CounterPersistence;
import com.liferay.portal.NoSuchCompanyException;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.dao.shard.ShardDataSourceTargetSource;
import com.liferay.portal.dao.shard.ShardSessionFactoryTargetSource;
import com.liferay.portal.dao.shard.ShardUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InitialThreadLocal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Shard;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.ShardLocalServiceUtil;
import com.liferay.portal.service.persistence.ClassNamePersistence;
import com.liferay.portal.service.persistence.CompanyPersistence;
import com.liferay.portal.service.persistence.ReleasePersistence;
import com.liferay.portal.service.persistence.ShardPersistence;
import com.liferay.portal.util.PropsValues;
import java.util.HashMap;
import java.util.Stack;
import javax.sql.DataSource;
import org.aspectj.lang.ProceedingJoinPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShardAdvice {
    private static Log _log = LogFactoryUtil.getLog(ShardAdvice.class);
    private static ThreadLocal<Stack<String>> _companyServiceStack = new ThreadLocal();
    private static ThreadLocal<Object> _globalCall = new ThreadLocal();
    private static ThreadLocal<String> _shardName = new InitialThreadLocal((Object)PropsValues.SHARD_DEFAULT_NAME);
    private ShardDataSourceTargetSource _shardDataSourceTargetSource;
    private ShardSessionFactoryTargetSource _shardSessionFactoryTargetSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeByParameter(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object[] arguments = proceedingJoinPoint.getArgs();
        long companyId = (Long)arguments[0];
        Shard shard = ShardLocalServiceUtil.getShard((String)Company.class.getName(), (long)companyId);
        String shardName = shard.getName();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Service being set to shard " + shardName + " for " + this._getSignature(proceedingJoinPoint)));
        }
        Object returnValue = null;
        this.pushCompanyService(shardName);
        try {
            returnValue = proceedingJoinPoint.proceed();
        }
        finally {
            this.popCompanyService();
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeCompanyService(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        String methodName = proceedingJoinPoint.getSignature().getName();
        Object[] arguments = proceedingJoinPoint.getArgs();
        String shardName = PropsValues.SHARD_DEFAULT_NAME;
        if (methodName.equals("addCompany")) {
            String webId = (String)arguments[0];
            String virtualHost = (String)arguments[1];
            String mx = (String)arguments[2];
            shardName = (String)arguments[3];
            shardName = this._getCompanyShardName(webId, virtualHost, mx, shardName);
            arguments[3] = shardName;
        } else if (methodName.equals("checkCompany")) {
            String webId = (String)arguments[0];
            if (!webId.equals(PropsValues.COMPANY_DEFAULT_WEB_ID)) {
                if (arguments.length == 3) {
                    String mx = (String)arguments[1];
                    shardName = (String)arguments[2];
                    shardName = this._getCompanyShardName(webId, null, mx, shardName);
                    arguments[2] = shardName;
                }
                try {
                    Company company = CompanyLocalServiceUtil.getCompanyByWebId((String)webId);
                    shardName = company.getShardName();
                }
                catch (NoSuchCompanyException nsce) {}
            }
        } else if (methodName.startsWith("update")) {
            long companyId = (Long)arguments[0];
            Shard shard = ShardLocalServiceUtil.getShard((String)Company.class.getName(), (long)companyId);
            shardName = shard.getName();
        } else {
            return proceedingJoinPoint.proceed();
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Company service being set to shard " + shardName + " for " + this._getSignature(proceedingJoinPoint)));
        }
        Object returnValue = null;
        this.pushCompanyService(shardName);
        try {
            returnValue = proceedingJoinPoint.proceed(arguments);
        }
        finally {
            this.popCompanyService();
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeGlobally(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        _globalCall.set(new Object());
        try {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("All shards invoked for " + this._getSignature(proceedingJoinPoint)));
            }
            for (String shardName : PropsValues.SHARD_AVAILABLE_NAMES) {
                this._shardDataSourceTargetSource.setDataSource(shardName);
                this._shardSessionFactoryTargetSource.setSessionFactory(shardName);
                proceedingJoinPoint.proceed();
            }
        }
        finally {
            _globalCall.set(null);
        }
        return null;
    }

    public Object invokePersistence(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object target = proceedingJoinPoint.getTarget();
        if (target instanceof ClassNamePersistence || target instanceof CompanyPersistence || target instanceof CounterPersistence || target instanceof ReleasePersistence || target instanceof ShardPersistence) {
            this._shardDataSourceTargetSource.setDataSource(PropsValues.SHARD_DEFAULT_NAME);
            this._shardSessionFactoryTargetSource.setSessionFactory(PropsValues.SHARD_DEFAULT_NAME);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Using default shard for " + this._getSignature(proceedingJoinPoint)));
            }
            return proceedingJoinPoint.proceed();
        }
        if (_globalCall.get() == null) {
            this._setShardNameByCompany();
            String shardName = this._getShardName();
            this._shardDataSourceTargetSource.setDataSource(shardName);
            this._shardSessionFactoryTargetSource.setSessionFactory(shardName);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Using shard name " + shardName + " for " + this._getSignature(proceedingJoinPoint)));
            }
            return proceedingJoinPoint.proceed();
        }
        return proceedingJoinPoint.proceed();
    }

    public void setShardDataSourceTargetSource(ShardDataSourceTargetSource shardDataSourceTargetSource) {
        this._shardDataSourceTargetSource = shardDataSourceTargetSource;
    }

    public void setShardSessionFactoryTargetSource(ShardSessionFactoryTargetSource shardSessionFactoryTargetSource) {
        this._shardSessionFactoryTargetSource = shardSessionFactoryTargetSource;
    }

    protected DataSource getDataSource() {
        return this._shardDataSourceTargetSource.getDataSource();
    }

    protected String popCompanyService() {
        return this._getCompanyServiceStack().pop();
    }

    protected void pushCompanyService(long companyId) {
        try {
            Shard shard = ShardLocalServiceUtil.getShard((String)Company.class.getName(), (long)companyId);
            String shardName = shard.getName();
            this.pushCompanyService(shardName);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void pushCompanyService(String shardName) {
        this._getCompanyServiceStack().push(shardName);
    }

    private Stack<String> _getCompanyServiceStack() {
        Stack<String> companyServiceStack = _companyServiceStack.get();
        if (companyServiceStack == null) {
            companyServiceStack = new Stack();
            _companyServiceStack.set(companyServiceStack);
        }
        return companyServiceStack;
    }

    private String _getCompanyShardName(String webId, String virtualHost, String mx, String shardName) {
        HashMap<String, String> shardParams = new HashMap<String, String>();
        shardParams.put("webId", webId);
        shardParams.put("mx", mx);
        if (virtualHost != null) {
            shardParams.put("virtualHost", virtualHost);
        }
        shardName = ShardUtil.getShardSelector().getShardName(ShardUtil.COMPANY_SCOPE, shardName, shardParams);
        return shardName;
    }

    private String _getShardName() {
        return _shardName.get();
    }

    private String _getSignature(ProceedingJoinPoint proceedingJoinPoint) {
        String methodName = StringUtil.extractLast((String)proceedingJoinPoint.getTarget().getClass().getName(), (String)".");
        methodName = methodName + "." + proceedingJoinPoint.getSignature().getName() + "()";
        return methodName;
    }

    private void _setShardName(String shardName) {
        _shardName.set(shardName);
    }

    private void _setShardNameByCompany() throws Throwable {
        Stack<String> companyServiceStack = this._getCompanyServiceStack();
        if (companyServiceStack.isEmpty()) {
            long companyId = CompanyThreadLocal.getCompanyId();
            this._setShardNameByCompanyId(companyId);
        } else {
            String shardName = companyServiceStack.peek();
            this._setShardName(shardName);
        }
    }

    private void _setShardNameByCompanyId(long companyId) throws PortalException, SystemException {
        if (companyId == 0L) {
            this._setShardName(PropsValues.SHARD_DEFAULT_NAME);
        } else {
            Shard shard = ShardLocalServiceUtil.getShard((String)Company.class.getName(), (long)companyId);
            String shardName = shard.getName();
            this._setShardName(shardName);
        }
    }
}

