/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.shard;

import com.liferay.portal.dao.shard.ShardAdvice;
import com.liferay.portal.dao.shard.ShardSelector;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.PropsValues;
import javax.sql.DataSource;

public class ShardUtil {
    public static String COMPANY_SCOPE = "COMPANY_SCOPE";
    private static Log _log = LogFactoryUtil.getLog(ShardUtil.class);
    private static ShardAdvice _shardAdvice;
    private static ShardSelector _shardSelector;

    public static DataSource getDataSource() {
        return _shardAdvice.getDataSource();
    }

    public static ShardSelector getShardSelector() {
        return _shardSelector;
    }

    public static boolean isEnabled() {
        return _shardAdvice != null;
    }

    public static String popCompanyService() {
        String value = null;
        if (_shardAdvice != null) {
            value = _shardAdvice.popCompanyService();
        }
        return value;
    }

    public static void pushCompanyService(long companyId) {
        if (_shardAdvice != null) {
            _shardAdvice.pushCompanyService(companyId);
        }
    }

    public static void pushCompanyService(String shardName) {
        if (_shardAdvice != null) {
            _shardAdvice.pushCompanyService(shardName);
        }
    }

    public void setShardAdvice(ShardAdvice shardAdvice) {
        _shardAdvice = shardAdvice;
    }

    static {
        try {
            _shardSelector = (ShardSelector)Class.forName(PropsValues.SHARD_SELECTOR).newInstance();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }
}

