/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.SystemProperties;
import com.liferay.util.ant.DeleteTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DeployUtil {
    private static Log _log = LogFactoryUtil.getLog(DeployUtil.class);
    private static DeployUtil _instance = new DeployUtil();

    public static String getAutoDeployDestDir() throws Exception {
        String destDir = PrefsPropsUtil.getString("auto.deploy.dest.dir", PropsValues.AUTO_DEPLOY_DEST_DIR);
        if (Validator.isNull((String)destDir)) {
            destDir = DeployUtil.getAutoDeployServerDestDir();
        }
        return destDir;
    }

    public static String getAutoDeployServerDestDir() throws Exception {
        String destDir = null;
        String serverId = GetterUtil.getString((String)ServerDetector.getServerId());
        destDir = serverId.equals("tomcat") ? PrefsPropsUtil.getString("auto.deploy.tomcat.dest.dir", PropsValues.AUTO_DEPLOY_TOMCAT_DEST_DIR) : PrefsPropsUtil.getString("auto.deploy." + serverId + ".dest.dir");
        if (Validator.isNull((String)destDir)) {
            destDir = PrefsPropsUtil.getString("auto.deploy.default.dest.dir", PropsValues.AUTO_DEPLOY_DEFAULT_DEST_DIR);
        }
        destDir = StringUtil.replace((String)destDir, (String)"\\", (String)"/");
        return destDir;
    }

    public static String getResourcePath(String resource) throws Exception {
        return _instance._getResourcePath(resource);
    }

    public static void undeploy(String appServerType, File deployDir) throws Exception {
        boolean undeployEnabled = PrefsPropsUtil.getBoolean("hot.undeploy.enabled", PropsValues.HOT_UNDEPLOY_ENABLED);
        if (!undeployEnabled) {
            return;
        }
        if (!appServerType.startsWith("jboss") && !appServerType.equals("tomcat")) {
            return;
        }
        File webXml = new File(deployDir + "/WEB-INF/web.xml");
        if (!webXml.exists()) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Undeploy " + deployDir));
        }
        FileUtil.delete((String)(deployDir + "/WEB-INF/web.xml"));
        DeleteTask.deleteDirectory((File)deployDir);
        int undeployInterval = PrefsPropsUtil.getInteger("hot.undeploy.interval", PropsValues.HOT_UNDEPLOY_INTERVAL);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Wait " + undeployInterval + " ms to allow the plugin time to fully undeploy"));
        }
        if (undeployInterval > 0) {
            Thread.sleep(undeployInterval);
        }
    }

    private DeployUtil() {
    }

    private String _getResourcePath(String resource) throws IOException {
        InputStream is = this.getClass().getResourceAsStream("dependencies/" + resource);
        if (is == null) {
            return null;
        }
        String tmpDir = SystemProperties.get((String)"java.io.tmpdir");
        File file = new File(tmpDir + "/liferay/com/liferay/portal/deploy/dependencies/" + resource);
        if (!file.exists() || resource.startsWith("ext-")) {
            File parentFile = file.getParentFile();
            if (parentFile != null) {
                parentFile.mkdirs();
            }
            StreamUtil.transfer((InputStream)is, (OutputStream)new FileOutputStream(file));
        }
        return FileUtil.getAbsolutePath((File)file);
    }
}

