/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.auto;

import com.liferay.portal.deploy.auto.PortletAutoDeployer;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WAIAutoDeployer
extends PortletAutoDeployer {
    private static String[] _INIT_PARAM_NAMES = new String[]{"wai.connector", "wai.connector.iframe.height.extra"};
    private static String[] _INIT_PARAM_DEFAULT_VALUES = new String[]{"iframe", "40"};

    protected WAIAutoDeployer() throws AutoDeployException {
        try {
            this.addRequiredJar(this.jars, "portals-bridges.jar");
        }
        catch (Exception e) {
            throw new AutoDeployException((Throwable)e);
        }
    }

    @Override
    protected void copyXmls(File srcFile, String displayName, PluginPackage pluginPackage) throws Exception {
        super.copyXmls(srcFile, displayName, pluginPackage);
        String portletName = displayName;
        if (pluginPackage != null) {
            portletName = pluginPackage.getName();
        }
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("portlet_name", displayName);
        filterMap.put("portlet_title", portletName);
        filterMap.put("restore_current_view", "false");
        if (pluginPackage != null) {
            Properties settings = pluginPackage.getDeploymentSettings();
            filterMap.put("portlet_class", settings.getProperty("wai.portlet", "com.liferay.util.bridges.wai.WAIPortlet"));
            filterMap.put("friendly_url_mapper_class", settings.getProperty("wai.friendly.url.mapper", "com.liferay.util.bridges.wai.WAIFriendlyURLMapper"));
        } else {
            filterMap.put("portlet_class", "com.liferay.util.bridges.wai.WAIPortlet");
            filterMap.put("friendly_url_mapper_class", "com.liferay.util.bridges.wai.WAIFriendlyURLMapper");
        }
        this._setInitParams(filterMap, pluginPackage);
        this.copyDependencyXml("liferay-display.xml", srcFile + "/WEB-INF", filterMap);
        this.copyDependencyXml("liferay-portlet.xml", srcFile + "/WEB-INF", filterMap);
        this.copyDependencyXml("portlet.xml", srcFile + "/WEB-INF", filterMap);
        this.copyDependencyXml("normal_window_state.jsp", srcFile + "/WEB-INF/jsp/liferay/wai");
        this.copyDependencyXml("iframe.jsp", srcFile + "/WEB-INF/jsp/liferay/wai");
    }

    private void _setInitParams(Map<String, String> filterMap, PluginPackage pluginPackage) {
        for (int i = 0; i < _INIT_PARAM_NAMES.length; ++i) {
            String name = _INIT_PARAM_NAMES[i];
            String value = null;
            if (pluginPackage != null) {
                pluginPackage.getDeploymentSettings().getProperty(name);
            }
            if (Validator.isNull(value)) {
                value = _INIT_PARAM_DEFAULT_VALUES[i];
            }
            filterMap.put("init_param_name_" + i, name);
            filterMap.put("init_param_value_" + i, value);
        }
    }
}

