/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.portal.PortalException;
import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.image.Hook;
import com.liferay.portal.image.HookFactory;
import com.liferay.portal.kernel.bean.ContextClassLoaderBeanHandler;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.deploy.auto.AutoDeployDir;
import com.liferay.portal.kernel.deploy.auto.AutoDeployListener;
import com.liferay.portal.kernel.deploy.auto.AutoDeployUtil;
import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.deploy.hot.HotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.InvokerAction;
import com.liferay.portal.kernel.events.InvokerSessionAction;
import com.liferay.portal.kernel.events.InvokerSimpleAction;
import com.liferay.portal.kernel.events.SessionAction;
import com.liferay.portal.kernel.events.SimpleAction;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.model.Release;
import com.liferay.portal.security.auth.AuthFailure;
import com.liferay.portal.security.auth.AuthPipeline;
import com.liferay.portal.security.auth.Authenticator;
import com.liferay.portal.security.auth.AutoLogin;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.security.auth.EmailAddressGenerator;
import com.liferay.portal.security.auth.EmailAddressGeneratorFactory;
import com.liferay.portal.security.auth.FullNameValidator;
import com.liferay.portal.security.auth.FullNameValidatorFactory;
import com.liferay.portal.security.auth.ScreenNameGenerator;
import com.liferay.portal.security.auth.ScreenNameGeneratorFactory;
import com.liferay.portal.security.auth.ScreenNameValidator;
import com.liferay.portal.security.auth.ScreenNameValidatorFactory;
import com.liferay.portal.security.ldap.AttributesTransformer;
import com.liferay.portal.security.ldap.AttributesTransformerFactory;
import com.liferay.portal.service.ReleaseLocalServiceUtil;
import com.liferay.portal.service.persistence.BasePersistence;
import com.liferay.portal.servlet.filters.autologin.AutoLoginFilter;
import com.liferay.portal.servlet.filters.cache.CacheUtil;
import com.liferay.portal.spring.aop.ServiceHookAdvice;
import com.liferay.portal.struts.MultiMessageResources;
import com.liferay.portal.struts.MultiMessageResourcesFactory;
import com.liferay.portal.upgrade.UpgradeProcessUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.ControlPanelEntry;
import com.liferay.portlet.DefaultControlPanelEntryFactory;
import com.liferay.util.UniqueList;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HookHotDeployListener
extends BaseHotDeployListener
implements PropsKeys {
    private static final String[] _PROPS_KEYS_EVENTS = new String[]{"login.events.post", "login.events.pre", "logout.events.post", "logout.events.pre", "servlet.service.events.post", "servlet.service.events.pre"};
    private static final String[] _PROPS_KEYS_SESSION_EVENTS = new String[]{"servlet.session.create.events", "servlet.session.destroy.events"};
    private static final String[] _PROPS_VALUES_BOOLEAN = new String[]{"auth.forward.by.last.path", "captcha.check.portal.create_account", "field.enable.com.liferay.portal.model.Contact.birthday", "field.enable.com.liferay.portal.model.Contact.male", "field.enable.com.liferay.portal.model.Organization.status", "javascript.fast.load", "layout.template.cache.enabled", "layout.user.private.layouts.auto.create", "layout.user.private.layouts.enabled", "layout.user.private.layouts.modifiable", "layout.user.public.layouts.auto.create", "layout.user.public.layouts.enabled", "layout.user.public.layouts.modifiable", "login.create.account.allow.custom.password", "my.places.show.community.private.sites.with.no.layouts", "my.places.show.community.public.sites.with.no.layouts", "my.places.show.organization.private.sites.with.no.layouts", "my.places.show.organization.public.sites.with.no.layouts", "my.places.show.user.private.sites.with.no.layouts", "my.places.show.user.public.sites.with.no.layouts", "terms.of.use.required", "theme.css.fast.load", "theme.images.fast.load", "users.email.address.required", "users.screen.name.always.autogenerate"};
    private static final String[] _PROPS_VALUES_INTEGER = new String[0];
    private static final String[] _PROPS_VALUES_LONG = new String[0];
    private static final String[] _PROPS_VALUES_STRING = new String[]{"default.landing.page.path", "passwords.passwordpolicytoolkit.generator", "passwords.passwordpolicytoolkit.static"};
    private static final String[] _PROPS_VALUES_STRING_ARRAY = new String[]{"layout.static.portlets.all", "session.phishing.protected.attributes"};
    private static Log _log = LogFactoryUtil.getLog(HookHotDeployListener.class);
    private Map<String, AuthenticatorsContainer> _authenticatorsContainerMap = new HashMap<String, AuthenticatorsContainer>();
    private Map<String, AuthFailuresContainer> _authFailuresContainerMap = new HashMap<String, AuthFailuresContainer>();
    private Map<String, AutoDeployListenersContainer> _autoDeployListenersContainerMap = new HashMap<String, AutoDeployListenersContainer>();
    private Map<String, AutoLoginsContainer> _autoLoginsContainerMap = new HashMap<String, AutoLoginsContainer>();
    private Map<String, CustomJspBag> _customJspBagsMap = new HashMap<String, CustomJspBag>();
    private Map<String, EventsContainer> _eventsContainerMap = new HashMap<String, EventsContainer>();
    private Map<String, HotDeployListenersContainer> _hotDeployListenersContainerMap = new HashMap<String, HotDeployListenersContainer>();
    private Map<String, LanguagesContainer> _languagesContainerMap = new HashMap<String, LanguagesContainer>();
    private Map<String, ModelListenersContainer> _modelListenersContainerMap = new HashMap<String, ModelListenersContainer>();
    private Map<String, Properties> _portalPropertiesMap = new HashMap<String, Properties>();
    private Map<String, ServicesContainer> _servicesContainerMap = new HashMap<String, ServicesContainer>();
    private Set<String> _servletContextNames = new HashSet<String>();
    private Map<String, StringArraysContainer> _stringArraysContainerMap = new HashMap<String, StringArraysContainer>();

    public HookHotDeployListener() {
        for (String key : _PROPS_VALUES_STRING_ARRAY) {
            this._stringArraysContainerMap.put(key, new StringArraysContainer(key));
        }
    }

    public void invokeDeploy(HotDeployEvent event) throws HotDeployException {
        try {
            this.doInvokeDeploy(event);
        }
        catch (Throwable t) {
            this.throwHotDeployException(event, "Error registering hook for ", t);
        }
    }

    public void invokeUndeploy(HotDeployEvent event) throws HotDeployException {
        try {
            this.doInvokeUndeploy(event);
        }
        catch (Throwable t) {
            this.throwHotDeployException(event, "Error unregistering hook for ", t);
        }
    }

    protected boolean containsKey(Properties portalProperties, String key) {
        if (_log.isDebugEnabled()) {
            return true;
        }
        return portalProperties.containsKey(key);
    }

    protected void destroyCustomJspBag(CustomJspBag customJspBag) {
        String customJspDir = customJspBag.getCustomJspDir();
        List<String> customJsps = customJspBag.getCustomJsps();
        String portalWebDir = PortalUtil.getPortalWebDir();
        for (String customJsp : customJsps) {
            int pos = customJsp.indexOf(customJspDir);
            String portalJsp = customJsp.substring(pos + customJspDir.length(), customJsp.length());
            File portalJspFile = new File(portalWebDir + portalJsp);
            File portalJspBackupFile = this.getPortalJspBackupFile(portalJspFile);
            if (portalJspBackupFile.exists()) {
                FileUtil.copyFile((File)portalJspBackupFile, (File)portalJspFile);
                portalJspBackupFile.delete();
                continue;
            }
            if (!portalJspFile.exists()) continue;
            portalJspFile.delete();
        }
    }

    protected void destroyPortalProperties(String servletContextName, Properties portalProperties) throws Exception {
        PropsUtil.removeProperties(portalProperties);
        if (_log.isDebugEnabled() && portalProperties.containsKey("locales")) {
            _log.debug((Object)("Portlet locales " + portalProperties.getProperty("locales")));
            _log.debug((Object)("Original locales " + PropsUtil.get("locales")));
            _log.debug((Object)("Original locales array length " + PropsUtil.getArray("locales").length));
        }
        this.resetPortalProperties(servletContextName, portalProperties, false);
        if (portalProperties.containsKey("control.panel.default.entry.class")) {
            DefaultControlPanelEntryFactory.setInstance(null);
        }
        if (portalProperties.containsKey("dl.hook.impl")) {
            com.liferay.documentlibrary.util.HookFactory.setInstance(null);
        }
        if (portalProperties.containsKey("image.hook.impl")) {
            HookFactory.setInstance(null);
        }
        if (portalProperties.containsKey("ldap.attrs.transformer.impl")) {
            AttributesTransformerFactory.setInstance(null);
        }
        if (portalProperties.containsKey("mail.hook.impl")) {
            com.liferay.mail.util.HookFactory.setInstance(null);
        }
        if (portalProperties.containsKey("users.email.address.generator")) {
            EmailAddressGeneratorFactory.setInstance(null);
        }
        if (portalProperties.containsKey("users.full.name.validator")) {
            FullNameValidatorFactory.setInstance(null);
        }
        if (portalProperties.containsKey("users.screen.name.generator")) {
            ScreenNameGeneratorFactory.setInstance(null);
        }
        if (portalProperties.containsKey("users.screen.name.validator")) {
            ScreenNameValidatorFactory.setInstance(null);
        }
    }

    protected void doInvokeDeploy(HotDeployEvent event) throws Exception {
        String xml;
        ServletContext servletContext = event.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking deploy for " + servletContextName));
        }
        if ((xml = HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-hook.xml"))) == null) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Registering hook for " + servletContextName));
        }
        this._servletContextNames.add(servletContextName);
        ClassLoader portletClassLoader = event.getContextClassLoader();
        Document doc = SAXReaderUtil.read((String)xml, (boolean)true);
        Element root = doc.getRootElement();
        String portalPropertiesLocation = root.elementText("portal-properties");
        if (Validator.isNotNull((String)portalPropertiesLocation)) {
            Properties portalProperties;
            Configuration portalPropertiesConfiguration = null;
            try {
                String name = portalPropertiesLocation;
                int pos = name.lastIndexOf(".properties");
                if (pos != -1) {
                    name = name.substring(0, pos);
                }
                portalPropertiesConfiguration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)portletClassLoader, (String)name);
            }
            catch (Exception e) {
                _log.error((Object)("Unable to read " + portalPropertiesLocation), (Throwable)e);
            }
            if (portalPropertiesConfiguration != null && (portalProperties = portalPropertiesConfiguration.getProperties()).size() > 0) {
                this._portalPropertiesMap.put(servletContextName, portalProperties);
                this.initPortalProperties(servletContextName, portletClassLoader, portalProperties);
                this.initAuthFailures(servletContextName, portletClassLoader, portalProperties);
                this.initAutoDeployListeners(servletContextName, portletClassLoader, portalProperties);
                this.initAutoLogins(servletContextName, portletClassLoader, portalProperties);
                this.initHotDeployListeners(servletContextName, portletClassLoader, portalProperties);
                this.initModelListeners(servletContextName, portletClassLoader, portalProperties);
                this.initEvents(servletContextName, portletClassLoader, portalProperties);
            }
        }
        LanguagesContainer languagesContainer = new LanguagesContainer();
        this._languagesContainerMap.put(servletContextName, languagesContainer);
        List languagePropertiesEls = root.elements("language-properties");
        for (Element languagePropertiesEl : languagePropertiesEls) {
            String languagePropertiesLocation = languagePropertiesEl.getText();
            try {
                URL url = portletClassLoader.getResource(languagePropertiesLocation);
                if (url == null) continue;
                InputStream is = url.openStream();
                Properties properties = new Properties();
                properties.load(is);
                is.close();
                String localeKey = this.getLocaleKey(languagePropertiesLocation);
                if (localeKey == null) continue;
                languagesContainer.addLanguage(localeKey, properties);
            }
            catch (Exception e) {
                _log.error((Object)("Unable to read " + languagePropertiesLocation), (Throwable)e);
            }
        }
        String customJspDir = root.elementText("custom-jsp-dir");
        if (Validator.isNotNull((String)customJspDir)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Custom JSP directory: " + customJspDir));
            }
            ArrayList<String> customJsps = new ArrayList<String>();
            String webDir = servletContext.getRealPath("/");
            this.getCustomJsps(servletContext, webDir, customJspDir, customJsps);
            if (customJsps.size() > 0) {
                CustomJspBag customJspBag = new CustomJspBag(customJspDir, customJsps);
                if (_log.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Custom JSP files:\n");
                    Iterator itr = customJsps.iterator();
                    while (itr.hasNext()) {
                        String customJsp = (String)itr.next();
                        sb.append(customJsp);
                        if (!itr.hasNext()) continue;
                        sb.append("\n");
                    }
                    _log.debug((Object)sb.toString());
                }
                this._customJspBagsMap.put(servletContextName, customJspBag);
                this.initCustomJspBag(customJspBag);
            }
        }
        ServicesContainer servicesContainer = new ServicesContainer();
        this._servicesContainerMap.put(servletContextName, servicesContainer);
        List serviceEls = root.elements("service");
        for (Element serviceEl : serviceEls) {
            String serviceType = serviceEl.elementText("service-type");
            String serviceImpl = serviceEl.elementText("service-impl");
            Class<?> serviceTypeClass = portletClassLoader.loadClass(serviceType);
            Class<?> serviceImplClass = portletClassLoader.loadClass(serviceImpl);
            Constructor<?> serviceImplConstructor = serviceImplClass.getConstructor(serviceTypeClass);
            Object serviceImplInstance = serviceImplConstructor.newInstance(PortalBeanLocatorUtil.locate((String)serviceType));
            serviceImplInstance = Proxy.newProxyInstance(portletClassLoader, new Class[]{serviceTypeClass}, (InvocationHandler)new ContextClassLoaderBeanHandler(serviceImplInstance, portletClassLoader));
            servicesContainer.addService(serviceType, serviceImplInstance);
        }
        ModelListenersContainer modelListenersContainer = this._modelListenersContainerMap.get(servletContextName);
        if (modelListenersContainer == null) {
            modelListenersContainer = new ModelListenersContainer();
            this._modelListenersContainerMap.put(servletContextName, modelListenersContainer);
        }
        List modelListenerEls = root.elements("model-listener");
        for (Element modelListenerEl : modelListenerEls) {
            String modelListenerClassName;
            String modelName = modelListenerEl.elementText("model-name");
            ModelListener<BaseModel<?>> modelListener = this.initModelListener(modelName, modelListenerClassName = modelListenerEl.elementText("model-listener-class"), portletClassLoader);
            if (modelListener == null) continue;
            modelListenersContainer.registerModelListener(modelName, modelListener);
        }
        EventsContainer eventsContainer = this._eventsContainerMap.get(servletContextName);
        if (eventsContainer == null) {
            eventsContainer = new EventsContainer();
            this._eventsContainerMap.put(servletContextName, eventsContainer);
        }
        List eventEls = root.elements("event");
        for (Element eventEl : eventEls) {
            String eventClassName;
            String eventName = eventEl.elementText("event-type");
            Object obj = this.initEvent(eventName, eventClassName = eventEl.elementText("event-class"), portletClassLoader);
            if (obj == null) continue;
            eventsContainer.registerEvent(eventName, obj);
        }
        this.registerClpMessageListeners(servletContext, portletClassLoader);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Hook for " + servletContextName + " is available for use"));
        }
    }

    protected void doInvokeUndeploy(HotDeployEvent event) throws Exception {
        ServicesContainer servicesContainer;
        Properties portalProperties;
        ModelListenersContainer modelListenersContainer;
        LanguagesContainer languagesContainer;
        HotDeployListenersContainer hotDeployListenersContainer;
        EventsContainer eventsContainer;
        CustomJspBag customJspBag;
        AutoLoginsContainer autoLoginsContainer;
        AutoDeployListenersContainer autoDeployListenersContainer;
        AuthFailuresContainer authFailuresContainer;
        ServletContext servletContext = event.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking undeploy for " + servletContextName));
        }
        if (!this._servletContextNames.remove(servletContextName)) {
            return;
        }
        AuthenticatorsContainer authenticatorsContainer = this._authenticatorsContainerMap.remove(servletContextName);
        if (authenticatorsContainer != null) {
            authenticatorsContainer.unregisterAuthenticators();
        }
        if ((authFailuresContainer = this._authFailuresContainerMap.remove(servletContextName)) != null) {
            authFailuresContainer.unregisterAuthFailures();
        }
        if ((autoDeployListenersContainer = this._autoDeployListenersContainerMap.remove(servletContextName)) != null) {
            autoDeployListenersContainer.unregisterAutoDeployListeners();
        }
        if ((autoLoginsContainer = this._autoLoginsContainerMap.remove(servletContextName)) != null) {
            autoLoginsContainer.unregisterAutoLogins();
        }
        if ((customJspBag = this._customJspBagsMap.remove(servletContextName)) != null) {
            this.destroyCustomJspBag(customJspBag);
        }
        if ((eventsContainer = this._eventsContainerMap.remove(servletContextName)) != null) {
            eventsContainer.unregisterEvents();
        }
        if ((hotDeployListenersContainer = this._hotDeployListenersContainerMap.remove(servletContextName)) != null) {
            hotDeployListenersContainer.unregisterHotDeployListeners();
        }
        if ((languagesContainer = this._languagesContainerMap.remove(servletContextName)) != null) {
            languagesContainer.unregisterLanguages();
        }
        if ((modelListenersContainer = this._modelListenersContainerMap.remove(servletContextName)) != null) {
            modelListenersContainer.unregisterModelListeners();
        }
        if ((portalProperties = this._portalPropertiesMap.remove(servletContextName)) != null) {
            this.destroyPortalProperties(servletContextName, portalProperties);
        }
        if ((servicesContainer = this._servicesContainerMap.remove(servletContextName)) != null) {
            servicesContainer.unregisterServices();
        }
        this.unregisterClpMessageListeners(servletContext);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Hook for " + servletContextName + " was unregistered"));
        }
    }

    protected void getCustomJsps(ServletContext servletContext, String webDir, String resourcePath, List<String> customJsps) {
        Set resourcePaths = servletContext.getResourcePaths(resourcePath);
        for (String curResourcePath : resourcePaths) {
            if (curResourcePath.endsWith("/")) {
                this.getCustomJsps(servletContext, webDir, curResourcePath, customJsps);
                continue;
            }
            String customJsp = webDir + curResourcePath;
            customJsp = StringUtil.replace((String)customJsp, (String)"//", (String)"/");
            customJsps.add(customJsp);
        }
    }

    protected String getLocaleKey(String languagePropertiesLocation) {
        int x = languagePropertiesLocation.indexOf("_");
        int y = languagePropertiesLocation.indexOf(".properties");
        if (x != -1 && y != 1) {
            String localeKey = languagePropertiesLocation.substring(x + 1, y);
            Locale locale = LocaleUtil.fromLanguageId((String)localeKey);
            if ((locale = LanguageUtil.getLocale((String)locale.getLanguage())) != null) {
                return locale.toString();
            }
        }
        return null;
    }

    protected BasePersistence<?> getPersistence(String modelName) {
        int pos = modelName.lastIndexOf(".");
        String entityName = modelName.substring(pos + 1);
        pos = modelName.lastIndexOf(".model.");
        String packagePath = modelName.substring(0, pos);
        return (BasePersistence)PortalBeanLocatorUtil.locate((String)(packagePath + ".service.persistence." + entityName + "Persistence"));
    }

    protected File getPortalJspBackupFile(File portalJspFile) {
        String fileName = portalJspFile.toString();
        if (fileName.endsWith(".jsp")) {
            fileName = fileName.substring(0, fileName.length() - 4) + ".portal.jsp";
        } else if (fileName.endsWith(".jspf")) {
            fileName = fileName.substring(0, fileName.length() - 5) + ".portal.jspf";
        }
        return new File(fileName);
    }

    protected void initAuthenticators(ClassLoader portletClassLoader, Properties portalProperties, String key, AuthenticatorsContainer authenticatorsContainer) throws Exception {
        String[] authenticatorClassNames;
        for (String authenticatorClassName : authenticatorClassNames = StringUtil.split((String)portalProperties.getProperty(key))) {
            Authenticator authenticator = (Authenticator)portletClassLoader.loadClass(authenticatorClassName).newInstance();
            authenticator = (Authenticator)Proxy.newProxyInstance(portletClassLoader, new Class[]{Authenticator.class}, (InvocationHandler)new ContextClassLoaderBeanHandler((Object)authenticator, portletClassLoader));
            authenticatorsContainer.registerAuthenticator(key, authenticator);
        }
    }

    protected void initAuthenticators(String servletContextName, ClassLoader portletClassLoader, Properties portalProperties) throws Exception {
        AuthenticatorsContainer authenticatorsContainer = new AuthenticatorsContainer();
        this._authenticatorsContainerMap.put(servletContextName, authenticatorsContainer);
        this.initAuthenticators(portletClassLoader, portalProperties, "auth.pipeline.pre", authenticatorsContainer);
        this.initAuthenticators(portletClassLoader, portalProperties, "auth.pipeline.post", authenticatorsContainer);
    }

    protected void initAuthFailures(ClassLoader portletClassLoader, Properties portalProperties, String key, AuthFailuresContainer authFailuresContainer) throws Exception {
        String[] authFailureClassNames;
        for (String authFailureClassName : authFailureClassNames = StringUtil.split((String)portalProperties.getProperty(key))) {
            AuthFailure authFailure = (AuthFailure)portletClassLoader.loadClass(authFailureClassName).newInstance();
            authFailure = (AuthFailure)Proxy.newProxyInstance(portletClassLoader, new Class[]{AuthFailure.class}, (InvocationHandler)new ContextClassLoaderBeanHandler((Object)authFailure, portletClassLoader));
            authFailuresContainer.registerAuthFailure(key, authFailure);
        }
    }

    protected void initAuthFailures(String servletContextName, ClassLoader portletClassLoader, Properties portalProperties) throws Exception {
        AuthFailuresContainer authFailuresContainer = new AuthFailuresContainer();
        this._authFailuresContainerMap.put(servletContextName, authFailuresContainer);
        this.initAuthFailures(portletClassLoader, portalProperties, "auth.failure", authFailuresContainer);
        this.initAuthFailures(portletClassLoader, portalProperties, "auth.max.failures", authFailuresContainer);
    }

    protected void initAutoDeployListeners(String servletContextName, ClassLoader portletClassLoader, Properties portalProperties) throws Exception {
        String[] autoDeployListenerClassNames = StringUtil.split((String)portalProperties.getProperty("auto.deploy.listeners"));
        if (autoDeployListenerClassNames.length == 0) {
            return;
        }
        AutoDeployListenersContainer autoDeployListenersContainer = new AutoDeployListenersContainer();
        this._autoDeployListenersContainerMap.put(servletContextName, autoDeployListenersContainer);
        for (String autoDeployListenerClassName : autoDeployListenerClassNames) {
            AutoDeployListener autoDeployListener = (AutoDeployListener)portletClassLoader.loadClass(autoDeployListenerClassName).newInstance();
            autoDeployListener = (AutoDeployListener)Proxy.newProxyInstance(portletClassLoader, new Class[]{AutoDeployListener.class}, (InvocationHandler)new ContextClassLoaderBeanHandler((Object)autoDeployListener, portletClassLoader));
            autoDeployListenersContainer.registerAutoDeployListener(autoDeployListener);
        }
    }

    protected void initAutoLogins(String servletContextName, ClassLoader portletClassLoader, Properties portalProperties) throws Exception {
        String[] autoLoginClassNames;
        AutoLoginsContainer autoLoginsContainer = new AutoLoginsContainer();
        this._autoLoginsContainerMap.put(servletContextName, autoLoginsContainer);
        for (String autoLoginClassName : autoLoginClassNames = StringUtil.split((String)portalProperties.getProperty("auto.login.hooks"))) {
            AutoLogin autoLogin = (AutoLogin)portletClassLoader.loadClass(autoLoginClassName).newInstance();
            autoLogin = (AutoLogin)Proxy.newProxyInstance(portletClassLoader, new Class[]{AutoLogin.class}, (InvocationHandler)new ContextClassLoaderBeanHandler((Object)autoLogin, portletClassLoader));
            autoLoginsContainer.registerAutoLogin(autoLogin);
        }
    }

    protected void initCustomJspBag(CustomJspBag customJspBag) throws Exception {
        String customJspDir = customJspBag.getCustomJspDir();
        List<String> customJsps = customJspBag.getCustomJsps();
        String portalWebDir = PortalUtil.getPortalWebDir();
        for (String customJsp : customJsps) {
            int pos = customJsp.indexOf(customJspDir);
            String portalJsp = customJsp.substring(pos + customJspDir.length(), customJsp.length());
            File portalJspFile = new File(portalWebDir + portalJsp);
            File portalJspBackupFile = this.getPortalJspBackupFile(portalJspFile);
            if (portalJspFile.exists() && !portalJspBackupFile.exists()) {
                FileUtil.copyFile((File)portalJspFile, (File)portalJspBackupFile);
            }
            String customJspContent = FileUtil.read((String)customJsp);
            FileUtil.write((File)portalJspFile, (String)customJspContent);
        }
    }

    protected Object initEvent(String eventName, String eventClassName, ClassLoader portletClassLoader) throws Exception {
        if (eventName.equals("application.startup.events")) {
            long[] companyIds;
            SimpleAction simpleAction = (SimpleAction)portletClassLoader.loadClass(eventClassName).newInstance();
            simpleAction = new InvokerSimpleAction(simpleAction, portletClassLoader);
            long companyId = CompanyThreadLocal.getCompanyId();
            for (long curCompanyId : companyIds = PortalInstances.getCompanyIds()) {
                CompanyThreadLocal.setCompanyId((long)curCompanyId);
                simpleAction.run(new String[]{String.valueOf(curCompanyId)});
            }
            CompanyThreadLocal.setCompanyId((long)companyId);
            return null;
        }
        if (ArrayUtil.contains((Object[])_PROPS_KEYS_EVENTS, (Object)eventName)) {
            Action action = (Action)portletClassLoader.loadClass(eventClassName).newInstance();
            action = new InvokerAction(action, portletClassLoader);
            EventsProcessorUtil.registerEvent(eventName, action);
            return action;
        }
        if (ArrayUtil.contains((Object[])_PROPS_KEYS_SESSION_EVENTS, (Object)eventName)) {
            SessionAction sessionAction = (SessionAction)portletClassLoader.loadClass(eventClassName).newInstance();
            sessionAction = new InvokerSessionAction(sessionAction, portletClassLoader);
            EventsProcessorUtil.registerEvent(eventName, sessionAction);
            return sessionAction;
        }
        return null;
    }

    protected void initEvents(String servletContextName, ClassLoader portletClassLoader, Properties portalProperties) throws Exception {
        EventsContainer eventsContainer = new EventsContainer();
        this._eventsContainerMap.put(servletContextName, eventsContainer);
        for (String string : portalProperties.keySet()) {
            String[] eventClassNames;
            if (!string.equals("application.startup.events") && !ArrayUtil.contains((Object[])_PROPS_KEYS_EVENTS, (Object)string) && !ArrayUtil.contains((Object[])_PROPS_KEYS_SESSION_EVENTS, (Object)string)) continue;
            String eventName = string;
            for (String eventClassName : eventClassNames = StringUtil.split((String)portalProperties.getProperty(string))) {
                Object obj = this.initEvent(eventName, eventClassName, portletClassLoader);
                if (obj == null) continue;
                eventsContainer.registerEvent(eventName, obj);
            }
        }
    }

    protected void initHotDeployListeners(String servletContextName, ClassLoader portletClassLoader, Properties portalProperties) throws Exception {
        String[] hotDeployListenerClassNames = StringUtil.split((String)portalProperties.getProperty("hot.deploy.listeners"));
        if (hotDeployListenerClassNames.length == 0) {
            return;
        }
        HotDeployListenersContainer hotDeployListenersContainer = new HotDeployListenersContainer();
        this._hotDeployListenersContainerMap.put(servletContextName, hotDeployListenersContainer);
        for (String hotDeployListenerClassName : hotDeployListenerClassNames) {
            HotDeployListener hotDeployListener = (HotDeployListener)portletClassLoader.loadClass(hotDeployListenerClassName).newInstance();
            hotDeployListener = (HotDeployListener)Proxy.newProxyInstance(portletClassLoader, new Class[]{HotDeployListener.class}, (InvocationHandler)new ContextClassLoaderBeanHandler((Object)hotDeployListener, portletClassLoader));
            hotDeployListenersContainer.registerHotDeployListener(hotDeployListener);
        }
    }

    protected ModelListener<BaseModel<?>> initModelListener(String modelName, String modelListenerClassName, ClassLoader portletClassLoader) throws Exception {
        ModelListener modelListener = (ModelListener)portletClassLoader.loadClass(modelListenerClassName).newInstance();
        modelListener = (ModelListener)Proxy.newProxyInstance(portletClassLoader, new Class[]{ModelListener.class}, (InvocationHandler)new ContextClassLoaderBeanHandler((Object)modelListener, portletClassLoader));
        BasePersistence<?> persistence = this.getPersistence(modelName);
        persistence.registerListener(modelListener);
        return modelListener;
    }

    protected void initModelListeners(String servletContextName, ClassLoader portletClassLoader, Properties portalProperties) throws Exception {
        ModelListenersContainer modelListenersContainer = new ModelListenersContainer();
        this._modelListenersContainerMap.put(servletContextName, modelListenersContainer);
        for (String string : portalProperties.keySet()) {
            String modelListenerClassName;
            String modelName;
            ModelListener<BaseModel<?>> modelListener;
            if (!string.startsWith("value.object.listener.") || (modelListener = this.initModelListener(modelName = string.substring("value.object.listener.".length()), modelListenerClassName = portalProperties.getProperty(string), portletClassLoader)) == null) continue;
            modelListenersContainer.registerModelListener(modelName, modelListener);
        }
    }

    protected void initPortalProperties(String servletContextName, ClassLoader portletClassLoader, Properties portalProperties) throws Exception {
        PropsUtil.addProperties(portalProperties);
        if (_log.isDebugEnabled() && portalProperties.containsKey("locales")) {
            _log.debug((Object)("Portlet locales " + portalProperties.getProperty("locales")));
            _log.debug((Object)("Merged locales " + PropsUtil.get("locales")));
            _log.debug((Object)("Merged locales array length " + PropsUtil.getArray("locales").length));
        }
        this.resetPortalProperties(servletContextName, portalProperties, true);
        if (portalProperties.containsKey("control.panel.default.entry.class")) {
            String controlPanelEntryClassName = portalProperties.getProperty("control.panel.default.entry.class");
            ControlPanelEntry controlPanelEntry = (ControlPanelEntry)portletClassLoader.loadClass(controlPanelEntryClassName).newInstance();
            controlPanelEntry = (ControlPanelEntry)Proxy.newProxyInstance(portletClassLoader, new Class[]{ControlPanelEntry.class}, (InvocationHandler)new ContextClassLoaderBeanHandler((Object)controlPanelEntry, portletClassLoader));
            DefaultControlPanelEntryFactory.setInstance(controlPanelEntry);
        }
        if (portalProperties.containsKey("dl.hook.impl")) {
            String dlHookClassName = portalProperties.getProperty("dl.hook.impl");
            com.liferay.documentlibrary.util.Hook dlHook = (com.liferay.documentlibrary.util.Hook)portletClassLoader.loadClass(dlHookClassName).newInstance();
            dlHook = (com.liferay.documentlibrary.util.Hook)Proxy.newProxyInstance(portletClassLoader, new Class[]{com.liferay.documentlibrary.util.Hook.class}, (InvocationHandler)new ContextClassLoaderBeanHandler((Object)dlHook, portletClassLoader));
            com.liferay.documentlibrary.util.HookFactory.setInstance(dlHook);
        }
        if (portalProperties.containsKey("image.hook.impl")) {
            String imageHookClassName = portalProperties.getProperty("image.hook.impl");
            Hook imageHook = (Hook)portletClassLoader.loadClass(imageHookClassName).newInstance();
            imageHook = (Hook)Proxy.newProxyInstance(portletClassLoader, new Class[]{Hook.class}, (InvocationHandler)new ContextClassLoaderBeanHandler((Object)imageHook, portletClassLoader));
            HookFactory.setInstance(imageHook);
        }
        if (portalProperties.containsKey("ldap.attrs.transformer.impl")) {
            String attributesTransformerClassName = portalProperties.getProperty("ldap.attrs.transformer.impl");
            AttributesTransformer attributesTransformer = (AttributesTransformer)portletClassLoader.loadClass(attributesTransformerClassName).newInstance();
            attributesTransformer = (AttributesTransformer)Proxy.newProxyInstance(portletClassLoader, new Class[]{AttributesTransformer.class}, (InvocationHandler)new ContextClassLoaderBeanHandler((Object)attributesTransformer, portletClassLoader));
            AttributesTransformerFactory.setInstance(attributesTransformer);
        }
        if (portalProperties.containsKey("mail.hook.impl")) {
            String mailHookClassName = portalProperties.getProperty("mail.hook.impl");
            com.liferay.mail.util.Hook mailHook = (com.liferay.mail.util.Hook)portletClassLoader.loadClass(mailHookClassName).newInstance();
            mailHook = (com.liferay.mail.util.Hook)Proxy.newProxyInstance(portletClassLoader, new Class[]{com.liferay.mail.util.Hook.class}, (InvocationHandler)new ContextClassLoaderBeanHandler((Object)mailHook, portletClassLoader));
            com.liferay.mail.util.HookFactory.setInstance(mailHook);
        }
        if (portalProperties.containsKey("users.email.address.generator")) {
            String emailAddressGeneratorClassName = portalProperties.getProperty("users.email.address.generator");
            EmailAddressGenerator emailAddressGenerator = (EmailAddressGenerator)portletClassLoader.loadClass(emailAddressGeneratorClassName).newInstance();
            emailAddressGenerator = (EmailAddressGenerator)Proxy.newProxyInstance(portletClassLoader, new Class[]{EmailAddressGenerator.class}, (InvocationHandler)new ContextClassLoaderBeanHandler((Object)emailAddressGenerator, portletClassLoader));
            EmailAddressGeneratorFactory.setInstance(emailAddressGenerator);
        }
        if (portalProperties.containsKey("users.full.name.validator")) {
            String fullNameValidatorClassName = portalProperties.getProperty("users.full.name.validator");
            FullNameValidator fullNameValidator = (FullNameValidator)portletClassLoader.loadClass(fullNameValidatorClassName).newInstance();
            fullNameValidator = (FullNameValidator)Proxy.newProxyInstance(portletClassLoader, new Class[]{FullNameValidator.class}, (InvocationHandler)new ContextClassLoaderBeanHandler((Object)fullNameValidator, portletClassLoader));
            FullNameValidatorFactory.setInstance(fullNameValidator);
        }
        if (portalProperties.containsKey("users.screen.name.generator")) {
            String screenNameGeneratorClassName = portalProperties.getProperty("users.screen.name.generator");
            ScreenNameGenerator screenNameGenerator = (ScreenNameGenerator)portletClassLoader.loadClass(screenNameGeneratorClassName).newInstance();
            screenNameGenerator = (ScreenNameGenerator)Proxy.newProxyInstance(portletClassLoader, new Class[]{ScreenNameGenerator.class}, (InvocationHandler)new ContextClassLoaderBeanHandler((Object)screenNameGenerator, portletClassLoader));
            ScreenNameGeneratorFactory.setInstance(screenNameGenerator);
        }
        if (portalProperties.containsKey("users.screen.name.validator")) {
            String screenNameValidatorClassName = portalProperties.getProperty("users.screen.name.validator");
            ScreenNameValidator screenNameValidator = (ScreenNameValidator)portletClassLoader.loadClass(screenNameValidatorClassName).newInstance();
            screenNameValidator = (ScreenNameValidator)Proxy.newProxyInstance(portletClassLoader, new Class[]{ScreenNameValidator.class}, (InvocationHandler)new ContextClassLoaderBeanHandler((Object)screenNameValidator, portletClassLoader));
            ScreenNameValidatorFactory.setInstance(screenNameValidator);
        }
        if (portalProperties.containsKey("release.info.build.number") || portalProperties.containsKey("upgrade.processes")) {
            this.updateRelease(servletContextName, portletClassLoader, portalProperties);
        }
    }

    protected void resetPortalProperties(String servletContextName, Properties portalProperties, boolean initPhase) throws Exception {
        Object value;
        Field field;
        String fieldName;
        for (String key : _PROPS_VALUES_BOOLEAN) {
            fieldName = StringUtil.replace((String)key.toUpperCase(), (String)".", (String)"_");
            if (!this.containsKey(portalProperties, key)) continue;
            try {
                field = PropsValues.class.getField(fieldName);
                value = GetterUtil.getBoolean((String)PropsUtil.get(key));
                field.setBoolean(null, (Boolean)value);
            }
            catch (Exception e) {
                _log.error((Object)("Error setting field " + fieldName + ": " + e.getMessage()));
            }
        }
        for (String key : _PROPS_VALUES_INTEGER) {
            fieldName = StringUtil.replace((String)key.toUpperCase(), (String)".", (String)"_");
            if (!this.containsKey(portalProperties, key)) continue;
            try {
                field = PropsValues.class.getField(fieldName);
                value = GetterUtil.getInteger((String)PropsUtil.get(key));
                field.setInt(null, (Integer)value);
            }
            catch (Exception e) {
                _log.error((Object)("Error setting field " + fieldName + ": " + e.getMessage()));
            }
        }
        for (String key : _PROPS_VALUES_LONG) {
            fieldName = StringUtil.replace((String)key.toUpperCase(), (String)".", (String)"_");
            if (!this.containsKey(portalProperties, key)) continue;
            try {
                field = PropsValues.class.getField(fieldName);
                value = GetterUtil.getLong((String)PropsUtil.get(key));
                field.setLong(null, (Long)value);
            }
            catch (Exception e) {
                _log.error((Object)("Error setting field " + fieldName + ": " + e.getMessage()));
            }
        }
        for (String key : _PROPS_VALUES_STRING) {
            fieldName = StringUtil.replace((String)key.toUpperCase(), (String)".", (String)"_");
            if (!this.containsKey(portalProperties, key)) continue;
            try {
                field = PropsValues.class.getField(fieldName);
                value = GetterUtil.getString((String)PropsUtil.get(key));
                field.set(null, value);
            }
            catch (Exception e) {
                _log.error((Object)("Error setting field " + fieldName + ": " + e.getMessage()));
            }
        }
        for (String key : _PROPS_VALUES_STRING_ARRAY) {
            fieldName = StringUtil.replace((String)key.toUpperCase(), (String)".", (String)"_");
            if (!this.containsKey(portalProperties, key)) continue;
            try {
                field = PropsValues.class.getField(fieldName);
                StringArraysContainer stringArraysContainer = this._stringArraysContainerMap.get(key);
                String[] value2 = null;
                if (initPhase) {
                    value2 = PropsUtil.getArray(key);
                }
                stringArraysContainer.setPluginStringArray(servletContextName, value2);
                value2 = stringArraysContainer.getMergedStringArray();
                field.set(null, value2);
            }
            catch (Exception e) {
                _log.error((Object)("Error setting field " + fieldName + ": " + e.getMessage()));
            }
        }
        if (this.containsKey(portalProperties, "locales")) {
            PropsValues.LOCALES = PropsUtil.getArray("locales");
            LanguageUtil.init();
        }
        CacheUtil.clearCache();
    }

    protected void updateRelease(String servletContextName, ClassLoader portletClassLoader, Properties portalProperties) throws Exception {
        int buildNumber = GetterUtil.getInteger((String)portalProperties.getProperty("release.info.build.number"));
        if (buildNumber <= 0) {
            _log.error((Object)("Skipping upgrade processes for " + servletContextName + " because \"release.info.build.number\" is not specified"));
            return;
        }
        Release release = null;
        try {
            release = ReleaseLocalServiceUtil.getRelease((String)servletContextName, (int)buildNumber);
        }
        catch (PortalException pe) {
            int previousBuildNumber = GetterUtil.getInteger((String)portalProperties.getProperty("release.info.previous.build.number"), (int)buildNumber);
            release = ReleaseLocalServiceUtil.addRelease((String)servletContextName, (int)previousBuildNumber);
        }
        if (buildNumber == release.getBuildNumber()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping upgrade processes for " + servletContextName + " because it is already up to date"));
            }
        } else {
            if (buildNumber < release.getBuildNumber()) {
                throw new UpgradeException("Skipping upgrade processes for " + servletContextName + " because you are trying to upgrade with an older version");
            }
            String[] upgradeProcessClassNames = StringUtil.split((String)portalProperties.getProperty("upgrade.processes"));
            UpgradeProcessUtil.upgradeProcess(release.getBuildNumber(), upgradeProcessClassNames, portletClassLoader);
        }
        ReleaseLocalServiceUtil.updateRelease((long)release.getReleaseId(), (int)buildNumber, null, (boolean)true);
    }

    private class StringArraysContainer {
        private String[] _portalStringArray;
        private Map<String, String[]> _pluginStringArrayMap = new HashMap<String, String[]>();

        private StringArraysContainer(String key) {
            this._portalStringArray = PropsUtil.getArray(key);
        }

        public String[] getMergedStringArray() {
            UniqueList mergedStringList = new UniqueList();
            mergedStringList.addAll(ListUtil.fromArray((Object[])this._portalStringArray));
            for (Map.Entry<String, String[]> entry : this._pluginStringArrayMap.entrySet()) {
                Object[] pluginStringArray = entry.getValue();
                mergedStringList.addAll(ListUtil.fromArray((Object[])pluginStringArray));
            }
            return mergedStringList.toArray(new String[mergedStringList.size()]);
        }

        public void setPluginStringArray(String servletContextName, String[] pluginStringArray) {
            if (pluginStringArray != null) {
                this._pluginStringArrayMap.put(servletContextName, pluginStringArray);
            } else {
                this._pluginStringArrayMap.remove(servletContextName);
            }
        }
    }

    private class ServicesContainer {
        private List<String> _serviceTypes = new ArrayList<String>();

        private ServicesContainer() {
        }

        public void addService(String serviceType, Object serviceImplInstance) {
            ServiceHookAdvice.setService(serviceType, serviceImplInstance);
            this._serviceTypes.add(serviceType);
        }

        public void unregisterServices() {
            for (String serviceType : this._serviceTypes) {
                ServiceHookAdvice.setService(serviceType, null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModelListenersContainer {
        private Map<String, List<ModelListener<BaseModel<?>>>> _modelListenersMap = new HashMap();

        private ModelListenersContainer() {
        }

        public void registerModelListener(String modelName, ModelListener<BaseModel<?>> modelListener) {
            List<ModelListener<BaseModel<?>>> modelListeners = this._modelListenersMap.get(modelName);
            if (modelListeners == null) {
                modelListeners = new ArrayList();
                this._modelListenersMap.put(modelName, modelListeners);
            }
            modelListeners.add(modelListener);
        }

        public void unregisterModelListeners() {
            for (Map.Entry<String, List<ModelListener<BaseModel<?>>>> entry : this._modelListenersMap.entrySet()) {
                String modelName = entry.getKey();
                List<ModelListener<BaseModel<?>>> modelListeners = entry.getValue();
                BasePersistence<?> persistence = HookHotDeployListener.this.getPersistence(modelName);
                for (ModelListener<BaseModel<?>> modelListener : modelListeners) {
                    persistence.unregisterListener(modelListener);
                }
            }
        }
    }

    private class LanguagesContainer {
        private Map<String, Properties> _languagesMap = new HashMap<String, Properties>();
        private MultiMessageResources _multiMessageResources = MultiMessageResourcesFactory.getInstance();

        private LanguagesContainer() {
        }

        public void addLanguage(String localeKey, Properties properties) {
            this._multiMessageResources.putLocale(localeKey);
            Properties oldProperties = this._multiMessageResources.putMessages(properties, localeKey);
            this._languagesMap.put(localeKey, oldProperties);
            LanguageResources.clearCache();
        }

        public void unregisterLanguages() {
            for (String key : this._languagesMap.keySet()) {
                Properties properties = this._languagesMap.get(key);
                this._multiMessageResources.putMessages(properties, key);
            }
            LanguageResources.clearCache();
        }
    }

    private class HotDeployListenersContainer {
        private List<HotDeployListener> _hotDeployListeners = new ArrayList<HotDeployListener>();

        private HotDeployListenersContainer() {
        }

        public void registerHotDeployListener(HotDeployListener hotDeployListener) {
            HotDeployUtil.registerListener((HotDeployListener)hotDeployListener);
            this._hotDeployListeners.add(hotDeployListener);
        }

        public void unregisterHotDeployListeners() {
            for (HotDeployListener hotDeployListener : this._hotDeployListeners) {
                HotDeployUtil.unregisterListener((HotDeployListener)hotDeployListener);
            }
        }
    }

    private class EventsContainer {
        private Map<String, List<Object>> _eventsMap = new HashMap<String, List<Object>>();

        private EventsContainer() {
        }

        public void registerEvent(String eventName, Object event) {
            List<Object> events = this._eventsMap.get(eventName);
            if (events == null) {
                events = new ArrayList<Object>();
                this._eventsMap.put(eventName, events);
            }
            events.add(event);
        }

        public void unregisterEvents() {
            for (Map.Entry<String, List<Object>> entry : this._eventsMap.entrySet()) {
                String eventName = entry.getKey();
                List<Object> events = entry.getValue();
                for (Object event : events) {
                    EventsProcessorUtil.unregisterEvent(eventName, event);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CustomJspBag {
        private String _customJspDir;
        private List<String> _customJsps;

        public CustomJspBag(String customJspDir, List<String> customJsps) {
            this._customJspDir = customJspDir;
            this._customJsps = customJsps;
        }

        public String getCustomJspDir() {
            return this._customJspDir;
        }

        public List<String> getCustomJsps() {
            return this._customJsps;
        }
    }

    private class AutoLoginsContainer {
        List<AutoLogin> _autoLogins = new ArrayList<AutoLogin>();

        private AutoLoginsContainer() {
        }

        public void registerAutoLogin(AutoLogin autoLogin) {
            AutoLoginFilter.registerAutoLogin(autoLogin);
            this._autoLogins.add(autoLogin);
        }

        public void unregisterAutoLogins() {
            for (AutoLogin autoLogin : this._autoLogins) {
                AutoLoginFilter.unregisterAutoLogin(autoLogin);
            }
        }
    }

    private class AutoDeployListenersContainer {
        private List<AutoDeployListener> _autoDeployListeners = new ArrayList<AutoDeployListener>();

        private AutoDeployListenersContainer() {
        }

        public void registerAutoDeployListener(AutoDeployListener autoDeployListener) {
            AutoDeployDir autoDeployDir = AutoDeployUtil.getDir((String)"defaultAutoDeployDir");
            if (autoDeployDir == null) {
                return;
            }
            autoDeployDir.registerListener(autoDeployListener);
            this._autoDeployListeners.add(autoDeployListener);
        }

        public void unregisterAutoDeployListeners() {
            AutoDeployDir autoDeployDir = AutoDeployUtil.getDir((String)"defaultAutoDeployDir");
            if (autoDeployDir == null) {
                return;
            }
            for (AutoDeployListener autoDeployListener : this._autoDeployListeners) {
                autoDeployDir.unregisterListener(autoDeployListener);
            }
        }
    }

    private class AuthFailuresContainer {
        Map<String, List<AuthFailure>> _authFailures = new HashMap<String, List<AuthFailure>>();

        private AuthFailuresContainer() {
        }

        public void registerAuthFailure(String key, AuthFailure authFailure) {
            List<AuthFailure> authFailures = this._authFailures.get(key);
            if (authFailures == null) {
                authFailures = new ArrayList<AuthFailure>();
                this._authFailures.put(key, authFailures);
            }
            AuthPipeline.registerAuthFailure(key, authFailure);
            authFailures.add(authFailure);
        }

        public void unregisterAuthFailures() {
            for (Map.Entry<String, List<AuthFailure>> entry : this._authFailures.entrySet()) {
                String key = entry.getKey();
                List<AuthFailure> authFailures = entry.getValue();
                for (AuthFailure authFailure : authFailures) {
                    AuthPipeline.unregisterAuthFailure(key, authFailure);
                }
            }
        }
    }

    private class AuthenticatorsContainer {
        Map<String, List<Authenticator>> _authenticators = new HashMap<String, List<Authenticator>>();

        private AuthenticatorsContainer() {
        }

        public void registerAuthenticator(String key, Authenticator authenticator) {
            List<Authenticator> authenticators = this._authenticators.get(key);
            if (authenticators == null) {
                authenticators = new ArrayList<Authenticator>();
                this._authenticators.put(key, authenticators);
            }
            AuthPipeline.registerAuthenticator(key, authenticator);
            authenticators.add(authenticator);
        }

        public void unregisterAuthenticators() {
            for (Map.Entry<String, List<Authenticator>> entry : this._authenticators.entrySet()) {
                String key = entry.getKey();
                List<Authenticator> authenticators = entry.getValue();
                for (Authenticator authenticator : authenticators) {
                    AuthPipeline.unregisterAuthenticator(key, authenticator);
                }
            }
        }
    }
}

