/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.service.LayoutTemplateLocalServiceUtil;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;

public class LayoutTemplateHotDeployListener
extends BaseHotDeployListener {
    private static Log _log = LogFactoryUtil.getLog(LayoutTemplateHotDeployListener.class);
    private static Map<String, List<ObjectValuePair<String, Boolean>>> _vars = new HashMap<String, List<ObjectValuePair<String, Boolean>>>();

    public void invokeDeploy(HotDeployEvent event) throws HotDeployException {
        try {
            this.doInvokeDeploy(event);
        }
        catch (Throwable t) {
            this.throwHotDeployException(event, "Error registering layout templates for ", t);
        }
    }

    public void invokeUndeploy(HotDeployEvent event) throws HotDeployException {
        try {
            this.doInvokeUndeploy(event);
        }
        catch (Throwable t) {
            this.throwHotDeployException(event, "Error unregistering layout templates for ", t);
        }
    }

    protected void doInvokeDeploy(HotDeployEvent event) throws Exception {
        String[] xmls;
        ServletContext servletContext = event.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking deploy for " + servletContextName));
        }
        if ((xmls = new String[]{HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-layout-templates.xml"))})[0] == null) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Registering layout templates for " + servletContextName));
        }
        List layoutTemplateIds = LayoutTemplateLocalServiceUtil.init((String)servletContextName, (ServletContext)servletContext, (String[])xmls, (PluginPackage)event.getPluginPackage());
        _vars.put(servletContextName, layoutTemplateIds);
        if (_log.isInfoEnabled()) {
            if (layoutTemplateIds.size() == 1) {
                _log.info((Object)("1 layout template for " + servletContextName + " is available for use"));
            } else {
                _log.info((Object)(layoutTemplateIds.size() + " layout templates for " + servletContextName + " are available for use"));
            }
        }
    }

    protected void doInvokeUndeploy(HotDeployEvent event) throws Exception {
        List<ObjectValuePair<String, Boolean>> layoutTemplateIds;
        ServletContext servletContext = event.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking undeploy for " + servletContextName));
        }
        if ((layoutTemplateIds = _vars.get(servletContextName)) == null) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Unregistering layout templates for " + servletContextName));
        }
        for (ObjectValuePair<String, Boolean> ovp : layoutTemplateIds) {
            String layoutTemplateId = (String)ovp.getKey();
            Boolean standard = (Boolean)ovp.getValue();
            try {
                LayoutTemplateLocalServiceUtil.uninstallLayoutTemplate((String)layoutTemplateId, (boolean)standard);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        if (_log.isInfoEnabled()) {
            if (layoutTemplateIds.size() == 1) {
                _log.info((Object)("1 layout template for " + servletContextName + " was unregistered"));
            } else {
                _log.info((Object)(layoutTemplateIds.size() + " layout templates for " + servletContextName + " was unregistered"));
            }
        }
    }
}

