/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.portal.apache.bridges.struts.LiferayServletContextProvider;
import com.liferay.portal.kernel.bean.ContextClassLoaderBeanHandler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.job.Scheduler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.poller.PollerProcessor;
import com.liferay.portal.kernel.pop.MessageListener;
import com.liferay.portal.kernel.portlet.ConfigurationAction;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.portlet.PortletLayoutListener;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.OpenSearch;
import com.liferay.portal.kernel.servlet.URLEncoder;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.lar.PortletDataHandler;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.model.PortletCategory;
import com.liferay.portal.model.PortletURLListener;
import com.liferay.portal.poller.PollerProcessorUtil;
import com.liferay.portal.pop.POPServerUtil;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.service.ResourceCodeLocalServiceUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.WebAppPool;
import com.liferay.portal.velocity.VelocityContextPool;
import com.liferay.portal.webdav.WebDAVStorage;
import com.liferay.portal.webdav.WebDAVUtil;
import com.liferay.portlet.ControlPanelEntry;
import com.liferay.portlet.CustomUserAttributes;
import com.liferay.portlet.PortletBagImpl;
import com.liferay.portlet.PortletConfigFactory;
import com.liferay.portlet.PortletContextBag;
import com.liferay.portlet.PortletContextBagPool;
import com.liferay.portlet.PortletFilterFactory;
import com.liferay.portlet.PortletInstanceFactoryUtil;
import com.liferay.portlet.PortletPreferencesSerializer;
import com.liferay.portlet.PortletResourceBundles;
import com.liferay.portlet.PortletURLListenerFactory;
import com.liferay.portlet.social.model.SocialActivityInterpreter;
import com.liferay.portlet.social.model.SocialRequestInterpreter;
import com.liferay.portlet.social.model.impl.SocialActivityInterpreterImpl;
import com.liferay.portlet.social.model.impl.SocialRequestInterpreterImpl;
import com.liferay.portlet.social.service.SocialActivityInterpreterLocalServiceUtil;
import com.liferay.portlet.social.service.SocialRequestInterpreterLocalServiceUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletURLGenerationListener;
import javax.portlet.PreferencesValidator;
import javax.portlet.filter.PortletFilter;
import javax.servlet.ServletContext;
import org.apache.portals.bridges.struts.StrutsPortlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletHotDeployListener
extends BaseHotDeployListener {
    private static Log _log = LogFactoryUtil.getLog(PortletHotDeployListener.class);
    private static Map<String, ObjectValuePair<long[], List<com.liferay.portal.model.Portlet>>> _vars = new HashMap<String, ObjectValuePair<long[], List<com.liferay.portal.model.Portlet>>>();
    private boolean _portletAppInitialized;
    private boolean _strutsBridges;

    public void invokeDeploy(HotDeployEvent event) throws HotDeployException {
        try {
            this.doInvokeDeploy(event);
        }
        catch (Throwable t) {
            this.throwHotDeployException(event, "Error registering portlets for ", t);
        }
    }

    public void invokeUndeploy(HotDeployEvent event) throws HotDeployException {
        try {
            this.doInvokeUndeploy(event);
        }
        catch (Throwable t) {
            this.throwHotDeployException(event, "Error unregistering portlets for ", t);
        }
    }

    protected void destroyPortlet(com.liferay.portal.model.Portlet portlet, Set<String> portletIds) throws Exception {
        Scheduler scheduler;
        PortletApp portletApp = portlet.getPortletApp();
        Set portletFilters = portletApp.getPortletFilters();
        for (com.liferay.portal.model.PortletFilter portletFilter : portletFilters) {
            PortletFilterFactory.destroy(portletFilter);
        }
        Set portletURLListeners = portletApp.getPortletURLListeners();
        for (PortletURLListener portletURLListener : portletURLListeners) {
            PortletURLListenerFactory.destroy(portletURLListener);
        }
        Indexer indexer = portlet.getIndexerInstance();
        if (indexer != null) {
            for (String className : indexer.getClassNames()) {
                IndexerRegistryUtil.unregister((String)className);
            }
        }
        if ((scheduler = portlet.getSchedulerInstance()) != null) {
            scheduler.unschedule();
        }
        PollerProcessorUtil.deletePollerProcessor(portlet.getPortletId());
        POPServerUtil.deleteListener(portlet.getPopMessageListenerInstance());
        SocialActivityInterpreterLocalServiceUtil.deleteActivityInterpreter((SocialActivityInterpreter)portlet.getSocialActivityInterpreterInstance());
        SocialRequestInterpreterLocalServiceUtil.deleteRequestInterpreter((SocialRequestInterpreter)portlet.getSocialRequestInterpreterInstance());
        WebDAVUtil.deleteStorage((WebDAVStorage)portlet.getWebDAVStorageInstance());
        PortletInstanceFactoryUtil.destroy((com.liferay.portal.model.Portlet)portlet);
        portletIds.add(portlet.getPortletId());
    }

    protected void doInvokeDeploy(HotDeployEvent event) throws Exception {
        ServletContext servletContext = event.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking deploy for " + servletContextName));
        }
        long[] companyIds = PortalInstances.getCompanyIds();
        String[] xmls = new String[]{HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/portlet.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/portlet-custom.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-portlet.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/web.xml"))};
        if (xmls[0] == null) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Registering portlets for " + servletContextName));
        }
        List portlets = PortletLocalServiceUtil.initWAR((String)servletContextName, (ServletContext)servletContext, (String[])xmls, (PluginPackage)event.getPluginPackage());
        ClassLoader portletClassLoader = event.getContextClassLoader();
        servletContext.setAttribute("PORTLET_CLASS_LOADER", (Object)portletClassLoader);
        this._portletAppInitialized = false;
        this._strutsBridges = false;
        Iterator<Object> itr = portlets.iterator();
        while (itr.hasNext()) {
            com.liferay.portal.model.Portlet portlet = (com.liferay.portal.model.Portlet)itr.next();
            this.initPortlet(portlet, servletContext, portletClassLoader, itr);
        }
        if (!this._strutsBridges) {
            this._strutsBridges = GetterUtil.getBoolean((String)servletContext.getInitParameter("struts-bridges-context-provider"));
        }
        if (this._strutsBridges) {
            servletContext.setAttribute("STRUTS_BRIDGES_CONTEXT_PROVIDER", (Object)new LiferayServletContextProvider());
        }
        String xml = HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-display.xml"));
        PortletCategory newPortletCategory = PortletLocalServiceUtil.getWARDisplay((String)servletContextName, (String)xml);
        for (int i = 0; i < companyIds.length; ++i) {
            long companyId = companyIds[i];
            PortletCategory portletCategory = (PortletCategory)WebAppPool.get(String.valueOf(companyId), "PORTLET_CATEGORY");
            if (portletCategory != null) {
                portletCategory.merge(newPortletCategory);
                continue;
            }
            _log.error((Object)("Unable to register portlet for company " + companyId + " because it does not exist"));
        }
        this.processPortletProperties(servletContextName, portletClassLoader);
        for (com.liferay.portal.model.Portlet portlet : portlets) {
            List<String> modelNames = ResourceActionsUtil.getPortletModelResources(portlet.getPortletId());
            for (long companyId : companyIds) {
                ResourceCodeLocalServiceUtil.checkResourceCodes((long)companyId, (String)portlet.getPortletId());
                for (String modelName : modelNames) {
                    ResourceCodeLocalServiceUtil.checkResourceCodes((long)companyId, (String)modelName);
                }
            }
            List<String> portletActions = ResourceActionsUtil.getPortletResourceActions(portlet.getPortletId());
            ResourceActionLocalServiceUtil.checkResourceActions((String)portlet.getPortletId(), portletActions);
            for (String modelName : modelNames) {
                List<String> modelActions = ResourceActionsUtil.getModelResourceActions(modelName);
                ResourceActionLocalServiceUtil.checkResourceActions((String)modelName, modelActions);
            }
        }
        this.registerClpMessageListeners(servletContext, portletClassLoader);
        _vars.put(servletContextName, (ObjectValuePair<long[], List<com.liferay.portal.model.Portlet>>)new ObjectValuePair((Object)companyIds, (Object)portlets));
        if (_log.isInfoEnabled()) {
            if (portlets.size() == 1) {
                _log.info((Object)("1 portlet for " + servletContextName + " is available for use"));
            } else {
                _log.info((Object)(portlets.size() + " portlets for " + servletContextName + " are available for use"));
            }
        }
    }

    protected void doInvokeUndeploy(HotDeployEvent event) throws Exception {
        ObjectValuePair<long[], List<com.liferay.portal.model.Portlet>> ovp;
        ServletContext servletContext = event.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking undeploy for " + servletContextName));
        }
        if ((ovp = _vars.remove(servletContextName)) == null) {
            return;
        }
        long[] companyIds = (long[])ovp.getKey();
        List portlets = (List)ovp.getValue();
        HashSet<String> portletIds = new HashSet<String>();
        if (portlets != null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Unregistering portlets for " + servletContextName));
            }
            for (com.liferay.portal.model.Portlet portlet : portlets) {
                this.destroyPortlet(portlet, portletIds);
            }
        }
        if (portletIds.size() > 0) {
            for (int i = 0; i < companyIds.length; ++i) {
                long companyId = companyIds[i];
                PortletCategory portletCategory = (PortletCategory)WebAppPool.get(String.valueOf(companyId), "PORTLET_CATEGORY");
                portletCategory.separate(portletIds);
            }
        }
        PortletResourceBundles.remove(servletContextName);
        this.unregisterClpMessageListeners(servletContext);
        if (_log.isInfoEnabled()) {
            if (portlets.size() == 1) {
                _log.info((Object)("1 portlet for " + servletContextName + " was unregistered"));
            } else {
                _log.info((Object)(portlets.size() + " portlets for " + servletContextName + " was unregistered"));
            }
        }
    }

    protected void initPortlet(com.liferay.portal.model.Portlet portlet, ServletContext servletContext, ClassLoader portletClassLoader, Iterator<com.liferay.portal.model.Portlet> portletsItr) throws Exception {
        String servletContextName = servletContext.getServletContextName();
        PortletApp portletApp = portlet.getPortletApp();
        if (!portletApp.isWARFile()) {
            String contextPath = PortalUtil.getPathContext();
            servletContext = VelocityContextPool.get(contextPath);
            portletClassLoader = PortalClassLoaderUtil.getClassLoader();
        }
        Class<?> portletClass = null;
        try {
            portletClass = portletClassLoader.loadClass(portlet.getPortletClass());
        }
        catch (Throwable e) {
            _log.error((Object)e, e);
            portletsItr.remove();
            PortletLocalServiceUtil.destroyPortlet((com.liferay.portal.model.Portlet)portlet);
            return;
        }
        Portlet portletInstance = (Portlet)portletClass.newInstance();
        if (ClassUtil.isSubclass(portletClass, (String)StrutsPortlet.class.getName())) {
            this._strutsBridges = true;
        }
        ConfigurationAction configurationActionInstance = null;
        if (Validator.isNotNull((String)portlet.getConfigurationActionClass())) {
            configurationActionInstance = (ConfigurationAction)portletClassLoader.loadClass(portlet.getConfigurationActionClass()).newInstance();
        }
        Indexer indexerInstance = null;
        if (Validator.isNotNull((String)portlet.getIndexerClass())) {
            indexerInstance = (Indexer)portletClassLoader.loadClass(portlet.getIndexerClass()).newInstance();
            indexerInstance = (Indexer)Proxy.newProxyInstance(portletClassLoader, new Class[]{Indexer.class}, (InvocationHandler)new ContextClassLoaderBeanHandler((Object)indexerInstance, portletClassLoader));
            for (String className : indexerInstance.getClassNames()) {
                IndexerRegistryUtil.register((String)className, (Indexer)indexerInstance);
            }
        }
        OpenSearch openSearchInstance = null;
        if (Validator.isNotNull((String)portlet.getOpenSearchClass())) {
            openSearchInstance = (OpenSearch)portletClassLoader.loadClass(portlet.getOpenSearchClass()).newInstance();
        }
        Scheduler schedulerInstance = null;
        if (PropsValues.SCHEDULER_ENABLED && Validator.isNotNull((String)portlet.getSchedulerClass())) {
            schedulerInstance = (Scheduler)portletClassLoader.loadClass(portlet.getSchedulerClass()).newInstance();
            schedulerInstance.schedule();
        }
        FriendlyURLMapper friendlyURLMapperInstance = null;
        if (Validator.isNotNull((String)portlet.getFriendlyURLMapperClass())) {
            friendlyURLMapperInstance = (FriendlyURLMapper)portletClassLoader.loadClass(portlet.getFriendlyURLMapperClass()).newInstance();
        }
        URLEncoder urlEncoderInstance = null;
        if (Validator.isNotNull((String)portlet.getURLEncoderClass())) {
            urlEncoderInstance = (URLEncoder)portletClassLoader.loadClass(portlet.getURLEncoderClass()).newInstance();
        }
        PortletDataHandler portletDataHandlerInstance = null;
        if (Validator.isNotNull((String)portlet.getPortletDataHandlerClass())) {
            portletDataHandlerInstance = (PortletDataHandler)portletClassLoader.loadClass(portlet.getPortletDataHandlerClass()).newInstance();
            portletDataHandlerInstance = (PortletDataHandler)Proxy.newProxyInstance(portletClassLoader, new Class[]{PortletDataHandler.class}, (InvocationHandler)new ContextClassLoaderBeanHandler((Object)portletDataHandlerInstance, portletClassLoader));
        }
        PortletLayoutListener portletLayoutListenerInstance = null;
        if (Validator.isNotNull((String)portlet.getPortletLayoutListenerClass())) {
            portletLayoutListenerInstance = (PortletLayoutListener)portletClassLoader.loadClass(portlet.getPortletLayoutListenerClass()).newInstance();
        }
        PollerProcessor pollerProcessorInstance = null;
        if (Validator.isNotNull((String)portlet.getPollerProcessorClass())) {
            pollerProcessorInstance = (PollerProcessor)portletClassLoader.loadClass(portlet.getPollerProcessorClass()).newInstance();
            pollerProcessorInstance = (PollerProcessor)Proxy.newProxyInstance(portletClassLoader, new Class[]{PollerProcessor.class}, (InvocationHandler)new ContextClassLoaderBeanHandler((Object)pollerProcessorInstance, portletClassLoader));
            PollerProcessorUtil.addPollerProcessor(portlet.getPortletId(), pollerProcessorInstance);
        }
        MessageListener popMessageListenerInstance = null;
        if (Validator.isNotNull((String)portlet.getPopMessageListenerClass())) {
            popMessageListenerInstance = (MessageListener)portletClassLoader.loadClass(portlet.getPopMessageListenerClass()).newInstance();
            POPServerUtil.addListener(popMessageListenerInstance);
        }
        SocialActivityInterpreter socialActivityInterpreterInstance = null;
        if (Validator.isNotNull((String)portlet.getSocialActivityInterpreterClass())) {
            socialActivityInterpreterInstance = (SocialActivityInterpreter)portletClassLoader.loadClass(portlet.getSocialActivityInterpreterClass()).newInstance();
            socialActivityInterpreterInstance = new SocialActivityInterpreterImpl(portlet.getPortletId(), socialActivityInterpreterInstance);
            SocialActivityInterpreterLocalServiceUtil.addActivityInterpreter((SocialActivityInterpreter)socialActivityInterpreterInstance);
        }
        SocialRequestInterpreter socialRequestInterpreterInstance = null;
        if (Validator.isNotNull((String)portlet.getSocialRequestInterpreterClass())) {
            socialRequestInterpreterInstance = (SocialRequestInterpreter)portletClassLoader.loadClass(portlet.getSocialRequestInterpreterClass()).newInstance();
            socialRequestInterpreterInstance = new SocialRequestInterpreterImpl(portlet.getPortletId(), socialRequestInterpreterInstance);
            SocialRequestInterpreterLocalServiceUtil.addRequestInterpreter((SocialRequestInterpreter)socialRequestInterpreterInstance);
        }
        WebDAVStorage webDAVStorageInstance = null;
        if (Validator.isNotNull((String)portlet.getWebDAVStorageClass())) {
            webDAVStorageInstance = (WebDAVStorage)portletClassLoader.loadClass(portlet.getWebDAVStorageClass()).newInstance();
            webDAVStorageInstance.setToken(portlet.getWebDAVStorageToken());
            WebDAVUtil.addStorage((WebDAVStorage)webDAVStorageInstance);
        }
        ControlPanelEntry controlPanelEntryInstance = null;
        if (Validator.isNotNull((String)portlet.getControlPanelEntryClass())) {
            controlPanelEntryInstance = (ControlPanelEntry)portletClassLoader.loadClass(portlet.getControlPanelEntryClass()).newInstance();
        }
        PreferencesValidator preferencesValidatorInstance = null;
        if (Validator.isNotNull((String)portlet.getPreferencesValidator())) {
            preferencesValidatorInstance = (PreferencesValidator)portletClassLoader.loadClass(portlet.getPreferencesValidator()).newInstance();
            try {
                if (PropsValues.PREFERENCE_VALIDATE_ON_STARTUP) {
                    preferencesValidatorInstance.validate(PortletPreferencesSerializer.fromDefaultXML(portlet.getDefaultPreferences()));
                }
            }
            catch (Exception e) {
                _log.warn((Object)("Portlet with the name " + portlet.getPortletId() + " does not have valid default preferences"));
            }
        }
        HashMap<String, ResourceBundle> resourceBundles = null;
        if (Validator.isNotNull((String)portlet.getResourceBundle())) {
            resourceBundles = new HashMap<String, ResourceBundle>();
            this.initResourceBundle(resourceBundles, portlet, portletClassLoader, LocaleUtil.getDefault());
            for (String supportedLocale : portlet.getSupportedLocales()) {
                Locale locale = LocaleUtil.fromLanguageId((String)supportedLocale);
                this.initResourceBundle(resourceBundles, portlet, portletClassLoader, locale);
            }
        }
        PortletBagImpl portletBag = new PortletBagImpl(portlet.getPortletId(), servletContext, portletInstance, configurationActionInstance, indexerInstance, openSearchInstance, schedulerInstance, friendlyURLMapperInstance, urlEncoderInstance, portletDataHandlerInstance, portletLayoutListenerInstance, pollerProcessorInstance, popMessageListenerInstance, socialActivityInterpreterInstance, socialRequestInterpreterInstance, webDAVStorageInstance, controlPanelEntryInstance, preferencesValidatorInstance, resourceBundles);
        PortletBagPool.put((String)portlet.getPortletId(), (PortletBag)portletBag);
        if (!this._portletAppInitialized) {
            this.initPortletApp(portlet, servletContextName, servletContext, portletClassLoader);
            this._portletAppInitialized = true;
        }
        try {
            PortletInstanceFactoryUtil.create((com.liferay.portal.model.Portlet)portlet, (ServletContext)servletContext);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void initPortletApp(com.liferay.portal.model.Portlet portlet, String servletContextName, ServletContext servletContext, ClassLoader portletClassLoader) throws Exception {
        PortletConfig portletConfig = PortletConfigFactory.create(portlet, servletContext);
        PortletContext portletContext = portletConfig.getPortletContext();
        PortletContextBag portletContextBag = new PortletContextBag(servletContextName);
        PortletContextBagPool.put(servletContextName, portletContextBag);
        PortletApp portletApp = portlet.getPortletApp();
        Map customUserAttributes = portletApp.getCustomUserAttributes();
        for (Map.Entry entry : customUserAttributes.entrySet()) {
            String attrCustomClass = (String)entry.getValue();
            CustomUserAttributes customUserAttributesInstance = (CustomUserAttributes)portletClassLoader.loadClass(attrCustomClass).newInstance();
            portletContextBag.getCustomUserAttributes().put(attrCustomClass, customUserAttributesInstance);
        }
        Set portletFilters = portletApp.getPortletFilters();
        for (com.liferay.portal.model.PortletFilter portletFilter : portletFilters) {
            PortletFilter portletFilterInstance = (PortletFilter)portletClassLoader.loadClass(portletFilter.getFilterClass()).newInstance();
            portletContextBag.getPortletFilters().put(portletFilter.getFilterName(), portletFilterInstance);
            PortletFilterFactory.create(portletFilter, portletContext);
        }
        Set portletURLListeners = portletApp.getPortletURLListeners();
        for (PortletURLListener portletURLListener : portletURLListeners) {
            PortletURLGenerationListener portletURLListenerInstance = (PortletURLGenerationListener)portletClassLoader.loadClass(portletURLListener.getListenerClass()).newInstance();
            portletContextBag.getPortletURLListeners().put(portletURLListener.getListenerClass(), portletURLListenerInstance);
            PortletURLListenerFactory.create(portletURLListener);
        }
    }

    protected void initResourceBundle(Map<String, ResourceBundle> resourceBundles, com.liferay.portal.model.Portlet portlet, ClassLoader portletClassLoader, Locale locale) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(portlet.getResourceBundle(), locale, portletClassLoader);
            resourceBundles.put(LocaleUtil.toLanguageId((Locale)locale), resourceBundle);
        }
        catch (MissingResourceException mre) {
            _log.warn((Object)mre.getMessage());
        }
    }

    protected void processPortletProperties(String servletContextName, ClassLoader portletClassLoader) throws Exception {
        int i;
        Configuration portletPropertiesConfiguration = null;
        try {
            portletPropertiesConfiguration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)portletClassLoader, (String)"portlet");
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to read portlet.properties");
            }
            return;
        }
        Properties portletProperties = portletPropertiesConfiguration.getProperties();
        if (portletProperties.size() == 0) {
            return;
        }
        String languageBundleName = portletProperties.getProperty("language.bundle");
        if (Validator.isNotNull((String)languageBundleName)) {
            Locale[] locales = LanguageUtil.getAvailableLocales();
            for (i = 0; i < locales.length; ++i) {
                ResourceBundle bundle = ResourceBundle.getBundle(languageBundleName, locales[i], portletClassLoader);
                PortletResourceBundles.put(servletContextName, LocaleUtil.toLanguageId((Locale)locales[i]), bundle);
            }
        }
        String[] resourceActionConfigs = StringUtil.split((String)portletProperties.getProperty("resource.actions.configs"));
        for (i = 0; i < resourceActionConfigs.length; ++i) {
            ResourceActionsUtil.read(servletContextName, portletClassLoader, resourceActionConfigs[i]);
        }
    }
}

