/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.service.ThemeLocalServiceUtil;
import com.liferay.portal.velocity.LiferayResourceCacheUtil;
import com.liferay.portal.velocity.VelocityContextPool;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;

public class ThemeHotDeployListener
extends BaseHotDeployListener {
    private static Log _log = LogFactoryUtil.getLog(ThemeHotDeployListener.class);
    private static Map<String, List<String>> _vars = new HashMap<String, List<String>>();

    public void invokeDeploy(HotDeployEvent event) throws HotDeployException {
        try {
            this.doInvokeDeploy(event);
        }
        catch (Throwable t) {
            this.throwHotDeployException(event, "Error registering themes for ", t);
        }
    }

    public void invokeUndeploy(HotDeployEvent event) throws HotDeployException {
        try {
            this.doInvokeUndeploy(event);
        }
        catch (Throwable t) {
            this.throwHotDeployException(event, "Error unregistering themes for ", t);
        }
    }

    protected void doInvokeDeploy(HotDeployEvent event) throws Exception {
        String[] xmls;
        ServletContext servletContext = event.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking deploy for " + servletContextName));
        }
        if ((xmls = new String[]{HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-look-and-feel.xml"))})[0] == null) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Registering themes for " + servletContextName));
        }
        List themeIds = ThemeLocalServiceUtil.init((String)servletContextName, (ServletContext)servletContext, null, (boolean)true, (String[])xmls, (PluginPackage)event.getPluginPackage());
        ClassLoader portletClassLoader = event.getContextClassLoader();
        servletContext.setAttribute("PORTLET_CLASS_LOADER", (Object)portletClassLoader);
        VelocityContextPool.put(servletContextName, servletContext);
        _vars.put(servletContextName, themeIds);
        if (_log.isInfoEnabled()) {
            if (themeIds.size() == 1) {
                _log.info((Object)("1 theme for " + servletContextName + " is available for use"));
            } else {
                _log.info((Object)(themeIds.size() + " themes for " + servletContextName + " are available for use"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInvokeUndeploy(HotDeployEvent event) throws Exception {
        List<String> themeIds;
        ServletContext servletContext = event.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking undeploy for " + servletContextName));
        }
        if ((themeIds = _vars.remove(servletContextName)) != null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Unregistering themes for " + servletContextName));
            }
            try {
                ThemeLocalServiceUtil.uninstallThemes(themeIds);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        } else {
            return;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
            VelocityContextPool.remove(servletContextName);
            LiferayResourceCacheUtil.clear();
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
        if (_log.isInfoEnabled()) {
            if (themeIds.size() == 1) {
                _log.info((Object)("1 theme for " + servletContextName + " was unregistered"));
            } else {
                _log.info((Object)(themeIds.size() + " themes for " + servletContextName + " was unregistered"));
            }
        }
    }
}

