/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.editor.fckeditor.receiver.impl;

import com.liferay.portal.editor.fckeditor.command.CommandArgument;
import com.liferay.portal.editor.fckeditor.exception.FCKException;
import com.liferay.portal.editor.fckeditor.receiver.CommandReceiver;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.upload.LiferayFileItemFactory;
import com.liferay.portal.upload.UploadServletRequestImpl;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseCommandReceiver
implements CommandReceiver {
    private static Log _log = LogFactoryUtil.getLog(BaseCommandReceiver.class);

    public void createFolder(CommandArgument argument, HttpServletRequest request, HttpServletResponse response) {
        String returnValue;
        Element errorEl;
        Document doc;
        block5: {
            doc = this._createDocument();
            Node root = this._createRoot(doc, argument.getCommand(), argument.getType(), argument.getCurrentFolder(), "");
            errorEl = doc.createElement("Error");
            root.appendChild(errorEl);
            returnValue = "0";
            try {
                returnValue = this.createFolder(argument);
            }
            catch (FCKException fcke) {
                Throwable cause = fcke.getCause();
                returnValue = "110";
                if (cause == null) break block5;
                String causeString = GetterUtil.getString((String)cause.toString());
                if (causeString.indexOf("DuplicateFolderNameException") != -1) {
                    returnValue = "101";
                }
                if (causeString.indexOf("FolderNameException") != -1) {
                    returnValue = "102";
                }
                if (causeString.indexOf("NoSuchGroupException") != -1) {
                    returnValue = "103";
                }
                throw fcke;
            }
        }
        errorEl.setAttribute("number", returnValue);
        this._writeDocument(doc, response);
    }

    public void getFolders(CommandArgument argument, HttpServletRequest request, HttpServletResponse response) {
        Document doc = this._createDocument();
        Node root = this._createRoot(doc, argument.getCommand(), argument.getType(), argument.getCurrentFolder(), this.getPath(argument));
        this.getFolders(argument, doc, root);
        this._writeDocument(doc, response);
    }

    public void getFoldersAndFiles(CommandArgument argument, HttpServletRequest request, HttpServletResponse response) {
        Document doc = this._createDocument();
        Node root = this._createRoot(doc, argument.getCommand(), argument.getType(), argument.getCurrentFolder(), this.getPath(argument));
        this.getFoldersAndFiles(argument, doc, root);
        this._writeDocument(doc, response);
    }

    public void fileUpload(CommandArgument argument, HttpServletRequest request, HttpServletResponse response) {
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new LiferayFileItemFactory(UploadServletRequestImpl.DEFAULT_TEMP_DIR));
        List items = null;
        try {
            items = upload.parseRequest(request);
        }
        catch (FileUploadException fue) {
            throw new FCKException(fue);
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        for (FileItem item : items) {
            if (item.isFormField()) {
                fields.put(item.getFieldName(), item.getString());
                continue;
            }
            fields.put(item.getFieldName(), (String)item);
        }
        DiskFileItem fileItem = (DiskFileItem)fields.get("NewFile");
        String fileName = StringUtil.replace((String)fileItem.getName(), (String)"\\", (String)"/");
        String[] fileNameArray = StringUtil.split((String)fileName, (String)"/");
        fileName = fileNameArray[fileNameArray.length - 1];
        String extension = this._getExtension(fileName);
        String returnValue = null;
        try {
            returnValue = this.fileUpload(argument, fileName, fileItem.getStoreLocation(), extension);
        }
        catch (FCKException fcke) {
            Throwable cause = fcke.getCause();
            returnValue = "203";
            if (cause != null) {
                String causeString = GetterUtil.getString((String)cause.toString());
                if (causeString.indexOf("NoSuchFolderException") != -1 || causeString.indexOf("NoSuchGroupException") != -1) {
                    returnValue = "204";
                } else if (causeString.indexOf("ImageNameException") != -1) {
                    returnValue = "205";
                } else if (causeString.indexOf("FileNameException") != -1) {
                    returnValue = "206";
                } else if (causeString.indexOf("PrincipalException") != -1) {
                    returnValue = "207";
                } else {
                    throw fcke;
                }
            }
            this._writeUploadResponse(returnValue, response);
        }
        this._writeUploadResponse(returnValue, response);
    }

    protected abstract String createFolder(CommandArgument var1);

    protected abstract String fileUpload(CommandArgument var1, String var2, File var3, String var4);

    protected abstract void getFolders(CommandArgument var1, Document var2, Node var3);

    protected abstract void getFoldersAndFiles(CommandArgument var1, Document var2, Node var3);

    protected void getRootFolders(CommandArgument argument, Document doc, Element foldersEl) throws Exception {
        LinkedHashMap<String, Long> groupParams = new LinkedHashMap<String, Long>();
        groupParams.put("usersGroups", new Long(argument.getUserId()));
        List groups = GroupLocalServiceUtil.search((long)argument.getCompanyId(), null, null, groupParams, (int)-1, (int)-1);
        List userOrgs = OrganizationLocalServiceUtil.getUserOrganizations((long)argument.getUserId(), (boolean)true);
        for (Organization organization : userOrgs) {
            groups.add(0, organization.getGroup());
        }
        if (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_ENABLED || PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_ENABLED) {
            Group userGroup = GroupLocalServiceUtil.getUserGroup((long)argument.getCompanyId(), (long)argument.getUserId());
            groups.add(0, userGroup);
        }
        for (Group group : groups) {
            Element folderEl = doc.createElement("Folder");
            foldersEl.appendChild(folderEl);
            folderEl.setAttribute("name", group.getGroupId() + " - " + group.getDescriptiveName());
        }
    }

    protected String getPath(CommandArgument argument) {
        return "";
    }

    protected String getSize() {
        return this.getSize(0);
    }

    protected String getSize(int size) {
        return String.valueOf(Math.ceil(size / 1000));
    }

    private Document _createDocument() {
        try {
            Document doc = null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
            return doc;
        }
        catch (ParserConfigurationException pce) {
            throw new FCKException(pce);
        }
    }

    private Node _createRoot(Document doc, String commandStr, String typeStr, String currentPath, String currentUrl) {
        Element root = doc.createElement("Connector");
        doc.appendChild(root);
        root.setAttribute("command", commandStr);
        root.setAttribute("resourceType", typeStr);
        Element el = doc.createElement("CurrentFolder");
        root.appendChild(el);
        el.setAttribute("path", currentPath);
        el.setAttribute("url", currentUrl);
        return root;
    }

    private String _getExtension(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    private void _writeDocument(Document doc, HttpServletResponse response) {
        try {
            doc.getDocumentElement().normalize();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            if (_log.isDebugEnabled()) {
                StreamResult result = new StreamResult(System.out);
                transformer.transform(source, result);
            }
            response.setContentType("text/xml; charset=UTF-8");
            response.setHeader("Cache-Control", "no-cache");
            PrintWriter out = response.getWriter();
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new FCKException(e);
        }
    }

    private void _writeUploadResponse(String returnValue, HttpServletResponse response) {
        try {
            StringBuilder sb = new StringBuilder();
            String newName = "";
            sb.append("<script type=\"text/javascript\">");
            sb.append("window.parent.frames['frmUpload'].OnUploadCompleted(");
            sb.append(returnValue);
            sb.append(",'");
            sb.append(newName);
            sb.append("');");
            sb.append("</script>");
            response.setContentType("text/html; charset=UTF-8");
            response.setHeader("Cache-Control", "no-cache");
            PrintWriter out = null;
            out = response.getWriter();
            out.print(sb.toString());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new FCKException(e);
        }
    }
}

