/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.editor.fckeditor.receiver.impl;

import com.liferay.portal.editor.fckeditor.command.CommandArgument;
import com.liferay.portal.editor.fckeditor.exception.FCKException;
import com.liferay.portal.editor.fckeditor.receiver.impl.BaseCommandReceiver;
import com.liferay.portal.kernel.servlet.ImageServletTokenUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Image;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.imagegallery.model.IGFolder;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.model.impl.IGFolderImpl;
import com.liferay.portlet.imagegallery.service.IGFolderServiceUtil;
import com.liferay.portlet.imagegallery.service.IGImageServiceUtil;
import java.io.File;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ImageCommandReceiver
extends BaseCommandReceiver {
    protected String createFolder(CommandArgument arg) {
        try {
            Group group = arg.getCurrentGroup();
            IGFolder folder = this._getFolder(group.getGroupId(), "/" + arg.getCurrentFolder());
            long parentFolderId = folder.getFolderId();
            String name = arg.getNewFolder();
            String description = "";
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddCommunityPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            serviceContext.setPlid(arg.getPlid());
            serviceContext.setScopeGroupId(group.getGroupId());
            IGFolderServiceUtil.addFolder((long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
        }
        catch (Exception e) {
            throw new FCKException(e);
        }
        return "0";
    }

    protected String fileUpload(CommandArgument arg, String fileName, File file, String extension) {
        try {
            Group group = arg.getCurrentGroup();
            IGFolder folder = this._getFolder(group.getGroupId(), arg.getCurrentFolder());
            long folderId = folder.getFolderId();
            String name = fileName;
            String description = "";
            String contentType = extension.toLowerCase();
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddCommunityPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            IGImageServiceUtil.addImage((long)folderId, (String)name, (String)description, (File)file, (String)contentType, (ServiceContext)serviceContext);
        }
        catch (Exception e) {
            throw new FCKException(e);
        }
        return "0";
    }

    protected void getFolders(CommandArgument arg, Document doc, Node root) {
        try {
            this._getFolders(arg, doc, root);
        }
        catch (Exception e) {
            throw new FCKException(e);
        }
    }

    protected void getFoldersAndFiles(CommandArgument arg, Document doc, Node root) {
        try {
            this._getFolders(arg, doc, root);
            this._getFiles(arg, doc, root);
        }
        catch (Exception e) {
            throw new FCKException(e);
        }
    }

    private void _getFiles(CommandArgument arg, Document doc, Node root) throws Exception {
        Element filesEl = doc.createElement("Files");
        root.appendChild(filesEl);
        if (Validator.isNull((String)arg.getCurrentGroupName())) {
            return;
        }
        Group group = arg.getCurrentGroup();
        IGFolder folder = this._getFolder(group.getGroupId(), arg.getCurrentFolder());
        List images = IGImageServiceUtil.getImages((long)folder.getFolderId());
        for (IGImage image : images) {
            long largeImageId = image.getLargeImageId();
            Image portalImage = ImageLocalServiceUtil.getImageOrDefault((long)largeImageId);
            Element fileEl = doc.createElement("File");
            filesEl.appendChild(fileEl);
            fileEl.setAttribute("name", image.getNameWithExtension());
            fileEl.setAttribute("desc", image.getNameWithExtension());
            fileEl.setAttribute("size", this.getSize(portalImage.getSize()));
            StringBuilder url = new StringBuilder();
            ThemeDisplay themeDisplay = arg.getThemeDisplay();
            url.append(themeDisplay.getPathImage());
            url.append("/image_gallery?uuid=");
            url.append(image.getUuid());
            url.append("&groupId=");
            url.append(folder.getGroupId());
            url.append("&t=");
            url.append(ImageServletTokenUtil.getToken((long)largeImageId));
            fileEl.setAttribute("url", url.toString());
        }
    }

    private IGFolder _getFolder(long groupId, String folderName) throws Exception {
        IGFolderImpl folder = new IGFolderImpl();
        folder.setFolderId(0L);
        if (folderName.equals("/")) {
            return folder;
        }
        StringTokenizer st = new StringTokenizer(folderName, "/");
        block0: while (st.hasMoreTokens()) {
            String curFolderName = st.nextToken();
            List folders = IGFolderServiceUtil.getFolders((long)groupId, (long)folder.getFolderId());
            for (IGFolder curFolder : folders) {
                if (!curFolder.getName().equals(curFolderName)) continue;
                folder = curFolder;
                continue block0;
            }
        }
        return folder;
    }

    private void _getFolders(CommandArgument arg, Document doc, Node root) throws Exception {
        Element foldersEl = doc.createElement("Folders");
        root.appendChild(foldersEl);
        if (arg.getCurrentFolder().equals("/")) {
            this.getRootFolders(arg, doc, foldersEl);
        } else {
            Group group = arg.getCurrentGroup();
            IGFolder folder = this._getFolder(group.getGroupId(), arg.getCurrentFolder());
            List folders = IGFolderServiceUtil.getFolders((long)group.getGroupId(), (long)folder.getFolderId());
            for (IGFolder curFolder : folders) {
                Element folderEl = doc.createElement("Folder");
                foldersEl.appendChild(folderEl);
                folderEl.setAttribute("name", curFolder.getName());
            }
        }
    }
}

