/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.events.EventsProcessor;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.events.SessionAction;
import com.liferay.portal.kernel.events.SimpleAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventsProcessorImpl
implements EventsProcessor {
    private static Log _log = LogFactoryUtil.getLog(EventsProcessorImpl.class);
    private Map<String, List<Object>> _eventsMap = new HashMap<String, List<Object>>();

    @Override
    public void process(String key, String[] classes, String[] ids, HttpServletRequest request, HttpServletResponse response, HttpSession session) throws ActionException {
        for (String className : classes) {
            if (Validator.isNull((String)className)) {
                return;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Process event " + className));
            }
            Object event = InstancePool.get((String)className);
            this.processEvent(event, ids, request, response, session);
        }
        if (Validator.isNull((String)key)) {
            return;
        }
        List<Object> events = this._getEvents(key);
        for (Object event : events) {
            this.processEvent(event, ids, request, response, session);
        }
    }

    @Override
    public void processEvent(Object event, String[] ids, HttpServletRequest request, HttpServletResponse response, HttpSession session) throws ActionException {
        if (event instanceof Action) {
            Action action = (Action)event;
            try {
                action.run(request, response);
            }
            catch (ActionException ae) {
                throw ae;
            }
            catch (Exception e) {
                throw new ActionException((Throwable)e);
            }
        } else if (event instanceof SessionAction) {
            SessionAction sessionAction = (SessionAction)event;
            try {
                sessionAction.run(session);
            }
            catch (ActionException ae) {
                throw ae;
            }
            catch (Exception e) {
                throw new ActionException((Throwable)e);
            }
        } else if (event instanceof SimpleAction) {
            SimpleAction simpleAction = (SimpleAction)event;
            simpleAction.run(ids);
        }
    }

    @Override
    public void registerEvent(String key, Object event) {
        List<Object> events = this._getEvents(key);
        events.add(event);
    }

    @Override
    public void unregisterEvent(String key, Object event) {
        List<Object> events = this._getEvents(key);
        events.remove(event);
    }

    private List<Object> _getEvents(String key) {
        List<Object> events = this._eventsMap.get(key);
        if (events == null) {
            events = new ArrayList<Object>();
            this._eventsMap.put(key, events);
        }
        return events;
    }
}

