/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.im.AIMConnector;
import com.liferay.portal.im.ICQConnector;
import com.liferay.portal.im.MSNConnector;
import com.liferay.portal.im.YMConnector;
import com.liferay.portal.jcr.JCRFactoryUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.events.SimpleAction;
import com.liferay.portal.kernel.job.JobSchedulerUtil;
import com.liferay.portal.kernel.log.Jdk14LogFactoryImpl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactory;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEngineUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.pop.POPServerUtil;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.util.DocumentConversionUtil;
import java.sql.Connection;
import java.sql.Statement;

public class GlobalShutdownAction
extends SimpleAction {
    private static Log _log = LogFactoryUtil.getLog(GlobalShutdownAction.class);

    public void run(String[] ids) {
        HotDeployUtil.unregisterListeners();
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Shutting down AIM");
            }
            AIMConnector.disconnect();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Shutting down ICQ");
            }
            ICQConnector.disconnect();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Shutting down MSN");
            }
            MSNConnector.disconnect();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Shutting down YM");
            }
            YMConnector.disconnect();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Shutting down JCR");
            }
            JCRFactoryUtil.shutdown();
        }
        catch (Exception e) {
            // empty catch block
        }
        LuceneHelperUtil.shutdown();
        DocumentConversionUtil.disconnect();
        if (PropsValues.POP_SERVER_NOTIFICATIONS_ENABLED) {
            POPServerUtil.stop();
        }
        try {
            JobSchedulerUtil.shutdown();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            SchedulerEngineUtil.shutdown();
        }
        catch (Exception e) {
            // empty catch block
        }
        DB db = DBFactoryUtil.getDB();
        if (db.getType().equals("hypersonic")) {
            try {
                Connection connection = DataAccess.getConnection();
                Statement statement = connection.createStatement();
                statement.executeUpdate("SHUTDOWN");
                statement.close();
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        try {
            LogFactoryUtil.setLogFactory((LogFactory)new Jdk14LogFactoryImpl());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (GetterUtil.getBoolean((String)PropsUtil.get("shutdown.programmatically.exit"))) {
            Thread thread = Thread.currentThread();
            ThreadGroup threadGroup = thread.getThreadGroup();
            for (int i = 0; i < 10 && threadGroup.getParent() != null; ++i) {
                threadGroup = threadGroup.getParent();
            }
            Thread[] threads = new Thread[threadGroup.activeCount() * 2];
            threadGroup.enumerate(threads);
            for (int i = 0; i < threads.length; ++i) {
                Thread curThread = threads[i];
                if (curThread == null || curThread == thread) continue;
                try {
                    curThread.interrupt();
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            threadGroup.destroy();
        }
    }
}

