/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.deploy.DeployUtil;
import com.liferay.portal.jcr.JCRFactoryUtil;
import com.liferay.portal.kernel.deploy.auto.AutoDeployDir;
import com.liferay.portal.kernel.deploy.auto.AutoDeployListener;
import com.liferay.portal.kernel.deploy.auto.AutoDeployUtil;
import com.liferay.portal.kernel.deploy.hot.HotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.events.SimpleAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.pop.POPServerUtil;
import com.liferay.portal.util.BrowserLauncher;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalStartupAction
extends SimpleAction {
    private static Log _log = LogFactoryUtil.getLog(GlobalStartupAction.class);

    public static List<AutoDeployListener> getAutoDeployListeners() {
        ArrayList<AutoDeployListener> list = new ArrayList<AutoDeployListener>();
        String[] autoDeployListeners = PropsUtil.getArray("auto.deploy.listeners");
        for (int i = 0; i < autoDeployListeners.length; ++i) {
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Instantiating " + autoDeployListeners[i]));
                }
                AutoDeployListener autoDeployListener = (AutoDeployListener)Class.forName(autoDeployListeners[i]).newInstance();
                list.add(autoDeployListener);
                continue;
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
        return list;
    }

    public static List<HotDeployListener> getHotDeployListeners() {
        ArrayList<HotDeployListener> list = new ArrayList<HotDeployListener>();
        String[] hotDeployListeners = PropsUtil.getArray("hot.deploy.listeners");
        for (int i = 0; i < hotDeployListeners.length; ++i) {
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Instantiating " + hotDeployListeners[i]));
                }
                HotDeployListener hotDeployListener = (HotDeployListener)Class.forName(hotDeployListeners[i]).newInstance();
                list.add(hotDeployListener);
                continue;
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
        return list;
    }

    public void run(String[] ids) {
        block17: {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Registering hot deploy listeners");
            }
            for (HotDeployListener hotDeployListener : GlobalStartupAction.getHotDeployListeners()) {
                HotDeployUtil.registerListener((HotDeployListener)hotDeployListener);
            }
            try {
                if (PrefsPropsUtil.getBoolean("auto.deploy.enabled", PropsValues.AUTO_DEPLOY_ENABLED)) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)"Registering auto deploy directories");
                    }
                    File deployDir = new File(PrefsPropsUtil.getString("auto.deploy.deploy.dir", PropsValues.AUTO_DEPLOY_DEPLOY_DIR));
                    File destDir = new File(DeployUtil.getAutoDeployDestDir());
                    long interval = PrefsPropsUtil.getLong("auto.deploy.interval", PropsValues.AUTO_DEPLOY_INTERVAL);
                    int blacklistThreshold = PrefsPropsUtil.getInteger("auto.deploy.blacklist.threshold", PropsValues.AUTO_DEPLOY_BLACKLIST_THRESHOLD);
                    List<AutoDeployListener> autoDeployListeners = GlobalStartupAction.getAutoDeployListeners();
                    AutoDeployDir autoDeployDir = new AutoDeployDir("defaultAutoDeployDir", deployDir, destDir, interval, blacklistThreshold, autoDeployListeners);
                    AutoDeployUtil.registerDir((AutoDeployDir)autoDeployDir);
                } else if (_log.isInfoEnabled()) {
                    _log.info((Object)"Not registering auto deploy directories");
                }
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
            try {
                JCRFactoryUtil.prepare();
                if (GetterUtil.getBoolean((String)PropsUtil.get("jcr.initialize.on.startup"))) {
                    JCRFactoryUtil.initialize();
                }
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
            try {
                InfrastructureUtil.getDataSource();
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            try {
                if (!ServerDetector.isJOnAS()) {
                    InfrastructureUtil.getMailSession();
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block17;
                _log.warn((Object)e.getMessage());
            }
        }
        if (PropsValues.POP_SERVER_NOTIFICATIONS_ENABLED) {
            POPServerUtil.start();
        }
        Thread browserLauncherThread = new Thread(new BrowserLauncher());
        browserLauncherThread.start();
    }
}

