/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.ldap.PortalLDAPUtil;
import com.liferay.portal.util.CookieKeys;
import com.liferay.portal.util.PortalUtil;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SiteMinderLogoutAction
extends Action {
    private static final String _SMSESSION = "SMSESSION";
    private static final String _SMIDENTITY = "SMIDENTITY";
    private static Log _log = LogFactoryUtil.getLog(SiteMinderLogoutAction.class);

    public void run(HttpServletRequest request, HttpServletResponse response) {
        try {
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
            if (!PortalLDAPUtil.isSiteMinderEnabled(companyId)) {
                return;
            }
            String domain = CookieKeys.getDomain(request);
            Cookie smSessionCookie = new Cookie(_SMSESSION, "");
            if (Validator.isNotNull((String)domain)) {
                smSessionCookie.setDomain(domain);
            }
            smSessionCookie.setMaxAge(0);
            smSessionCookie.setPath("/");
            Cookie smIdentityCookie = new Cookie(_SMIDENTITY, "");
            if (Validator.isNotNull((String)domain)) {
                smIdentityCookie.setDomain(domain);
            }
            smIdentityCookie.setMaxAge(0);
            smIdentityCookie.setPath("/");
            CookieKeys.addCookie(request, response, smSessionCookie);
            CookieKeys.addCookie(request, response, smIdentityCookie);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }
}

