/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.events.ShutdownHook;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.events.SimpleAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.sender.MessageSender;
import com.liferay.portal.kernel.messaging.sender.SynchronousMessageSender;
import com.liferay.portal.kernel.scheduler.SchedulerEngine;
import com.liferay.portal.kernel.scheduler.SchedulerEngineUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.velocity.VelocityEngineUtil;
import com.liferay.portal.scheduler.SchedulerEngineProxy;
import com.liferay.portal.security.lang.PortalSecurityManager;
import com.liferay.portal.service.LockLocalServiceUtil;
import com.liferay.portal.tools.DBUpgrader;
import com.liferay.portal.util.PropsValues;

public class StartupAction
extends SimpleAction {
    private static Log _log = LogFactoryUtil.getLog(StartupAction.class);

    public void run(String[] ids) throws ActionException {
        try {
            this.doRun(ids);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new ActionException((Throwable)e);
        }
    }

    protected void doRun(String[] ids) throws Exception {
        block3: {
            System.out.println("Starting " + ReleaseInfo.getReleaseInfo());
            try {
                LockLocalServiceUtil.clear();
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)"Unable to clear locks because Lock table does not exist");
            }
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new ShutdownHook()));
        if (System.getSecurityManager() == null && PropsValues.PORTAL_SECURITY_MANAGER_ENABLE) {
            System.setSecurityManager(new PortalSecurityManager());
        }
        VelocityEngineUtil.init();
        DBUpgrader.upgrade();
        MessageBus messageBus = (MessageBus)PortalBeanLocatorUtil.locate((String)MessageBus.class.getName());
        MessageSender messageSender = (MessageSender)PortalBeanLocatorUtil.locate((String)MessageSender.class.getName());
        SynchronousMessageSender synchronousMessageSender = (SynchronousMessageSender)PortalBeanLocatorUtil.locate((String)SynchronousMessageSender.class.getName());
        MessageBusUtil.init((MessageBus)messageBus, (MessageSender)messageSender, (SynchronousMessageSender)synchronousMessageSender);
        SchedulerEngineUtil.init((SchedulerEngine)new SchedulerEngineProxy());
        SchedulerEngineUtil.start();
        DBUpgrader.verify();
    }
}

