/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.googleapps;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import java.io.Reader;
import java.util.Properties;

public class GoogleApps {
    private static final String _APPS_PREFIX = "apps";
    private static final String _APPS_URI = "http://schemas.google.com/apps/2006";
    private static final String _ATOM_PREFIX = "atom";
    private static final String _ATOM_URI = "http://www.w3.org/2005/Atom";
    private static final String _URL = "https://apps-apis.google.com/a/feeds/";
    private static Log _log = LogFactoryUtil.getLog(GoogleApps.class);
    private String _authenticationToken;
    private long _companyId;
    private String _domain;
    private long _initTime;
    private String _password;
    private String _userName;

    public GoogleApps(long companyId) {
        try {
            this._companyId = companyId;
            this.init(true);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void addNickname(long userId, String nickname) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element atomEntry = this._addAtomEntry(document);
        this._addAtomCategory(atomEntry, "nickname");
        Element appsLogin = atomEntry.addElement("apps:login");
        appsLogin.addAttribute("userName", String.valueOf(userId));
        Element appsNickname = atomEntry.addElement("apps:nickname");
        appsNickname.addAttribute("name", nickname);
        Http.Options options = this._getOptions();
        options.setBody(document.formattedString(), "application/atom+xml", "UTF-8");
        options.setLocation(this._getNicknameURL());
        options.setPost(true);
        HttpUtil.URLtoString((Http.Options)options);
    }

    public void addSendAs(long userId, String fullName, String emailAddress) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element atomEntry = this._addAtomEntry(document);
        this._addAppsProperty(atomEntry, "name", fullName);
        this._addAppsProperty(atomEntry, "address", emailAddress);
        this._addAppsProperty(atomEntry, "makeDefault", Boolean.TRUE.toString());
        Http.Options options = this._getOptions();
        options.setBody(document.formattedString(), "application/atom+xml", "UTF-8");
        options.setLocation("https://apps-apis.google.com/a/feeds/emailsettings/2.0/" + this._domain + "/" + userId + "/sendas");
        options.setPost(true);
        HttpUtil.URLtoString((Http.Options)options);
    }

    public void addUser(long userId, String password, String firstName, String lastName) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element atomEntry = this._addAtomEntry(document);
        this._addAtomCategory(atomEntry, "user");
        Element appsLogin = atomEntry.addElement("apps:login");
        appsLogin.addAttribute("password", password);
        appsLogin.addAttribute("userName", String.valueOf(userId));
        Element appsName = atomEntry.addElement("apps:name");
        appsName.addAttribute("familyName", lastName);
        appsName.addAttribute("givenName", firstName);
        Http.Options options = this._getOptions();
        options.setBody(document.formattedString(), "application/atom+xml", "UTF-8");
        options.setLocation(this._getUserURL());
        options.setPost(true);
        HttpUtil.URLtoString((Http.Options)options);
    }

    public void deleteNickname(String nickname) throws Exception {
        Http.Options options = this._getOptions();
        options.setDelete(true);
        options.setLocation(this._getNicknameURL(nickname));
        HttpUtil.URLtoString((Http.Options)options);
    }

    public void deleteUser(long userId) throws Exception {
        Http.Options options = this._getOptions();
        options.setDelete(true);
        options.setLocation(this._getUserURL(userId));
        HttpUtil.URLtoString((Http.Options)options);
    }

    public void init(boolean manual) throws Exception {
        if (manual || this._isStale()) {
            this._init();
        }
    }

    public void updatePassword(long userId, String password) throws Exception {
        String userXML = this._getUserXML(userId);
        Document document = SAXReaderUtil.read((Reader)new UnsyncStringReader(userXML));
        Element atomEntry = document.getRootElement();
        Element appsLogin = atomEntry.element(this._getAppsQName("login"));
        appsLogin.addAttribute("password", password);
        Http.Options options = this._getOptions();
        options.setBody(document.formattedString(), "application/atom+xml", "UTF-8");
        options.setLocation(this._getUserURL(userId));
        options.setPut(true);
        HttpUtil.URLtoString((Http.Options)options);
    }

    private Element _addAppsProperty(Element parentElement, String name, String value) {
        Element element = parentElement.addElement("apps:property");
        element.addAttribute("name", name);
        element.addAttribute("value", value);
        return element;
    }

    private Element _addAtomCategory(Element parentElement, String type) {
        Element element = parentElement.addElement("atom:category");
        element.addAttribute("scheme", "http://schemas.google.com/g/2005#kind");
        element.addAttribute("term", "http://schemas.google.com/apps/2006#" + type);
        return element;
    }

    private Element _addAtomEntry(Document document) {
        Element element = document.addElement("atom:entry");
        element.add(this._getAppsNamespace());
        element.add(this._getAtomNamespace());
        return element;
    }

    private Namespace _getAppsNamespace() {
        return SAXReaderUtil.createNamespace((String)_APPS_PREFIX, (String)_APPS_URI);
    }

    private QName _getAppsQName(String localName) {
        return SAXReaderUtil.createQName((String)localName, (Namespace)this._getAppsNamespace());
    }

    private Namespace _getAtomNamespace() {
        return SAXReaderUtil.createNamespace((String)_ATOM_PREFIX, (String)_ATOM_URI);
    }

    private String _getNicknameURL() {
        return _URL + this._domain + "/nickname/2.0";
    }

    private String _getNicknameURL(String nickname) {
        return this._getNicknameURL() + "/" + nickname;
    }

    private Http.Options _getOptions() {
        Http.Options options = new Http.Options();
        options.addHeader("Authorization", "GoogleLogin auth=" + this._authenticationToken);
        return options;
    }

    private String _getUserURL() {
        return _URL + this._domain + "/user/2.0";
    }

    private String _getUserURL(long userId) {
        return this._getUserURL() + "/" + userId;
    }

    private String _getUserXML(long userId) throws Exception {
        Http.Options options = this._getOptions();
        options.setLocation(this._getUserURL(userId));
        return HttpUtil.URLtoString((Http.Options)options);
    }

    private void _init() throws Exception {
        Company company = CompanyLocalServiceUtil.getCompany((long)this._companyId);
        this._domain = company.getMx();
        this._userName = PrefsPropsUtil.getString(this._companyId, "google.apps.username");
        this._password = PrefsPropsUtil.getString(this._companyId, "google.apps.password");
        if (!this._userName.contains("@")) {
            this._userName = this._userName + "@" + this._domain;
        }
        Http.Options options = new Http.Options();
        options.addPart("Email", this._userName);
        options.addPart("Passwd", this._password);
        options.addPart("accountType", "HOSTED");
        options.addPart("service", _APPS_PREFIX);
        options.setLocation("https://www.google.com/accounts/ClientLogin");
        options.setPost(true);
        String content = HttpUtil.URLtoString((Http.Options)options);
        Properties properties = PropertiesUtil.load((String)content);
        this._authenticationToken = properties.getProperty("Auth");
        this._initTime = System.currentTimeMillis();
    }

    private boolean _isStale() {
        return this._initTime + 82800000L <= System.currentTimeMillis();
    }
}

