/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.im;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.PropsUtil;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.client.Oscar;

public class AIMConnector {
    private static Log _log = LogFactoryUtil.getLog(AIMConnector.class);
    private static AIMConnector _instance = new AIMConnector();
    private AIMSession _aim;
    private Oscar _oscar;

    public static void disconnect() {
        if (_instance != null) {
            _instance._disconnect();
        }
    }

    public static void send(String to, String msg) {
        _instance._send(to, msg);
    }

    private AIMConnector() {
    }

    private void _connect() {
        String login = PropsUtil.get("aim.login");
        String password = PropsUtil.get("aim.password");
        AIMSession ses = new AIMSession();
        ses.setSN(login);
        Oscar oscar = new Oscar();
        oscar.setSN(login);
        oscar.setPassword(password);
        ses.init();
    }

    private void _disconnect() {
        if (this._aim != null) {
            AIMConnection.killAllInSess((AIMSession)this._aim);
        }
    }

    private void _send(String to, String msg) {
        block3: {
            try {
                if (this._aim == null) {
                    this._connect();
                    Thread.sleep(1000L);
                }
                this._oscar.sendIM(this._aim, to, msg, Oscar.getICQCaps());
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)"Could not send AIM message");
            }
        }
    }
}

