/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.im;

import com.liferay.portal.im.MSNMessageAdapter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.PropsUtil;
import rath.msnm.MSNMessenger;
import rath.msnm.event.MsnListener;

public class MSNConnector {
    private static Log _log = LogFactoryUtil.getLog(MSNConnector.class);
    private static MSNConnector _instance = new MSNConnector();
    private String _login = PropsUtil.get("msn.login");
    private String _password = PropsUtil.get("msn.password");
    private MSNMessenger _msn = new MSNMessenger(this._login, this._password);

    public static void disconnect() {
        if (_instance != null) {
            _instance._disconnect();
        }
    }

    public static void send(String to, String msg) {
        _instance._send(to, msg);
    }

    private MSNConnector() {
        this._msn.setInitialStatus("NLN");
    }

    private void _connect() {
        if (!this._msn.isLoggedIn()) {
            this._msn.login();
            for (int i = 0; i < 50 && !this._msn.isLoggedIn(); ++i) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    _log.warn((Throwable)e);
                    break;
                }
            }
            if (!this._msn.isLoggedIn()) {
                _log.error((Object)("Unable to connect as " + this._login));
            }
        }
    }

    private void _disconnect() {
        try {
            if (this._msn.isLoggedIn()) {
                this._msn.logout();
            }
        }
        catch (Exception e) {
            _log.warn((Throwable)e);
        }
    }

    private void _send(String to, String msg) {
        this._connect();
        this._msn.addMsnListener((MsnListener)new MSNMessageAdapter(this._msn, to, msg));
        try {
            Thread.sleep(1500L);
            this._msn.doCallWait(to);
        }
        catch (Exception e) {
            _log.warn((Throwable)e);
        }
    }
}

