/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.image;

import com.liferay.documentlibrary.NoSuchFileException;
import com.liferay.documentlibrary.service.DLLocalServiceUtil;
import com.liferay.documentlibrary.service.DLServiceUtil;
import com.liferay.portal.NoSuchImageException;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.image.BaseHook;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.model.Image;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

public class DLHook
extends BaseHook {
    private static final long _COMPANY_ID = 0L;
    private static final long _FILE_ENTRY_ID = 0L;
    private static final long _GROUP_ID = 0L;
    private static final String _PORTLET_ID = "90";
    private static final String _PROPERTIES = "";
    private static final long _REPOSITORY_ID = 0L;
    private static final String[] _TAGS_CATEGORIES = new String[0];
    private static final String[] _TAGS_ENTRIES = new String[0];
    private static final double _VERSION_NUMBER = 1.0;

    public void deleteImage(Image image) throws PortalException, SystemException {
        String fileName = this.getFileName(image.getImageId(), image.getType());
        try {
            DLServiceUtil.deleteFile((long)0L, (String)_PORTLET_ID, (long)0L, (String)fileName);
        }
        catch (NoSuchFileException nsfe) {
            throw new NoSuchImageException((Throwable)nsfe);
        }
    }

    public byte[] getImageAsBytes(Image image) throws PortalException, SystemException {
        String fileName = this.getFileName(image.getImageId(), image.getType());
        InputStream is = DLLocalServiceUtil.getFileAsStream((long)0L, (long)0L, (String)fileName);
        byte[] bytes = null;
        try {
            bytes = FileUtil.getBytes((InputStream)is);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        return bytes;
    }

    public InputStream getImageAsStream(Image image) throws PortalException, SystemException {
        String fileName = this.getFileName(image.getImageId(), image.getType());
        return DLLocalServiceUtil.getFileAsStream((long)0L, (long)0L, (String)fileName);
    }

    public void updateImage(Image image, String type, byte[] bytes) throws PortalException, SystemException {
        String fileName = this.getFileName(image.getImageId(), image.getType());
        Date now = new Date();
        UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(bytes);
        if (DLLocalServiceUtil.hasFile((long)0L, (long)0L, (String)fileName, (double)1.0)) {
            DLServiceUtil.deleteFile((long)0L, (String)_PORTLET_ID, (long)0L, (String)fileName);
        }
        DLLocalServiceUtil.addFile((long)0L, (String)_PORTLET_ID, (long)0L, (long)0L, (String)fileName, (long)0L, (String)_PROPERTIES, (Date)now, (String[])_TAGS_CATEGORIES, (String[])_TAGS_ENTRIES, (InputStream)is);
    }

    protected String getFileName(long imageId, String type) {
        return imageId + "." + type;
    }
}

