/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.image;

import com.liferay.documentlibrary.NoSuchFileException;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.image.BaseHook;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.model.Image;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileSystemHook
extends BaseHook {
    private File _rootDir = new File(PropsValues.IMAGE_HOOK_FILE_SYSTEM_ROOT_DIR);

    public FileSystemHook() {
        if (!this._rootDir.exists()) {
            this._rootDir.mkdirs();
        }
    }

    public void deleteImage(Image image) {
        File file = this.getFile(image.getImageId(), image.getType());
        FileUtil.delete((File)file);
    }

    public byte[] getImageAsBytes(Image image) throws PortalException, SystemException {
        try {
            File file = this.getFile(image.getImageId(), image.getType());
            if (!file.exists()) {
                throw new NoSuchFileException(file.getPath());
            }
            return FileUtil.getBytes((File)file);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public InputStream getImageAsStream(Image image) throws PortalException, SystemException {
        try {
            File file = this.getFile(image.getImageId(), image.getType());
            if (!file.exists()) {
                throw new NoSuchFileException(file.getPath());
            }
            return new FileInputStream(file);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public void updateImage(Image image, String type, byte[] bytes) throws SystemException {
        try {
            File file = this.getFile(image.getImageId(), type);
            FileUtil.write((File)file, (byte[])bytes);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    protected void buildPath(StringBuilder sb, String fileNameFragment) {
        if (fileNameFragment.length() <= 2) {
            return;
        }
        sb.append("/");
        sb.append(fileNameFragment.substring(0, 2));
        this.buildPath(sb, fileNameFragment.substring(2));
    }

    protected File getFile(long imageId, String type) {
        StringBuilder sb = new StringBuilder();
        this.buildPath(sb, String.valueOf(imageId));
        return new File(this._rootDir + "/" + sb.toString() + "/" + imageId + "." + type);
    }
}

