/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.image;

import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageProcessor;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.JavaProps;
import com.liferay.portal.util.FileImpl;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.ImageEncoder;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.imageio.ImageIO;
import javax.media.jai.RenderedImageAdapter;
import net.jmge.gif.Gif89Encoder;

public class ImageProcessorImpl
implements ImageProcessor {
    private static Log _log = LogFactoryUtil.getLog(ImageProcessorImpl.class);
    private static ImageProcessorImpl _instance = new ImageProcessorImpl();
    private static FileImpl _fileUtil = FileImpl.getInstance();

    public static ImageProcessorImpl getInstance() {
        return _instance;
    }

    public BufferedImage convertImageType(BufferedImage sourceImage, int type) {
        BufferedImage targetImage = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), type);
        Graphics2D graphics = targetImage.createGraphics();
        graphics.drawRenderedImage(sourceImage, null);
        graphics.dispose();
        return targetImage;
    }

    public void encodeGIF(RenderedImage renderedImage, OutputStream os) throws IOException {
        if (JavaProps.isJDK6()) {
            ImageIO.write(renderedImage, "gif", os);
        } else {
            BufferedImage bufferedImage = this.getBufferedImage(renderedImage);
            if (!(bufferedImage.getColorModel() instanceof IndexColorModel)) {
                bufferedImage = this.convertImageType(bufferedImage, 13);
            }
            Gif89Encoder encoder = new Gif89Encoder((Image)bufferedImage);
            encoder.encode(os);
        }
    }

    public void encodeWBMP(RenderedImage renderedImage, OutputStream os) throws IOException {
        BufferedImage bufferedImage = this.getBufferedImage(renderedImage);
        SampleModel sampleModel = bufferedImage.getSampleModel();
        int type = sampleModel.getDataType();
        if (bufferedImage.getType() != 12 || type < 0 || type > 3 || sampleModel.getNumBands() != 1 || sampleModel.getSampleSize(0) != 1) {
            BufferedImage binaryImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 12);
            Graphics graphics = binaryImage.getGraphics();
            graphics.drawImage(bufferedImage, 0, 0, null);
            renderedImage = binaryImage;
        }
        if (!ImageIO.write(renderedImage, "wbmp", os)) {
            os.write(0);
            os.write(0);
            os.write(this._toMultiByte(bufferedImage.getWidth()));
            os.write(this._toMultiByte(bufferedImage.getHeight()));
            DataBuffer dataBuffer = bufferedImage.getData().getDataBuffer();
            int size = dataBuffer.getSize();
            for (int i = 0; i < size; ++i) {
                os.write((byte)dataBuffer.getElem(i));
            }
        }
    }

    public BufferedImage getBufferedImage(RenderedImage renderedImage) {
        if (renderedImage instanceof BufferedImage) {
            return (BufferedImage)renderedImage;
        }
        RenderedImageAdapter adapter = new RenderedImageAdapter(renderedImage);
        return adapter.getAsBufferedImage();
    }

    public byte[] getBytes(RenderedImage renderedImage, String contentType) throws IOException {
        UnsyncByteArrayOutputStream baos = new UnsyncByteArrayOutputStream();
        if (contentType.indexOf("bmp") != -1) {
            ImageEncoder encoder = ImageCodec.createImageEncoder((String)"bmp", (OutputStream)baos, null);
            encoder.encode(renderedImage);
        } else if (contentType.indexOf("gif") != -1) {
            this.encodeGIF(renderedImage, (OutputStream)baos);
        } else if (contentType.indexOf("jpg") != -1 || contentType.indexOf("jpeg") != -1) {
            ImageIO.write(renderedImage, "jpeg", (OutputStream)baos);
        } else if (contentType.indexOf("png") != -1) {
            ImageIO.write(renderedImage, "png", (OutputStream)baos);
        } else if (contentType.indexOf("tif") != -1) {
            ImageEncoder encoder = ImageCodec.createImageEncoder((String)"tiff", (OutputStream)baos, null);
            encoder.encode(renderedImage);
        }
        return baos.toByteArray();
    }

    public ImageBag read(File file) throws IOException {
        return this.read(_fileUtil.getBytes(file));
    }

    public ImageBag read(byte[] bytes) {
        RenderedImage renderedImage = null;
        String type = "na";
        Enumeration enu = ImageCodec.getCodecs();
        while (enu.hasMoreElements()) {
            ImageCodec codec = (ImageCodec)enu.nextElement();
            if (!codec.isFormatRecognized(bytes)) continue;
            type = codec.getFormatName();
            ImageDecoder decoder = ImageCodec.createImageDecoder((String)type, (InputStream)new UnsyncByteArrayInputStream(bytes), null);
            try {
                renderedImage = decoder.decodeAsRenderedImage();
            }
            catch (IOException ioe) {
                if (!_log.isDebugEnabled()) break;
                _log.debug((Object)(type + ": " + ioe.getMessage()));
            }
            break;
        }
        if (type.equals("jpeg")) {
            type = "jpg";
        }
        return new ImageBag(renderedImage, type);
    }

    public RenderedImage scale(RenderedImage renderedImage, int maxHeight, int maxWidth) {
        int imageHeight = renderedImage.getHeight();
        int imageWidth = renderedImage.getWidth();
        if (maxHeight == 0) {
            maxHeight = imageHeight;
        }
        if (maxWidth == 0) {
            maxWidth = imageWidth;
        }
        if (imageHeight <= maxHeight && imageWidth <= maxWidth) {
            return renderedImage;
        }
        double factor = Math.min((double)maxHeight / (double)imageHeight, (double)maxWidth / (double)imageWidth);
        int scaledHeight = Math.max(1, (int)(factor * (double)imageHeight));
        int scaledWidth = Math.max(1, (int)(factor * (double)imageWidth));
        BufferedImage bufferedImage = this.getBufferedImage(renderedImage);
        Image scaledImage = bufferedImage.getScaledInstance(scaledWidth, scaledHeight, 4);
        BufferedImage scaledBufferedImage = new BufferedImage(scaledWidth, scaledHeight, 1);
        scaledBufferedImage.getGraphics().drawImage(scaledImage, 0, 0, null);
        return scaledBufferedImage;
    }

    private byte[] _toMultiByte(int intValue) {
        int numBits = 32;
        for (int mask = Integer.MIN_VALUE; mask != 0 && (intValue & mask) == 0; mask >>>= 1) {
            --numBits;
        }
        int numBitsLeft = numBits;
        byte[] multiBytes = new byte[(numBitsLeft + 6) / 7];
        int maxIndex = multiBytes.length - 1;
        for (int b = 0; b <= maxIndex; ++b) {
            multiBytes[b] = (byte)(intValue >>> (maxIndex - b) * 7 & 0x7F);
            if (b == maxIndex) continue;
            int n = b;
            multiBytes[n] = (byte)(multiBytes[n] | 0xFFFFFF80);
        }
        return multiBytes;
    }
}

