/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.job;

import com.liferay.portal.job.JobClassUtil;
import com.liferay.portal.job.JobWrapper;
import com.liferay.portal.kernel.job.IntervalJob;
import com.liferay.portal.kernel.job.JobScheduler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import java.util.Date;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class JobSchedulerImpl
implements JobScheduler {
    private static Log _log = LogFactoryUtil.getLog(JobScheduler.class);
    private Scheduler _scheduler;

    public void schedule(IntervalJob intervalJob) {
        if (intervalJob == null) {
            return;
        }
        try {
            if (this._scheduler.isShutdown()) {
                return;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        String jobName = intervalJob.getClass().getName() + "@" + intervalJob.hashCode();
        JobClassUtil.put(jobName, intervalJob.getClass());
        Date startTime = null;
        try {
            if (ServerDetector.getServerId().equals("tomcat")) {
                startTime = new Date(System.currentTimeMillis() + 60000L);
            }
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        if (startTime == null) {
            startTime = new Date(System.currentTimeMillis() + 180000L);
        }
        Date endTime = null;
        JobDetail jobDetail = new JobDetail(jobName, "DEFAULT", JobWrapper.class);
        SimpleTrigger trigger = new SimpleTrigger(jobName, "DEFAULT", startTime, endTime, -1, intervalJob.getInterval());
        try {
            this._scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void setScheduler(Scheduler scheduler) {
        this._scheduler = scheduler;
    }

    public void shutdown() {
        try {
            if (!this._scheduler.isShutdown()) {
                this._scheduler.shutdown();
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void unschedule(IntervalJob intervalJob) {
        if (intervalJob == null) {
            return;
        }
        try {
            if (this._scheduler.isShutdown()) {
                return;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        try {
            String jobName = intervalJob.getClass().getName() + "@" + intervalJob.hashCode();
            this._scheduler.unscheduleJob(jobName, "DEFAULT");
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }
}

