/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.job;

import com.liferay.portal.dao.shard.ShardUtil;
import com.liferay.portal.job.JobClassUtil;
import com.liferay.portal.job.JobExecutionContextImpl;
import com.liferay.portal.kernel.job.IntervalJob;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.PropsValues;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.StatefulJob;

public class JobWrapper
implements StatefulJob {
    private static Log _log = LogFactoryUtil.getLog(JobWrapper.class);
    private ClassLoader _classLoader;
    private IntervalJob _job;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) {
        try {
            if (this._job == null) {
                JobDetail jobDetail = context.getJobDetail();
                Class<IntervalJob> intervalJobClass = JobClassUtil.get(jobDetail.getName());
                this._classLoader = intervalJobClass.getClassLoader();
                this._job = (IntervalJob)this._classLoader.loadClass(intervalJobClass.getName()).newInstance();
            }
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(this._classLoader);
                for (String shardName : PropsValues.SHARD_AVAILABLE_NAMES) {
                    ShardUtil.pushCompanyService(shardName);
                    try {
                        this._job.execute((com.liferay.portal.kernel.job.JobExecutionContext)new JobExecutionContextImpl(context));
                    }
                    finally {
                        ShardUtil.popCompanyService();
                    }
                }
            }
            finally {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }
}

