/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.json;

import com.liferay.portal.json.JSONArrayImpl;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONObjectImpl
implements JSONObject {
    private static Log _log = LogFactoryUtil.getLog(JSONObjectImpl.class);
    private org.json.JSONObject _jsonObj;

    public JSONObjectImpl() {
        this._jsonObj = new org.json.JSONObject();
    }

    public JSONObjectImpl(JSONObject jsonObj, String[] names) throws JSONException {
        try {
            JSONObjectImpl jsonObjImpl = (JSONObjectImpl)jsonObj;
            this._jsonObj = new org.json.JSONObject(jsonObjImpl.getJSONObject(), names);
        }
        catch (Exception e) {
            throw new JSONException((Throwable)e);
        }
    }

    public JSONObjectImpl(Map<?, ?> map) {
        this._jsonObj = new org.json.JSONObject(map);
    }

    public JSONObjectImpl(Object bean) {
        this._jsonObj = new org.json.JSONObject(bean);
    }

    public JSONObjectImpl(Object obj, String[] names) {
        this._jsonObj = new org.json.JSONObject(obj, names);
    }

    public JSONObjectImpl(String json) throws JSONException {
        try {
            this._jsonObj = new org.json.JSONObject(json);
        }
        catch (Exception e) {
            throw new JSONException((Throwable)e);
        }
    }

    public JSONObjectImpl(org.json.JSONObject jsonObj) {
        this._jsonObj = jsonObj;
    }

    public boolean getBoolean(String key) {
        return this._jsonObj.optBoolean(key);
    }

    public double getDouble(String key) {
        return this._jsonObj.optDouble(key);
    }

    public int getInt(String key) {
        return this._jsonObj.optInt(key);
    }

    public JSONArray getJSONArray(String key) {
        org.json.JSONArray jsonArray = this._jsonObj.optJSONArray(key);
        if (jsonArray == null) {
            return null;
        }
        return new JSONArrayImpl(jsonArray);
    }

    public org.json.JSONObject getJSONObject() {
        return this._jsonObj;
    }

    public JSONObject getJSONObject(String key) {
        org.json.JSONObject jsonObj = this._jsonObj.optJSONObject(key);
        if (jsonObj == null) {
            return null;
        }
        return new JSONObjectImpl(jsonObj);
    }

    public long getLong(String key) {
        return this._jsonObj.optLong(key);
    }

    public String getString(String key) {
        return this._jsonObj.optString(key);
    }

    public boolean has(String key) {
        return this._jsonObj.has(key);
    }

    public boolean isNull(String key) {
        return this._jsonObj.isNull(key);
    }

    public Iterator<String> keys() {
        return this._jsonObj.keys();
    }

    public int length() {
        return this._jsonObj.length();
    }

    public JSONObject put(String key, boolean value) {
        block2: {
            try {
                this._jsonObj.put(key, value);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return this;
    }

    public JSONObject put(String key, double value) {
        block2: {
            try {
                this._jsonObj.put(key, value);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return this;
    }

    public JSONObject put(String key, int value) {
        block2: {
            try {
                this._jsonObj.put(key, value);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return this;
    }

    public JSONObject put(String key, long value) {
        block2: {
            try {
                this._jsonObj.put(key, value);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return this;
    }

    public JSONObject put(String key, Date value) {
        block2: {
            try {
                this._jsonObj.put(key, (Object)value);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return this;
    }

    public JSONObject put(String key, JSONArray value) {
        block2: {
            try {
                this._jsonObj.put(key, (Object)((JSONArrayImpl)value).getJSONArray());
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return this;
    }

    public JSONObject put(String key, JSONObject value) {
        block2: {
            try {
                this._jsonObj.put(key, (Object)((JSONObjectImpl)value).getJSONObject());
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return this;
    }

    public JSONObject put(String key, String value) {
        block2: {
            try {
                this._jsonObj.put(key, (Object)value);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return this;
    }

    public Object remove(String key) {
        return this._jsonObj.remove(key);
    }

    public String toString() {
        return this._jsonObj.toString();
    }

    public String toString(int indentFactor) throws JSONException {
        try {
            return this._jsonObj.toString(indentFactor);
        }
        catch (Exception e) {
            throw new JSONException((Throwable)e);
        }
    }

    public Writer write(Writer writer) throws JSONException {
        try {
            return this._jsonObj.write(writer);
        }
        catch (Exception e) {
            throw new JSONException((Throwable)e);
        }
    }
}

