/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.language;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.struts.util.MessageResources;

public class LanguageResources {
    private static LanguageResources _instance = new LanguageResources();
    private Map<String, ResourceValue> _cache = new ConcurrentHashMap<String, ResourceValue>(10000);
    private MessageResources _messageResources;

    public static void clearCache() {
        _instance._clearCache();
    }

    public static String getMessage(Locale locale, String key) {
        return _instance._getMessage(locale, key);
    }

    public static void init(MessageResources messageResources) {
        _instance._init(messageResources);
    }

    public static boolean isInitialized() {
        return LanguageResources._instance._messageResources == null;
    }

    private LanguageResources() {
    }

    private void _clearCache() {
        this._cache.clear();
    }

    private String _getCacheKey(Locale locale, String key) {
        StringBuilder sb = new StringBuilder(String.valueOf(locale));
        sb.append("#");
        sb.append(key);
        return sb.toString();
    }

    private String _getMessage(Locale locale, String key) {
        String cacheKey = this._getCacheKey(locale, key);
        ResourceValue resourceValue = this._cache.get(cacheKey);
        if (resourceValue == null) {
            String value = this._messageResources.getMessage(locale, key);
            resourceValue = new ResourceValue(value);
            this._cache.put(cacheKey, resourceValue);
        }
        return resourceValue.getValue();
    }

    private void _init(MessageResources messageResources) {
        this._messageResources = messageResources;
    }

    private class ResourceValue {
        private String _value;

        private ResourceValue(String value) {
            this._value = value;
        }

        public String getValue() {
            return this._value;
        }
    }
}

