/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.NoSuchResourceException;
import com.liferay.portal.NoSuchRoleException;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.ResourceLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserGroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutCache {
    protected Map<String, Long> entityGroupIdMap = new HashMap<String, Long>();
    protected Map<String, Map<String, Long>> entityMapMap = new HashMap<String, Map<String, Long>>();
    protected Map<Long, List<Role>> groupRolesMap = new HashMap<Long, List<Role>>();
    protected Map<Long, List<User>> groupUsersMap = new HashMap<Long, List<User>>();
    protected Map<String, Resource> resourcesMap = new HashMap<String, Resource>();
    protected Map<String, Role> rolesMap = new HashMap<String, Role>();
    protected Map<Long, List<Role>> userRolesMap = new HashMap<Long, List<Role>>();
    protected Map<String, List<User>> usersMap = new HashMap<String, List<User>>();

    protected long getEntityGroupId(long companyId, String entityName, String name) throws SystemException {
        long entityGroupId = 0L;
        Long entityGroupIdObj = this.entityGroupIdMap.get(entityName);
        if (entityGroupIdObj == null) {
            List organizations;
            if (entityName.equals("user-group")) {
                List userGroups = UserGroupLocalServiceUtil.search((long)companyId, (String)name, null, null, (int)0, (int)1, null);
                if (userGroups.size() > 0) {
                    UserGroup userGroup = (UserGroup)userGroups.get(0);
                    Group group = userGroup.getGroup();
                    entityGroupId = group.getGroupId();
                }
            } else if (entityName.equals("organization") && (organizations = OrganizationLocalServiceUtil.search((long)companyId, (long)-1L, (String)name, null, null, null, null, null, null, null, (boolean)true, (int)0, (int)1)).size() > 0) {
                Organization organization = (Organization)organizations.get(0);
                Group group = organization.getGroup();
                entityGroupId = group.getGroupId();
            }
            this.entityGroupIdMap.put(entityName, entityGroupId);
        } else {
            entityGroupId = entityGroupIdObj;
        }
        return entityGroupId;
    }

    protected Map<String, Long> getEntityMap(long companyId, String entityName) throws SystemException {
        Map<String, Long> entityMap = this.entityMapMap.get(entityName);
        if (entityMap == null) {
            entityMap = new HashMap<String, Long>();
            if (entityName.equals("user-group")) {
                List userGroups = UserGroupLocalServiceUtil.search((long)companyId, null, null, null, (int)-1, (int)-1, null);
                for (int i = 0; i < userGroups.size(); ++i) {
                    UserGroup userGroup = (UserGroup)userGroups.get(i);
                    Group group = userGroup.getGroup();
                    entityMap.put(userGroup.getName(), group.getGroupId());
                }
            } else if (entityName.equals("organization")) {
                List organizations = OrganizationLocalServiceUtil.search((long)companyId, (long)-1L, null, (String)"regular-organization", null, null, null, (int)-1, (int)-1);
                for (int i = 0; i < organizations.size(); ++i) {
                    Organization organization = (Organization)organizations.get(i);
                    Group group = organization.getGroup();
                    entityMap.put(organization.getName(), group.getGroupId());
                }
            }
            this.entityMapMap.put(entityName, entityMap);
        }
        return entityMap;
    }

    protected List<Role> getGroupRoles_4(long groupId) throws SystemException {
        List roles = this.groupRolesMap.get(groupId);
        if (roles == null) {
            roles = RoleLocalServiceUtil.getGroupRoles((long)groupId);
            this.groupRolesMap.put(groupId, roles);
        }
        return roles;
    }

    protected List<Role> getGroupRoles_5(long groupId, String resourceName) throws PortalException, SystemException {
        List<Role> roles = this.groupRolesMap.get(groupId);
        if (roles == null) {
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            roles = ResourceActionsUtil.getRoles(group, resourceName);
            this.groupRolesMap.put(groupId, roles);
        }
        return roles;
    }

    protected List<User> getGroupUsers(long groupId) throws SystemException {
        List users = this.groupUsersMap.get(groupId);
        if (users == null) {
            users = UserLocalServiceUtil.getGroupUsers((long)groupId);
            this.groupUsersMap.put(groupId, users);
        }
        return users;
    }

    protected Resource getResource(long companyId, long groupId, String resourceName, int scope, String resourcePrimKey, boolean portletActions) throws PortalException, SystemException {
        StringBundler sb = new StringBundler(5);
        sb.append(resourceName);
        sb.append("|");
        sb.append(scope);
        sb.append("|");
        sb.append(resourcePrimKey);
        String key = sb.toString();
        Resource resource = this.resourcesMap.get(key);
        if (resource == null) {
            try {
                resource = ResourceLocalServiceUtil.getResource((long)companyId, (String)resourceName, (int)scope, (String)resourcePrimKey);
            }
            catch (NoSuchResourceException nsre) {
                ResourceLocalServiceUtil.addResources((long)companyId, (long)groupId, (long)0L, (String)resourceName, (String)resourcePrimKey, (boolean)portletActions, (boolean)true, (boolean)true);
                resource = ResourceLocalServiceUtil.getResource((long)companyId, (String)resourceName, (int)scope, (String)resourcePrimKey);
            }
            this.resourcesMap.put(key, resource);
        }
        return resource;
    }

    protected Role getRole(long companyId, String roleName) throws PortalException, SystemException {
        Role role = this.rolesMap.get(roleName);
        if (role == null) {
            try {
                role = RoleLocalServiceUtil.getRole((long)companyId, (String)roleName);
                this.rolesMap.put(roleName, role);
            }
            catch (NoSuchRoleException nsre) {
                // empty catch block
            }
        }
        return role;
    }

    protected User getUser(long companyId, long groupId, String uuid) throws SystemException {
        List users = this.usersMap.get(uuid);
        if (users == null) {
            LinkedHashMap<String, Long> params = new LinkedHashMap<String, Long>();
            params.put("usersGroups", new Long(groupId));
            try {
                User user = UserLocalServiceUtil.getUserByUuid((String)uuid);
                users = UserLocalServiceUtil.search((long)companyId, null, null, null, (String)user.getScreenName(), null, (Boolean)Boolean.TRUE, params, (boolean)true, (int)0, (int)1, (OrderByComparator)null);
            }
            catch (PortalException pe) {
                // empty catch block
            }
            this.usersMap.put(uuid, users);
        }
        if (users.size() == 0) {
            return null;
        }
        return users.get(0);
    }

    protected List<Role> getUserRoles(long userId) throws SystemException {
        List userRoles = this.userRolesMap.get(userId);
        if (userRoles == null) {
            userRoles = RoleLocalServiceUtil.getUserRoles((long)userId);
            this.userRolesMap.put(userId, userRoles);
        }
        return userRoles;
    }
}

