/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactoryUtil;
import com.liferay.portal.lar.LayoutCache;
import com.liferay.portal.lar.PortletDataContext;
import com.liferay.portal.lar.PortletDataContextImpl;
import com.liferay.portal.lar.PortletDataHandler;
import com.liferay.portal.lar.PortletExporter;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.Theme;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.service.persistence.LayoutUtil;
import com.liferay.portal.theme.ThemeLoader;
import com.liferay.portal.theme.ThemeLoaderFactory;
import com.liferay.portal.util.ContentUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.velocity.VelocityContextPool;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.tags.model.TagsEntry;
import com.liferay.portlet.tags.model.TagsVocabulary;
import com.liferay.portlet.tags.service.TagsEntryLocalServiceUtil;
import com.liferay.portlet.tags.service.TagsVocabularyLocalServiceUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.servlet.ServletContext;
import org.apache.commons.lang.time.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutExporter {
    private static Log _log = LogFactoryUtil.getLog(LayoutExporter.class);
    private PortletExporter _portletExporter = new PortletExporter();

    public static List<Portlet> getAlwaysExportablePortlets(long companyId) throws SystemException {
        List portlets = PortletLocalServiceUtil.getPortlets((long)companyId);
        Iterator itr = portlets.iterator();
        while (itr.hasNext()) {
            Portlet portlet = (Portlet)itr.next();
            if (!portlet.isActive()) {
                itr.remove();
                continue;
            }
            PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
            if (portletDataHandler != null && portletDataHandler.isAlwaysExportable()) continue;
            itr.remove();
        }
        return portlets;
    }

    public byte[] exportLayouts(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        File file = this.exportLayoutsAsFile(groupId, privateLayout, layoutIds, parameterMap, startDate, endDate);
        try {
            byte[] byArray = FileUtil.getBytes((File)file);
            return byArray;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        finally {
            file.delete();
        }
    }

    public File exportLayoutsAsFile(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        boolean exportCategories = MapUtil.getBoolean(parameterMap, (String)"CATEGORIES");
        boolean exportPermissions = MapUtil.getBoolean(parameterMap, (String)"PERMISSIONS");
        boolean exportUserPermissions = MapUtil.getBoolean(parameterMap, (String)"USER_PERMISSIONS");
        boolean exportPortletArchivedSetups = MapUtil.getBoolean(parameterMap, (String)"PORTLET_ARCHIVED_SETUPS");
        boolean exportPortletUserPreferences = MapUtil.getBoolean(parameterMap, (String)"PORTLET_USER_PREFERENCES");
        boolean exportTheme = MapUtil.getBoolean(parameterMap, (String)"THEME");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export categories " + exportCategories));
            _log.debug((Object)("Export permissions " + exportPermissions));
            _log.debug((Object)("Export user permissions " + exportUserPermissions));
            _log.debug((Object)("Export portlet archived setups " + exportPortletArchivedSetups));
            _log.debug((Object)("Export portlet user preferences " + exportPortletUserPreferences));
            _log.debug((Object)("Export theme " + exportTheme));
        }
        StopWatch stopWatch = null;
        if (_log.isInfoEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        LayoutCache layoutCache = new LayoutCache();
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
        long companyId = layoutSet.getCompanyId();
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
        ZipWriter zipWriter = ZipWriterFactoryUtil.getZipWriter();
        PortletDataContextImpl context = new PortletDataContextImpl(companyId, groupId, parameterMap, new HashSet<String>(), startDate, endDate, zipWriter);
        Group guestGroup = GroupLocalServiceUtil.getGroup((long)companyId, (String)"Guest");
        Document doc = SAXReaderUtil.createDocument();
        Element root = doc.addElement("root");
        Element header = root.addElement("header");
        header.addAttribute("build-number", String.valueOf(ReleaseInfo.getBuildNumber()));
        header.addAttribute("export-date", Time.getRFC822());
        if (context.hasDateRange()) {
            header.addAttribute("start-date", String.valueOf(context.getStartDate()));
            header.addAttribute("end-date", String.valueOf(context.getEndDate()));
        }
        header.addAttribute("type", "layout-set");
        header.addAttribute("group-id", String.valueOf(groupId));
        header.addAttribute("private-layout", String.valueOf(privateLayout));
        header.addAttribute("theme-id", layoutSet.getThemeId());
        header.addAttribute("color-scheme-id", layoutSet.getColorSchemeId());
        Portlet layoutConfigurationPortlet = PortletLocalServiceUtil.getPortletById((long)context.getCompanyId(), (String)"87");
        LinkedHashMap<String, Object[]> portletIds = new LinkedHashMap<String, Object[]>();
        List layouts = null;
        layouts = layoutIds == null || layoutIds.length == 0 ? LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout) : LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout, (long[])layoutIds);
        Element layoutsEl = root.addElement("layouts");
        for (Layout layout : layouts) {
            Image image;
            boolean deleteLayout = MapUtil.getBoolean(parameterMap, (String)("delete_" + layout.getPlid()));
            if (deleteLayout) {
                Element el = layoutsEl.addElement("layout");
                el.addAttribute("layout-id", String.valueOf(layout.getLayoutId()));
                el.addAttribute("delete", String.valueOf(true));
                continue;
            }
            context.setPlid(layout.getPlid());
            Document layoutDoc = SAXReaderUtil.createDocument();
            Element layoutEl = layoutDoc.addElement("layout");
            layoutEl.addAttribute("old-plid", String.valueOf(layout.getPlid()));
            layoutEl.addAttribute("layout-id", String.valueOf(layout.getLayoutId()));
            layoutEl.addElement("parent-layout-id").addText(String.valueOf(layout.getParentLayoutId()));
            layoutEl.addElement("name").addCDATA(layout.getName());
            layoutEl.addElement("title").addCDATA(layout.getTitle());
            layoutEl.addElement("description").addText(layout.getDescription());
            layoutEl.addElement("type").addText(layout.getType());
            layoutEl.addElement("type-settings").addCDATA(layout.getTypeSettings());
            layoutEl.addElement("hidden").addText(String.valueOf(layout.getHidden()));
            layoutEl.addElement("friendly-url").addText(layout.getFriendlyURL());
            layoutEl.addElement("icon-image").addText(String.valueOf(layout.getIconImage()));
            if (layout.isIconImage() && (image = ImageLocalServiceUtil.getImage((long)layout.getIconImageId())) != null) {
                String iconPath = this.getLayoutIconPath(context, layout, image);
                layoutEl.addElement("icon-image-path").addText(iconPath);
                context.addZipEntry(iconPath, image.getTextObj());
            }
            layoutEl.addElement("theme-id").addText(layout.getThemeId());
            layoutEl.addElement("color-scheme-id").addText(layout.getColorSchemeId());
            layoutEl.addElement("wap-theme-id").addText(layout.getWapThemeId());
            layoutEl.addElement("wap-color-scheme-id").addText(layout.getWapColorSchemeId());
            layoutEl.addElement("css").addCDATA(layout.getCss());
            layoutEl.addElement("priority").addText(String.valueOf(layout.getPriority()));
            if (exportPermissions) {
                Element permissionsEl = layoutEl.addElement("permissions");
                String resourceName = Layout.class.getName();
                String resourcePrimKey = String.valueOf(layout.getPlid());
                if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
                    this.exportLayoutPermissions_5(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsEl);
                } else if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                    this.exportLayoutPermissions_6(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsEl);
                } else {
                    this.exportLayoutPermissions_4(layoutCache, companyId, groupId, guestGroup, resourceName, resourcePrimKey, permissionsEl, exportUserPermissions);
                }
            }
            if (layout.getType().equals("portlet")) {
                LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
                long scopeGroupId = groupId;
                for (String portletId : layoutTypePortlet.getPortletIds()) {
                    Layout scopeLayout;
                    Group scopeGroup;
                    PortletPreferences jxPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
                    long scopeLayoutId = GetterUtil.getLong((String)jxPreferences.getValue("lfr-scope-layout-id", null));
                    if (scopeLayoutId != 0L && (scopeGroup = (scopeLayout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)layout.isPrivateLayout(), (long)scopeLayoutId)).getScopeGroup()) != null) {
                        scopeGroupId = scopeGroup.getGroupId();
                    }
                    String key = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
                    portletIds.put(key, new Object[]{portletId, layout.getPlid(), scopeGroupId, scopeLayoutId});
                }
            }
            List<Portlet> portlets = LayoutExporter.getAlwaysExportablePortlets(context.getCompanyId());
            for (Portlet portlet : portlets) {
                String key;
                String portletId = portlet.getRootPortletId();
                if (portlet.isScopeable() && layout.hasScopeGroup()) {
                    key = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
                    portletIds.put(key, new Object[]{portletId, layout.getPlid(), layout.getScopeGroup().getGroupId(), layout.getLayoutId()});
                    continue;
                }
                key = PortletPermissionUtil.getPrimaryKey((long)0L, (String)portletId);
                if (portletIds.get(key) != null) continue;
                portletIds.put(key, new Object[]{portletId, layout.getPlid(), groupId, 0L});
            }
            String layoutPath = context.getLayoutPath(layout.getLayoutId()) + "/layout.xml";
            Element el = layoutsEl.addElement("layout");
            el.addAttribute("layout-id", String.valueOf(layout.getLayoutId()));
            el.addAttribute("path", layoutPath);
            this._portletExporter.exportPortletData(context, layoutConfigurationPortlet, layout, null, layoutEl);
            try {
                context.addZipEntry(layoutPath, layoutDoc.formattedString());
            }
            catch (IOException ioe) {}
        }
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM < 5) {
            Element rolesEl = root.addElement("roles");
            if (exportPermissions) {
                this.exportLayoutRoles(layoutCache, companyId, groupId, rolesEl);
            }
        }
        long previousScopeGroupId = context.getScopeGroupId();
        Element portletsEl = root.addElement("portlets");
        for (Map.Entry portletIdsEntry : portletIds.entrySet()) {
            String portletId = (String)((Object[])portletIdsEntry.getValue())[0];
            long plid = (Long)((Object[])portletIdsEntry.getValue())[1];
            long scopeGroupId = (Long)((Object[])portletIdsEntry.getValue())[2];
            long scopeLayoutId = (Long)((Object[])portletIdsEntry.getValue())[3];
            Layout layout = LayoutUtil.findByPrimaryKey((long)plid);
            context.setPlid(layout.getPlid());
            context.setOldPlid(layout.getPlid());
            context.setScopeGroupId(scopeGroupId);
            context.setScopeLayoutId(scopeLayoutId);
            boolean[] exportPortletControls = this.getExportPortletControls(context.getCompanyId(), portletId, context, parameterMap);
            this._portletExporter.exportPortlet(context, layoutCache, portletId, layout, portletsEl, defaultUserId, exportPermissions, exportPortletArchivedSetups, exportPortletControls[0], exportPortletControls[1], exportPortletUserPreferences, exportUserPermissions);
        }
        context.setScopeGroupId(previousScopeGroupId);
        if (exportCategories) {
            this.exportCategories(context);
        }
        this._portletExporter.exportCategories(context, root);
        this._portletExporter.exportComments(context, root);
        this._portletExporter.exportRatings(context, root);
        this._portletExporter.exportTags(context, root);
        try {
            if (exportTheme) {
                this.exportTheme(layoutSet, zipWriter);
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Exporting layouts takes " + stopWatch.getTime() + " ms"));
            }
            context.addZipEntry("/manifest.xml", doc.formattedString());
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        return zipWriter.getFile();
    }

    protected void exportCategories(PortletDataContext context) throws SystemException {
        try {
            Document doc = SAXReaderUtil.createDocument();
            Element root = doc.addElement("categories-hierarchy");
            List tagsVocabularies = TagsVocabularyLocalServiceUtil.getGroupVocabularies((long)context.getGroupId(), (boolean)false);
            for (TagsVocabulary tagsVocabulary : tagsVocabularies) {
                Element vocabularyEl = root.addElement("vocabulary");
                String name = tagsVocabulary.getName();
                vocabularyEl.addAttribute("name", name);
                vocabularyEl.addAttribute("userUuid", tagsVocabulary.getUserUuid());
                List tagsCategories = TagsEntryLocalServiceUtil.getGroupVocabularyEntries((long)context.getGroupId(), (String)name);
                tagsCategories = ListUtil.copy((List)tagsCategories);
                this.orderCategories(tagsCategories, vocabularyEl, 0L);
            }
            context.addZipEntry(context.getRootPath() + "/categories-hierarchy.xml", doc.formattedString());
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected void exportLayoutPermissions_4(LayoutCache layoutCache, long companyId, long groupId, Group guestGroup, String resourceName, String resourcePrimKey, Element permissionsEl, boolean exportUserPermissions) throws SystemException {
        this._portletExporter.exportGroupPermissions(companyId, groupId, resourceName, resourcePrimKey, permissionsEl, "community-actions");
        if (groupId != guestGroup.getGroupId()) {
            this._portletExporter.exportGroupPermissions(companyId, guestGroup.getGroupId(), resourceName, resourcePrimKey, permissionsEl, "guest-actions");
        }
        if (exportUserPermissions) {
            this._portletExporter.exportUserPermissions(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsEl);
        }
        this._portletExporter.exportInheritedPermissions(layoutCache, companyId, resourceName, resourcePrimKey, permissionsEl, "organization");
        this._portletExporter.exportInheritedPermissions(layoutCache, companyId, resourceName, resourcePrimKey, permissionsEl, "user-group");
    }

    protected void exportLayoutPermissions_5(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String resourcePrimKey, Element permissionsEl) throws PortalException, SystemException {
        boolean portletActions = false;
        Resource resource = layoutCache.getResource(companyId, groupId, resourceName, 4, resourcePrimKey, portletActions);
        this._portletExporter.exportPermissions_5(layoutCache, groupId, resourceName, resource.getResourceId(), permissionsEl);
    }

    protected void exportLayoutPermissions_6(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String resourcePrimKey, Element permissionsEl) throws PortalException, SystemException {
        boolean portletActions = false;
        this._portletExporter.exportPermissions_6(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsEl, portletActions);
    }

    protected void exportLayoutRoles(LayoutCache layoutCache, long companyId, long groupId, Element rolesEl) throws SystemException {
        String resourceName = Layout.class.getName();
        this._portletExporter.exportGroupRoles(layoutCache, companyId, groupId, resourceName, "community", rolesEl);
        this._portletExporter.exportUserRoles(layoutCache, companyId, groupId, resourceName, rolesEl);
        this._portletExporter.exportInheritedRoles(layoutCache, companyId, groupId, resourceName, "organization", rolesEl);
        this._portletExporter.exportInheritedRoles(layoutCache, companyId, groupId, resourceName, "user-group", rolesEl);
    }

    protected void exportTheme(LayoutSet layoutSet, ZipWriter zipWriter) throws IOException, SystemException {
        Theme theme = layoutSet.getTheme();
        String lookAndFeelXML = ContentUtil.get("com/liferay/portal/dependencies/liferay-look-and-feel.xml.tmpl");
        lookAndFeelXML = StringUtil.replace((String)lookAndFeelXML, (String[])new String[]{"[$TEMPLATE_EXTENSION$]", "[$VIRTUAL_PATH$]"}, (String[])new String[]{theme.getTemplateExtension(), theme.getVirtualPath()});
        String servletContextName = theme.getServletContextName();
        ServletContext servletContext = VelocityContextPool.get(servletContextName);
        if (servletContext == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Servlet context not found for theme " + theme.getThemeId()));
            }
            return;
        }
        File themeZip = new File(zipWriter.getPath() + "/theme.zip");
        ZipWriter themeZipWriter = ZipWriterFactoryUtil.getZipWriter((File)themeZip);
        themeZipWriter.addEntry("liferay-look-and-feel.xml", lookAndFeelXML);
        File cssPath = null;
        File imagesPath = null;
        File javaScriptPath = null;
        File templatesPath = null;
        if (!theme.isLoadFromServletContext()) {
            ThemeLoader themeLoader = ThemeLoaderFactory.getThemeLoader(servletContextName);
            if (themeLoader == null) {
                _log.error((Object)(servletContextName + " does not map to a theme loader"));
            } else {
                String realPath = themeLoader.getFileStorage().getPath() + "/" + theme.getName();
                cssPath = new File(realPath + "/css");
                imagesPath = new File(realPath + "/images");
                javaScriptPath = new File(realPath + "/javascript");
                templatesPath = new File(realPath + "/templates");
            }
        } else {
            cssPath = new File(servletContext.getRealPath(theme.getCssPath()));
            imagesPath = new File(servletContext.getRealPath(theme.getImagesPath()));
            javaScriptPath = new File(servletContext.getRealPath(theme.getJavaScriptPath()));
            templatesPath = new File(servletContext.getRealPath(theme.getTemplatesPath()));
        }
        this.exportThemeFiles("css", cssPath, themeZipWriter);
        this.exportThemeFiles("images", imagesPath, themeZipWriter);
        this.exportThemeFiles("javascript", javaScriptPath, themeZipWriter);
        this.exportThemeFiles("templates", templatesPath, themeZipWriter);
    }

    protected void exportThemeFiles(String path, File dir, ZipWriter zipWriter) throws IOException {
        File[] files;
        if (dir == null || !dir.exists()) {
            return;
        }
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                this.exportThemeFiles(path + "/" + file.getName(), file, zipWriter);
                continue;
            }
            zipWriter.addEntry(path + "/" + file.getName(), FileUtil.getBytes((File)file));
        }
    }

    protected boolean[] getExportPortletControls(long companyId, String portletId, PortletDataContext context, Map<String, String[]> parameterMap) throws SystemException {
        boolean exportPortletData = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA");
        boolean exportPortletDataAll = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA_ALL");
        boolean exportPortletSetup = MapUtil.getBoolean(parameterMap, (String)"PORTLET_SETUP");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export portlet data " + exportPortletData));
            _log.debug((Object)("Export all portlet data " + exportPortletDataAll));
            _log.debug((Object)("Export portlet setup " + exportPortletSetup));
        }
        boolean exportCurPortletData = exportPortletData;
        boolean exportCurPortletSetup = exportPortletSetup;
        if (exportPortletDataAll) {
            exportCurPortletData = true;
            exportCurPortletSetup = true;
        } else {
            String portletDataHandlerClass;
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
            if (portlet != null && (portletDataHandlerClass = portlet.getPortletDataHandlerClass()) != null) {
                String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
                exportCurPortletData = exportPortletData && MapUtil.getBoolean(parameterMap, (String)("PORTLET_DATA_" + rootPortletId));
                exportCurPortletSetup = exportPortletData && MapUtil.getBoolean(parameterMap, (String)("PORTLET_SETUP_" + rootPortletId));
            }
        }
        return new boolean[]{exportCurPortletData, exportCurPortletSetup};
    }

    protected String getLayoutIconPath(PortletDataContext context, Layout layout, Image image) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getLayoutPath(layout.getLayoutId()));
        sb.append("/icons/");
        sb.append(image.getImageId());
        sb.append(".");
        sb.append(image.getType());
        return sb.toString();
    }

    protected void orderCategories(List<TagsEntry> tagsCategories, Element parentEl, long parentEntryId) throws PortalException, SystemException {
        ArrayList<TagsEntry> tagsParentCategories = new ArrayList<TagsEntry>();
        Iterator<TagsEntry> itr = tagsCategories.iterator();
        while (itr.hasNext()) {
            TagsEntry tagsCategory = itr.next();
            if (tagsCategory.getParentEntryId() != parentEntryId) continue;
            Element categoryEl = parentEl.addElement("category");
            categoryEl.addAttribute("name", tagsCategory.getName());
            categoryEl.addAttribute("parentEntryName", tagsCategory.getParentName());
            categoryEl.addAttribute("userUuid", tagsCategory.getUserUuid());
            tagsParentCategories.add(tagsCategory);
            itr.remove();
        }
        for (TagsEntry tagsParentCategory : tagsParentCategories) {
            this.orderCategories(tagsCategories, parentEl, tagsParentCategory.getEntryId());
        }
    }
}

