/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.LARFileException;
import com.liferay.portal.LARTypeException;
import com.liferay.portal.LayoutImportException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.cluster.ClusterLinkUtil;
import com.liferay.portal.kernel.cluster.Priority;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.MethodWrapper;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactoryUtil;
import com.liferay.portal.lar.LayoutCache;
import com.liferay.portal.lar.PortletDataContext;
import com.liferay.portal.lar.PortletDataContextImpl;
import com.liferay.portal.lar.PortletImporter;
import com.liferay.portal.lar.UserIdStrategy;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutTemplate;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.ColorSchemeImpl;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.LayoutTemplateLocalServiceUtil;
import com.liferay.portal.service.PermissionLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.service.persistence.LayoutUtil;
import com.liferay.portal.service.persistence.UserUtil;
import com.liferay.portal.theme.ThemeLoader;
import com.liferay.portal.theme.ThemeLoaderFactory;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.tags.DuplicateEntryException;
import com.liferay.portlet.tags.DuplicateVocabularyException;
import com.liferay.portlet.tags.service.TagsEntryLocalServiceUtil;
import com.liferay.portlet.tags.service.TagsVocabularyLocalServiceUtil;
import com.liferay.util.LocalizationUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.time.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutImporter {
    private static Log _log = LogFactoryUtil.getLog(LayoutImporter.class);
    private PortletImporter _portletImporter = new PortletImporter();

    public void importLayouts(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        boolean deleteMissingLayouts = MapUtil.getBoolean(parameterMap, (String)"DELETE_MISSING_LAYOUTS", (boolean)Boolean.TRUE);
        boolean deletePortletData = MapUtil.getBoolean(parameterMap, (String)"DELETE_PORTLET_DATA");
        boolean importCategories = MapUtil.getBoolean(parameterMap, (String)"CATEGORIES");
        boolean importPermissions = MapUtil.getBoolean(parameterMap, (String)"PERMISSIONS");
        boolean importUserPermissions = MapUtil.getBoolean(parameterMap, (String)"PERMISSIONS");
        boolean importPortletData = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA");
        boolean importPortletSetup = MapUtil.getBoolean(parameterMap, (String)"PORTLET_SETUP");
        boolean importPortletArchivedSetups = MapUtil.getBoolean(parameterMap, (String)"PORTLET_ARCHIVED_SETUPS");
        boolean importPortletUserPreferences = MapUtil.getBoolean(parameterMap, (String)"PORTLET_USER_PREFERENCES");
        boolean importTheme = MapUtil.getBoolean(parameterMap, (String)"THEME");
        String layoutsImportMode = MapUtil.getString(parameterMap, (String)"LAYOUTS_IMPORT_MODE", (String)"MERGE_BY_LAYOUT_ID");
        String portletsMergeMode = MapUtil.getString(parameterMap, (String)"PORTLETS_MERGE_MODE", (String)"REPLACE");
        String userIdStrategy = MapUtil.getString(parameterMap, (String)"USER_ID_STRATEGY");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Delete portlet data " + deletePortletData));
            _log.debug((Object)("Import categories " + importCategories));
            _log.debug((Object)("Import permissions " + importPermissions));
            _log.debug((Object)("Import user permissions " + importUserPermissions));
            _log.debug((Object)("Import portlet data " + importPortletData));
            _log.debug((Object)("Import portlet setup " + importPortletSetup));
            _log.debug((Object)("Import portlet archived setups " + importPortletArchivedSetups));
            _log.debug((Object)("Import portlet user preferences " + importPortletUserPreferences));
            _log.debug((Object)("Import theme " + importTheme));
        }
        StopWatch stopWatch = null;
        if (_log.isInfoEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        LayoutCache layoutCache = new LayoutCache();
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
        long companyId = layoutSet.getCompanyId();
        User user = UserUtil.findByPrimaryKey((long)userId);
        UserIdStrategy strategy = this._portletImporter.getUserIdStrategy(user, userIdStrategy);
        ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
        PortletDataContextImpl context = new PortletDataContextImpl(companyId, groupId, parameterMap, new HashSet<String>(), strategy, zipReader);
        context.setPrivateLayout(privateLayout);
        Group guestGroup = GroupLocalServiceUtil.getGroup((long)companyId, (String)"Guest");
        Element root = null;
        InputStream themeZip = null;
        String xml = context.getZipEntryAsString("/manifest.xml");
        if (xml == null) {
            throw new LARFileException("manifest.xml not found in the LAR");
        }
        try {
            Document doc = SAXReaderUtil.read((String)xml);
            root = doc.getRootElement();
        }
        catch (Exception e) {
            throw new LARFileException((Throwable)e);
        }
        Element header = root.element("header");
        int buildNumber = ReleaseInfo.getBuildNumber();
        int importBuildNumber = GetterUtil.getInteger((String)header.attributeValue("build-number"));
        if (buildNumber != importBuildNumber) {
            throw new LayoutImportException("LAR build number " + importBuildNumber + " does not match " + "portal build number " + buildNumber);
        }
        String larType = header.attributeValue("type");
        if (!larType.equals("layout-set")) {
            throw new LARTypeException("Invalid type of LAR file (" + larType + ")");
        }
        long sourceGroupId = GetterUtil.getLong((String)header.attributeValue("group-id"));
        context.setSourceGroupId(sourceGroupId);
        if (importTheme) {
            themeZip = context.getZipEntryAsInputStream("theme.zip");
        }
        String themeId = header.attributeValue("theme-id");
        String colorSchemeId = header.attributeValue("color-scheme-id");
        boolean useThemeZip = false;
        if (themeZip != null) {
            try {
                String importThemeId = this.importTheme(layoutSet, themeZip);
                if (importThemeId != null) {
                    themeId = importThemeId;
                    colorSchemeId = ColorSchemeImpl.getDefaultRegularColorSchemeId();
                    useThemeZip = true;
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Importing theme takes " + stopWatch.getTime() + " ms"));
                }
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }
        boolean wapTheme = false;
        LayoutSetLocalServiceUtil.updateLookAndFeel((long)groupId, (boolean)privateLayout, (String)themeId, (String)colorSchemeId, (String)"", (boolean)wapTheme);
        if (importCategories) {
            this.importCategories(context);
        }
        this._portletImporter.readCategories(context, root);
        this._portletImporter.readComments(context, root);
        this._portletImporter.readRatings(context, root);
        this._portletImporter.readTags(context, root);
        List previousLayouts = LayoutUtil.findByG_P((long)groupId, (boolean)privateLayout);
        ArrayList<Layout> newLayouts = new ArrayList<Layout>();
        HashSet<Long> newLayoutIds = new HashSet<Long>();
        Map newLayoutIdPlidMap = context.getNewPrimaryKeysMap(Layout.class);
        List layoutEls = root.element("layouts").elements("layout");
        if (_log.isDebugEnabled() && layoutEls.size() > 0) {
            _log.debug((Object)"Importing layouts");
        }
        for (Element layoutRefEl : layoutEls) {
            long layoutId;
            long oldLayoutId = layoutId = (long)GetterUtil.getInteger((String)layoutRefEl.attributeValue("layout-id"));
            boolean deleteLayout = GetterUtil.getBoolean((String)layoutRefEl.attributeValue("delete"));
            if (deleteLayout) {
                try {
                    LayoutLocalServiceUtil.deleteLayout((long)context.getGroupId(), (boolean)privateLayout, (long)oldLayoutId);
                }
                catch (NoSuchLayoutException nsle) {
                    _log.warn((Object)("Error deleting layout for {" + sourceGroupId + ", " + privateLayout + ", " + oldLayoutId + "}"));
                }
                continue;
            }
            String layoutPath = layoutRefEl.attributeValue("path");
            Element layoutEl = null;
            try {
                Document layoutDoc = SAXReaderUtil.read((String)context.getZipEntryAsString(layoutPath));
                layoutEl = layoutDoc.getRootElement();
            }
            catch (DocumentException de) {
                throw new SystemException((Throwable)de);
            }
            long parentLayoutId = GetterUtil.getInteger((String)layoutEl.elementText("parent-layout-id"));
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Importing layout with layout id " + layoutId + " and parent layout id " + parentLayoutId));
            }
            long oldPlid = GetterUtil.getInteger((String)layoutEl.attributeValue("old-plid"));
            String name = layoutEl.elementText("name");
            String title = layoutEl.elementText("title");
            String description = layoutEl.elementText("description");
            String type = layoutEl.elementText("type");
            String typeSettings = layoutEl.elementText("type-settings");
            boolean hidden = GetterUtil.getBoolean((String)layoutEl.elementText("hidden"));
            String friendlyURL = layoutEl.elementText("friendly-url");
            boolean iconImage = GetterUtil.getBoolean((String)layoutEl.elementText("icon-image"));
            byte[] iconBytes = null;
            if (iconImage) {
                String path = layoutEl.elementText("icon-image-path");
                iconBytes = context.getZipEntryAsByteArray(path);
            }
            if (useThemeZip) {
                themeId = "";
                colorSchemeId = "";
            } else {
                themeId = layoutEl.elementText("theme-id");
                colorSchemeId = layoutEl.elementText("color-scheme-id");
            }
            String wapThemeId = layoutEl.elementText("wap-theme-id");
            String wapColorSchemeId = layoutEl.elementText("wap-color-scheme-id");
            String css = layoutEl.elementText("css");
            int priority = GetterUtil.getInteger((String)layoutEl.elementText("priority"));
            Layout layout = null;
            if (layoutsImportMode.equals("ADD_AS_NEW")) {
                layoutId = LayoutLocalServiceUtil.getNextLayoutId((long)groupId, (boolean)privateLayout);
                friendlyURL = "/" + layoutId;
            } else if (layoutsImportMode.equals("MERGE_BY_LAYOUT_NAME")) {
                Locale locale = LocaleUtil.getDefault();
                String localizedName = LocalizationUtil.getLocalization((String)name, (String)LocaleUtil.toLanguageId((Locale)locale));
                for (Layout curLayout : previousLayouts) {
                    if (!curLayout.getName(locale).equals(localizedName)) continue;
                    layout = curLayout;
                    break;
                }
                if (layout == null) {
                    layoutId = LayoutLocalServiceUtil.getNextLayoutId((long)groupId, (boolean)privateLayout);
                }
            } else {
                layout = LayoutUtil.fetchByG_P_L((long)groupId, (boolean)privateLayout, (long)layoutId);
            }
            if (_log.isDebugEnabled()) {
                if (layout == null) {
                    _log.debug((Object)("Layout with {groupId=" + groupId + ",privateLayout=" + privateLayout + ",layoutId=" + layoutId + "} does not exist"));
                } else {
                    _log.debug((Object)("Layout with {groupId=" + groupId + ",privateLayout=" + privateLayout + ",layoutId=" + layoutId + "} exists"));
                }
            }
            if (layout == null) {
                long plid = CounterLocalServiceUtil.increment();
                layout = LayoutUtil.create((long)plid);
                layout.setGroupId(groupId);
                layout.setPrivateLayout(privateLayout);
                layout.setLayoutId(layoutId);
            }
            layout.setCompanyId(user.getCompanyId());
            layout.setParentLayoutId(parentLayoutId);
            layout.setName(name);
            layout.setTitle(title);
            layout.setDescription(description);
            layout.setType(type);
            if (layout.getType().equals("portlet") && Validator.isNotNull((String)layout.getTypeSettings()) && !portletsMergeMode.equals("REPLACE")) {
                this.mergePortlets(layout, typeSettings, portletsMergeMode);
            } else {
                layout.setTypeSettings(typeSettings);
            }
            layout.setHidden(hidden);
            layout.setFriendlyURL(friendlyURL);
            if (iconImage) {
                layout.setIconImage(iconImage);
                if (layout.isNew()) {
                    long iconImageId = CounterLocalServiceUtil.increment();
                    layout.setIconImageId(iconImageId);
                }
            }
            layout.setThemeId(themeId);
            layout.setColorSchemeId(colorSchemeId);
            layout.setWapThemeId(wapThemeId);
            layout.setWapColorSchemeId(wapColorSchemeId);
            layout.setCss(css);
            layout.setPriority(priority);
            this.fixTypeSettings(layout);
            LayoutUtil.update((Layout)layout, (boolean)false);
            if (iconBytes != null && iconBytes.length > 0) {
                ImageLocalServiceUtil.updateImage((long)layout.getIconImageId(), (byte[])iconBytes);
            }
            context.setPlid(layout.getPlid());
            context.setOldPlid(oldPlid);
            newLayoutIdPlidMap.put(oldLayoutId, layout.getPlid());
            newLayoutIds.add(layoutId);
            newLayouts.add(layout);
            Element permissionsEl = layoutEl.element("permissions");
            if (importPermissions && permissionsEl != null) {
                String resourceName = Layout.class.getName();
                String resourcePrimKey = String.valueOf(layout.getPlid());
                if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
                    this.importLayoutPermissions_5(layoutCache, companyId, groupId, userId, resourceName, resourcePrimKey, permissionsEl);
                } else if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                    this.importLayoutPermissions_6(layoutCache, companyId, groupId, userId, resourceName, resourcePrimKey, permissionsEl);
                } else {
                    this.importLayoutPermissions_4(layoutCache, companyId, groupId, guestGroup, layout, resourceName, resourcePrimKey, permissionsEl, importUserPermissions);
                }
            }
            this._portletImporter.importPortletData((PortletDataContext)context, "87", null, layoutEl);
        }
        List portletEls = root.element("portlets").elements("portlet");
        if (deletePortletData) {
            if (_log.isDebugEnabled() && portletEls.size() > 0) {
                _log.debug((Object)"Deleting portlet data");
            }
            for (Element portletRefEl : portletEls) {
                String portletId = portletRefEl.attributeValue("portlet-id");
                long layoutId = GetterUtil.getLong((String)portletRefEl.attributeValue("layout-id"));
                long plid = (Long)newLayoutIdPlidMap.get(layoutId);
                context.setPlid(plid);
                this._portletImporter.deletePortletData((PortletDataContext)context, portletId, plid);
            }
        }
        if (_log.isDebugEnabled() && portletEls.size() > 0) {
            _log.debug((Object)"Importing portlets");
        }
        for (Element portletRefEl : portletEls) {
            String portletPath = portletRefEl.attributeValue("path");
            String portletId = portletRefEl.attributeValue("portlet-id");
            long layoutId = GetterUtil.getLong((String)portletRefEl.attributeValue("layout-id"));
            long plid = (Long)newLayoutIdPlidMap.get(layoutId);
            long oldPlid = GetterUtil.getLong((String)portletRefEl.attributeValue("old-plid"));
            Layout layout = LayoutUtil.findByPrimaryKey((long)plid);
            context.setPlid(plid);
            context.setOldPlid(oldPlid);
            Element portletEl = null;
            try {
                Document portletDoc = SAXReaderUtil.read((String)context.getZipEntryAsString(portletPath));
                portletEl = portletDoc.getRootElement();
            }
            catch (DocumentException de) {
                throw new SystemException((Throwable)de);
            }
            this._portletImporter.importPortletPreferences(context, layoutSet.getCompanyId(), layout.getGroupId(), layout, null, portletEl, importPortletSetup, importPortletArchivedSetups, importPortletUserPreferences, false);
            long scopeLayoutId = GetterUtil.getLong((String)portletEl.attributeValue("scope-layout-id"));
            context.setScopeLayoutId(scopeLayoutId);
            Element portletDataEl = portletEl.element("portlet-data");
            if (importPortletData && portletDataEl != null) {
                this._portletImporter.importPortletData((PortletDataContext)context, portletId, plid, portletDataEl);
            }
            Element permissionsEl = portletEl.element("permissions");
            if (importPermissions && permissionsEl != null) {
                String resourcePrimKey;
                String resourceName;
                if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                    resourceName = PortletConstants.getRootPortletId((String)portletId);
                    resourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
                    this.importPortletPermissions_6(layoutCache, companyId, groupId, userId, resourceName, resourcePrimKey, permissionsEl);
                } else if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
                    resourceName = PortletConstants.getRootPortletId((String)portletId);
                    resourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
                    this.importPortletPermissions_5(layoutCache, companyId, groupId, userId, resourceName, resourcePrimKey, permissionsEl);
                } else {
                    this.importPortletPermissions_4(layoutCache, companyId, groupId, guestGroup, layout, permissionsEl, importUserPermissions);
                }
            }
            this._portletImporter.importPortletPreferences(context, layoutSet.getCompanyId(), groupId, null, null, portletEl, importPortletSetup, importPortletArchivedSetups, importPortletUserPreferences, false);
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM >= 5) continue;
            Element rolesEl = portletEl.element("roles");
            if (!importPermissions || rolesEl == null) continue;
            this.importPortletRoles(layoutCache, companyId, groupId, portletEl);
            this.importPortletRoles(layoutCache, companyId, groupId, portletId, rolesEl);
        }
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM < 5) {
            Element rolesEl = root.element("roles");
            if (importPermissions) {
                this.importLayoutRoles(layoutCache, companyId, groupId, rolesEl);
            }
        }
        if (deleteMissingLayouts) {
            this.deleteMissingLayouts(groupId, privateLayout, newLayoutIds, previousLayouts);
        }
        LayoutSetLocalServiceUtil.updatePageCount((long)groupId, (boolean)privateLayout);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Importing layouts takes " + stopWatch.getTime() + " ms"));
        }
        for (Layout layout : newLayouts) {
            UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
            String articleId = typeSettingsProperties.getProperty("article-id");
            if (!Validator.isNotNull((String)articleId)) continue;
            Map articleIds = context.getNewPrimaryKeysMap(JournalArticle.class);
            typeSettingsProperties.setProperty("article-id", MapUtil.getString((Map)articleIds, (String)articleId, (String)articleId));
            LayoutUtil.update((Layout)layout, (boolean)false);
        }
        zipReader.close();
    }

    protected void deleteMissingLayouts(long groupId, boolean privateLayout, Set<Long> newLayoutIds, List<Layout> previousLayouts) throws PortalException, SystemException {
        if (_log.isDebugEnabled() && newLayoutIds.size() > 0) {
            _log.debug((Object)"Delete missing layouts");
        }
        for (Layout layout : previousLayouts) {
            if (newLayoutIds.contains(layout.getLayoutId())) continue;
            try {
                LayoutLocalServiceUtil.deleteLayout((Layout)layout, (boolean)false);
            }
            catch (NoSuchLayoutException nsle) {}
        }
        LayoutSetLocalServiceUtil.updatePageCount((long)groupId, (boolean)privateLayout);
    }

    protected void fixTypeSettings(Layout layout) {
        if (layout.getType().equals("url")) {
            int y;
            int x;
            UnicodeProperties typeSettings = layout.getTypeSettingsProperties();
            String url = GetterUtil.getString((String)typeSettings.getProperty("url"));
            String friendlyURLPrivateGroupPath = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING;
            String friendlyURLPrivateUserPath = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING;
            String friendlyURLPublicPath = PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING;
            if ((url.startsWith(friendlyURLPrivateGroupPath) || url.startsWith(friendlyURLPrivateUserPath) || url.startsWith(friendlyURLPublicPath)) && (x = url.indexOf("/", 1)) > 0 && (y = url.indexOf("/", x + 1)) > x) {
                String fixedUrl = url.substring(0, x) + layout.getGroup().getFriendlyURL() + url.substring(y);
                typeSettings.setProperty("url", fixedUrl);
            }
        }
    }

    protected List<String> getActions(Element el) {
        ArrayList<String> actions = new ArrayList<String>();
        for (Element actionEl : el.elements("action-key")) {
            actions.add(actionEl.getText());
        }
        return actions;
    }

    protected void importCategories(PortletDataContext context) throws SystemException {
        try {
            String xml = context.getZipEntryAsString(context.getSourceRootPath() + "/categories-hierarchy.xml");
            if (Validator.isNull((String)xml)) {
                return;
            }
            Document doc = SAXReaderUtil.read((String)xml);
            Element root = doc.getRootElement();
            List vocabularies = root.elements("vocabulary");
            for (Element vocabularyEl : vocabularies) {
                String vocabularyName = GetterUtil.getString((String)vocabularyEl.attributeValue("name"));
                String userUuid = GetterUtil.getString((String)vocabularyEl.attributeValue("userUuid"));
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setAddCommunityPermissions(true);
                serviceContext.setAddGuestPermissions(true);
                serviceContext.setScopeGroupId(context.getGroupId());
                try {
                    TagsVocabularyLocalServiceUtil.addVocabulary((long)context.getUserId(userUuid), (String)vocabularyName, (boolean)false, (ServiceContext)serviceContext);
                }
                catch (DuplicateVocabularyException dve) {
                    // empty catch block
                }
                List categories = vocabularyEl.elements("category");
                for (Element category : categories) {
                    String categoryName = GetterUtil.getString((String)category.attributeValue("name"));
                    String parentEntryName = GetterUtil.getString((String)category.attributeValue("parentEntryName"));
                    String[] properties = null;
                    try {
                        TagsEntryLocalServiceUtil.addEntry((long)context.getUserId(userUuid), (String)parentEntryName, (String)categoryName, (String)vocabularyName, properties, (ServiceContext)serviceContext);
                    }
                    catch (DuplicateEntryException dee) {}
                }
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected void importGroupPermissions(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String resourcePrimKey, Element parentEl, String elName, boolean portletActions) throws PortalException, SystemException {
        Element actionEl = parentEl.element(elName);
        if (actionEl == null) {
            return;
        }
        List<String> actions = this.getActions(actionEl);
        Resource resource = layoutCache.getResource(companyId, groupId, resourceName, 4, resourcePrimKey, portletActions);
        PermissionLocalServiceUtil.setGroupPermissions((long)groupId, (String[])actions.toArray(new String[actions.size()]), (long)resource.getResourceId());
    }

    protected void importGroupRoles(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String entityName, Element parentEl) throws PortalException, SystemException {
        Element entityRolesEl = parentEl.element(entityName + "-roles");
        if (entityRolesEl == null) {
            return;
        }
        this.importRolePermissions(layoutCache, companyId, resourceName, 2, String.valueOf(groupId), entityRolesEl, true);
    }

    protected void importInheritedPermissions(LayoutCache layoutCache, long companyId, String resourceName, String resourcePrimKey, Element permissionsEl, String entityName, boolean portletActions) throws PortalException, SystemException {
        Element entityPermissionsEl = permissionsEl.element(entityName + "-permissions");
        if (entityPermissionsEl == null) {
            return;
        }
        List actionsEls = entityPermissionsEl.elements(entityName + "-actions");
        for (int i = 0; i < actionsEls.size(); ++i) {
            Element actionEl = (Element)actionsEls.get(i);
            String name = actionEl.attributeValue("name");
            long entityGroupId = layoutCache.getEntityGroupId(companyId, entityName, name);
            if (entityGroupId == 0L) {
                _log.warn((Object)("Ignore inherited permissions for entity " + entityName + " with name " + name));
                continue;
            }
            Element parentEl = SAXReaderUtil.createElement((String)"parent");
            parentEl.add(actionEl.createCopy());
            this.importGroupPermissions(layoutCache, companyId, entityGroupId, resourceName, resourcePrimKey, parentEl, entityName + "-actions", portletActions);
        }
    }

    protected void importInheritedRoles(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String entityName, Element parentEl) throws PortalException, SystemException {
        Element entityRolesEl = parentEl.element(entityName + "-roles");
        if (entityRolesEl == null) {
            return;
        }
        List entityEls = entityRolesEl.elements(entityName);
        for (int i = 0; i < entityEls.size(); ++i) {
            Element entityEl = (Element)entityEls.get(i);
            String name = entityEl.attributeValue("name");
            long entityGroupId = layoutCache.getEntityGroupId(companyId, entityName, name);
            if (entityGroupId == 0L) {
                _log.warn((Object)("Ignore inherited roles for entity " + entityName + " with name " + name));
                continue;
            }
            this.importRolePermissions(layoutCache, companyId, resourceName, 2, String.valueOf(groupId), entityEl, false);
        }
    }

    protected void importLayoutPermissions_4(LayoutCache layoutCache, long companyId, long groupId, Group guestGroup, Layout layout, String resourceName, String resourcePrimKey, Element permissionsEl, boolean importUserPermissions) throws PortalException, SystemException {
        this.importGroupPermissions(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsEl, "community-actions", false);
        if (groupId != guestGroup.getGroupId()) {
            this.importGroupPermissions(layoutCache, companyId, guestGroup.getGroupId(), resourceName, resourcePrimKey, permissionsEl, "guest-actions", false);
        }
        if (importUserPermissions) {
            this.importUserPermissions(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsEl, false);
        }
        this.importInheritedPermissions(layoutCache, companyId, resourceName, resourcePrimKey, permissionsEl, "organization", false);
        this.importInheritedPermissions(layoutCache, companyId, resourceName, resourcePrimKey, permissionsEl, "user-group", false);
    }

    protected void importLayoutPermissions_5(LayoutCache layoutCache, long companyId, long groupId, long userId, String resourceName, String resourcePrimKey, Element permissionsEl) throws PortalException, SystemException {
        boolean portletActions = false;
        Resource resource = layoutCache.getResource(companyId, groupId, resourceName, 4, resourcePrimKey, portletActions);
        this.importPermissions_5(layoutCache, companyId, userId, resource.getResourceId(), permissionsEl);
    }

    protected void importLayoutPermissions_6(LayoutCache layoutCache, long companyId, long groupId, long userId, String resourceName, String resourcePrimKey, Element permissionsEl) throws PortalException, SystemException {
        boolean portletActions = false;
        this.importPermissions_6(layoutCache, companyId, groupId, userId, resourceName, resourcePrimKey, permissionsEl, portletActions);
    }

    protected void importLayoutRoles(LayoutCache layoutCache, long companyId, long groupId, Element rolesEl) throws PortalException, SystemException {
        String resourceName = Layout.class.getName();
        this.importGroupRoles(layoutCache, companyId, groupId, resourceName, "community", rolesEl);
        this.importUserRoles(layoutCache, companyId, groupId, resourceName, rolesEl);
        this.importInheritedRoles(layoutCache, companyId, groupId, resourceName, "organization", rolesEl);
        this.importInheritedRoles(layoutCache, companyId, groupId, resourceName, "user-group", rolesEl);
    }

    protected void importPermissions_5(LayoutCache layoutCache, long companyId, long userId, long resourceId, Element permissionsEl) throws PortalException, SystemException {
        List roleEls = permissionsEl.elements("role");
        for (Element roleEl : roleEls) {
            String name = roleEl.attributeValue("name");
            Role role = layoutCache.getRole(companyId, name);
            if (role == null) {
                String description = roleEl.attributeValue("description");
                int type = Integer.valueOf(roleEl.attributeValue("type"));
                role = RoleLocalServiceUtil.addRole((long)userId, (long)companyId, (String)name, (String)description, (int)type);
            }
            List<String> actions = this.getActions(roleEl);
            PermissionLocalServiceUtil.setRolePermissions((long)role.getRoleId(), (String[])actions.toArray(new String[actions.size()]), (long)resourceId);
        }
    }

    protected void importPermissions_6(LayoutCache layoutCache, long companyId, long groupId, long userId, String resourceName, String resourcePrimKey, Element permissionsEl, boolean portletActions) throws PortalException, SystemException {
        List roleEls = permissionsEl.elements("role");
        for (Element roleEl : roleEls) {
            String name = roleEl.attributeValue("name");
            Role role = layoutCache.getRole(companyId, name);
            if (role == null) {
                String description = roleEl.attributeValue("description");
                int type = Integer.valueOf(roleEl.attributeValue("type"));
                role = RoleLocalServiceUtil.addRole((long)userId, (long)companyId, (String)name, (String)description, (int)type);
            }
            List<String> actions = this.getActions(roleEl);
            ResourcePermissionLocalServiceUtil.setResourcePermissions((long)companyId, (String)resourceName, (int)4, (String)resourcePrimKey, (long)role.getRoleId(), (String[])actions.toArray(new String[actions.size()]));
        }
    }

    protected void importPortletPermissions_4(LayoutCache layoutCache, long companyId, long groupId, Group guestGroup, Layout layout, Element permissionsEl, boolean importUserPermissions) throws PortalException, SystemException {
        for (Element portletEl : permissionsEl.elements("portlet")) {
            String portletId = portletEl.attributeValue("portlet-id");
            String resourceName = PortletConstants.getRootPortletId((String)portletId);
            String resourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)resourceName);
            if (portlet == null) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Do not import portlet permissions for " + portletId + " because the portlet does not exist"));
                continue;
            }
            this.importGroupPermissions(layoutCache, companyId, groupId, resourceName, resourcePrimKey, portletEl, "community-actions", true);
            if (groupId != guestGroup.getGroupId()) {
                this.importGroupPermissions(layoutCache, companyId, guestGroup.getGroupId(), resourceName, resourcePrimKey, portletEl, "guest-actions", true);
            }
            if (importUserPermissions) {
                this.importUserPermissions(layoutCache, companyId, groupId, resourceName, resourcePrimKey, portletEl, true);
            }
            this.importInheritedPermissions(layoutCache, companyId, resourceName, resourcePrimKey, portletEl, "organization", true);
            this.importInheritedPermissions(layoutCache, companyId, resourceName, resourcePrimKey, portletEl, "user-group", true);
        }
    }

    protected void importPortletPermissions_5(LayoutCache layoutCache, long companyId, long groupId, long userId, String resourceName, String resourcePrimKey, Element permissionsEl) throws PortalException, SystemException {
        boolean portletActions = true;
        Resource resource = layoutCache.getResource(companyId, groupId, resourceName, 4, resourcePrimKey, portletActions);
        this.importPermissions_5(layoutCache, companyId, userId, resource.getResourceId(), permissionsEl);
    }

    protected void importPortletPermissions_6(LayoutCache layoutCache, long companyId, long groupId, long userId, String resourceName, String resourcePrimKey, Element permissionsEl) throws PortalException, SystemException {
        boolean portletActions = true;
        this.importPermissions_6(layoutCache, companyId, groupId, userId, resourceName, resourcePrimKey, permissionsEl, portletActions);
    }

    protected void importPortletRoles(LayoutCache layoutCache, long companyId, long groupId, String portletId, Element rolesEl) throws PortalException, SystemException {
        String resourceName = PortletConstants.getRootPortletId((String)portletId);
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)resourceName);
        if (portlet == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not import portlet roles for " + portletId + " because the portlet does not exist"));
            }
        } else {
            this.importGroupRoles(layoutCache, companyId, groupId, resourceName, "community", rolesEl);
            this.importUserRoles(layoutCache, companyId, groupId, resourceName, rolesEl);
            this.importInheritedRoles(layoutCache, companyId, groupId, resourceName, "organization", rolesEl);
            this.importInheritedRoles(layoutCache, companyId, groupId, resourceName, "user-group", rolesEl);
        }
    }

    protected void importPortletRoles(LayoutCache layoutCache, long companyId, long groupId, Element rolesEl) throws PortalException, SystemException {
        for (Element portletEl : rolesEl.elements("portlet")) {
            String portletId = portletEl.attributeValue("portlet-id");
            String resourceName = PortletConstants.getRootPortletId((String)portletId);
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)resourceName);
            if (portlet == null) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Do not import portlet roles for " + portletId + " because the portlet does not exist"));
                continue;
            }
            this.importGroupRoles(layoutCache, companyId, groupId, resourceName, "community", portletEl);
            this.importUserRoles(layoutCache, companyId, groupId, resourceName, portletEl);
            this.importInheritedRoles(layoutCache, companyId, groupId, resourceName, "organization", portletEl);
            this.importInheritedRoles(layoutCache, companyId, groupId, resourceName, "user-group", portletEl);
        }
    }

    protected void importRolePermissions(LayoutCache layoutCache, long companyId, String resourceName, int scope, String resourcePrimKey, Element parentEl, boolean communityRole) throws PortalException, SystemException {
        List roleEls = parentEl.elements("role");
        for (int i = 0; i < roleEls.size(); ++i) {
            Element roleEl = (Element)roleEls.get(i);
            String roleName = roleEl.attributeValue("name");
            Role role = layoutCache.getRole(companyId, roleName);
            if (role == null) {
                _log.warn((Object)("Ignoring permissions for role with name " + roleName));
                continue;
            }
            List<String> actions = this.getActions(roleEl);
            PermissionLocalServiceUtil.setRolePermissions((long)role.getRoleId(), (long)companyId, (String)resourceName, (int)scope, (String)resourcePrimKey, (String[])actions.toArray(new String[actions.size()]));
            if (!communityRole) continue;
            long[] groupIds = new long[]{GetterUtil.getLong((String)resourcePrimKey)};
            GroupLocalServiceUtil.addRoleGroups((long)role.getRoleId(), (long[])groupIds);
        }
    }

    protected String importTheme(LayoutSet layoutSet, InputStream themeZip) throws IOException {
        ThemeLoader themeLoader = ThemeLoaderFactory.getDefaultThemeLoader();
        if (themeLoader == null) {
            _log.error((Object)"No theme loaders are deployed");
            return null;
        }
        ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((InputStream)themeZip);
        String lookAndFeelXML = zipReader.getEntryAsString("liferay-look-and-feel.xml");
        String themeId = String.valueOf(layoutSet.getGroupId());
        themeId = layoutSet.isPrivateLayout() ? themeId + "-private" : themeId + "-public";
        if (PropsValues.THEME_LOADER_NEW_THEME_ID_ON_IMPORT) {
            Date now = new Date();
            themeId = themeId + "-" + Time.getShortTimestamp((Date)now);
        }
        String themeName = themeId;
        lookAndFeelXML = StringUtil.replace((String)lookAndFeelXML, (String[])new String[]{"[$GROUP_ID$]", "[$THEME_ID$]", "[$THEME_NAME$]"}, (String[])new String[]{String.valueOf(layoutSet.getGroupId()), themeId, themeName});
        FileUtil.deltree((String)(themeLoader.getFileStorage() + "/" + themeId));
        List zipEntries = zipReader.getEntries();
        for (String zipEntry : zipEntries) {
            String key = zipEntry;
            if (key.contains("/")) {
                key = key.substring(key.lastIndexOf("/"));
            }
            if (key.equals("liferay-look-and-feel.xml")) {
                FileUtil.write((String)(themeLoader.getFileStorage() + "/" + themeId + "/" + key), (byte[])lookAndFeelXML.getBytes());
                continue;
            }
            InputStream is = zipReader.getEntryAsInputStream(zipEntry);
            FileUtil.write((String)(themeLoader.getFileStorage() + "/" + themeId + "/" + key), (InputStream)is);
        }
        themeLoader.loadThemes();
        MethodWrapper methodWrapper = new MethodWrapper(ThemeLoaderFactory.class.getName(), "loadThemes");
        Message message = new Message();
        message.setPayload((Object)methodWrapper);
        ClusterLinkUtil.sendMulticastMessage((Message)message, (Priority)Priority.LEVEL5);
        themeId = themeId + "_WAR_" + themeLoader.getServletContextName();
        return PortalUtil.getJsSafePortletId((String)themeId);
    }

    protected void importUserPermissions(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String resourcePrimKey, Element parentEl, boolean portletActions) throws PortalException, SystemException {
        Element userPermissionsEl = parentEl.element("user-permissions");
        if (userPermissionsEl == null) {
            return;
        }
        List userActionsEls = userPermissionsEl.elements("user-actions");
        for (int i = 0; i < userActionsEls.size(); ++i) {
            Element userActionsEl = (Element)userActionsEls.get(i);
            String uuid = userActionsEl.attributeValue("uuid");
            User user = layoutCache.getUser(companyId, groupId, uuid);
            if (user == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Ignoring permissions for user with uuid " + uuid));
                continue;
            }
            List<String> actions = this.getActions(userActionsEl);
            Resource resource = layoutCache.getResource(companyId, groupId, resourceName, 4, resourcePrimKey, portletActions);
            PermissionLocalServiceUtil.setUserPermissions((long)user.getUserId(), (String[])actions.toArray(new String[actions.size()]), (long)resource.getResourceId());
        }
    }

    protected void importUserRoles(LayoutCache layoutCache, long companyId, long groupId, String resourceName, Element parentEl) throws PortalException, SystemException {
        Element userRolesEl = parentEl.element("user-roles");
        if (userRolesEl == null) {
            return;
        }
        List userEls = userRolesEl.elements("user");
        for (int i = 0; i < userEls.size(); ++i) {
            Element userEl = (Element)userEls.get(i);
            String uuid = userEl.attributeValue("uuid");
            User user = layoutCache.getUser(companyId, groupId, uuid);
            if (user == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Ignoring roles for user with uuid " + uuid));
                continue;
            }
            this.importRolePermissions(layoutCache, companyId, resourceName, 2, String.valueOf(groupId), userEl, false);
        }
    }

    protected void mergePortlets(Layout layout, String newTypeSettings, String portletsMergeMode) {
        try {
            UnicodeProperties previousProps = layout.getTypeSettingsProperties();
            LayoutTypePortlet previousLayoutType = (LayoutTypePortlet)layout.getLayoutType();
            List previousColumns = previousLayoutType.getLayoutTemplate().getColumns();
            UnicodeProperties newProps = new UnicodeProperties(true);
            newProps.load(newTypeSettings);
            String layoutTemplateId = newProps.getProperty("layout-template-id");
            LayoutTemplate newLayoutTemplate = LayoutTemplateLocalServiceUtil.getLayoutTemplate((String)layoutTemplateId, (boolean)false, null);
            String[] lostPortletIds = new String[]{};
            for (String columnId : newLayoutTemplate.getColumns()) {
                String columnValue = newProps.getProperty(columnId);
                Object[] portletIds = StringUtil.split((String)columnValue);
                if (!previousColumns.contains(columnId)) {
                    lostPortletIds = ArrayUtil.append((String[])lostPortletIds, (String[])portletIds);
                    continue;
                }
                String[] previousPortletIds = StringUtil.split((String)previousProps.getProperty(columnId));
                portletIds = this.appendPortletIds(previousPortletIds, (String[])portletIds, portletsMergeMode);
                previousProps.setProperty(columnId, StringUtil.merge((Object[])portletIds));
            }
            String columnId = (String)previousColumns.get(0);
            Object[] portletIds = StringUtil.split((String)previousProps.getProperty(columnId));
            this.appendPortletIds((String[])portletIds, lostPortletIds, portletsMergeMode);
            previousProps.setProperty(columnId, StringUtil.merge((Object[])portletIds));
            layout.setTypeSettings(previousProps.toString());
        }
        catch (IOException e) {
            layout.setTypeSettings(newTypeSettings);
        }
    }

    protected String[] appendPortletIds(String[] portletIds, String[] newPortletIds, String portletsMergeMode) {
        for (String portletId : newPortletIds) {
            if (ArrayUtil.contains((Object[])portletIds, (Object)portletId)) continue;
            portletIds = portletsMergeMode.equals("ADD_TO_BOTTOM") ? ArrayUtil.append((String[])portletIds, (String)portletId) : ArrayUtil.append((String[])new String[]{portletId}, (String[])portletIds);
        }
        return portletIds;
    }
}

