/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.lar.PortletDataContext;
import com.liferay.portal.lar.PortletDataException;
import com.liferay.portal.lar.PortletDataHandlerControl;
import com.liferay.portal.lar.UserIdStrategy;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.blogs.model.impl.BlogsEntryImpl;
import com.liferay.portlet.bookmarks.model.impl.BookmarksEntryImpl;
import com.liferay.portlet.bookmarks.model.impl.BookmarksFolderImpl;
import com.liferay.portlet.calendar.model.impl.CalEventImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFileRankImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFileShortcutImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;
import com.liferay.portlet.imagegallery.model.impl.IGFolderImpl;
import com.liferay.portlet.imagegallery.model.impl.IGImageImpl;
import com.liferay.portlet.journal.model.impl.JournalArticleImpl;
import com.liferay.portlet.journal.model.impl.JournalFeedImpl;
import com.liferay.portlet.journal.model.impl.JournalStructureImpl;
import com.liferay.portlet.journal.model.impl.JournalTemplateImpl;
import com.liferay.portlet.messageboards.NoSuchDiscussionException;
import com.liferay.portlet.messageboards.model.MBDiscussion;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.model.impl.MBBanImpl;
import com.liferay.portlet.messageboards.model.impl.MBCategoryImpl;
import com.liferay.portlet.messageboards.model.impl.MBMessageFlagImpl;
import com.liferay.portlet.messageboards.model.impl.MBMessageImpl;
import com.liferay.portlet.messageboards.service.MBDiscussionLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import com.liferay.portlet.polls.model.impl.PollsChoiceImpl;
import com.liferay.portlet.polls.model.impl.PollsQuestionImpl;
import com.liferay.portlet.polls.model.impl.PollsVoteImpl;
import com.liferay.portlet.ratings.model.RatingsEntry;
import com.liferay.portlet.ratings.model.impl.RatingsEntryImpl;
import com.liferay.portlet.ratings.service.RatingsEntryLocalServiceUtil;
import com.liferay.portlet.tags.service.TagsEntryLocalServiceUtil;
import com.liferay.portlet.wiki.model.impl.WikiNodeImpl;
import com.liferay.portlet.wiki.model.impl.WikiPageImpl;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletDataContextImpl
implements PortletDataContext {
    private Map<String, List<MBMessage>> _commentsMap = new HashMap<String, List<MBMessage>>();
    private long _companyId;
    private String _dataStrategy;
    private Date _endDate;
    private long _groupId;
    private Map<String, Map<?, ?>> _newPrimaryKeysMaps = new HashMap();
    private Set<String> _notUniquePerLayout = new HashSet<String>();
    private long _oldPlid;
    private Map<String, String[]> _parameterMap;
    private long _plid;
    private Set<String> _primaryKeys;
    private boolean _privateLayout;
    private Map<String, List<RatingsEntry>> _ratingsEntriesMap = new HashMap<String, List<RatingsEntry>>();
    private long _scopeGroupId;
    private long _scopeLayoutId;
    private long _sourceGroupId;
    private Date _startDate;
    private Map<String, String[]> _tagsCategoriesMap = new HashMap<String, String[]>();
    private Map<String, String[]> _tagsEntriesMap = new HashMap<String, String[]>();
    private UserIdStrategy _userIdStrategy;
    private XStream _xStream;
    private ZipReader _zipReader;
    private ZipWriter _zipWriter;

    public PortletDataContextImpl(long companyId, long groupId, Map<String, String[]> parameterMap, Set<String> primaryKeys, Date startDate, Date endDate, ZipWriter zipWriter) throws PortletDataException {
        this.validateDateRange(startDate, endDate);
        this._companyId = companyId;
        this._groupId = groupId;
        this._scopeGroupId = groupId;
        this._parameterMap = parameterMap;
        this._primaryKeys = primaryKeys;
        this._dataStrategy = null;
        this._userIdStrategy = null;
        this._startDate = startDate;
        this._endDate = endDate;
        this._zipReader = null;
        this._zipWriter = zipWriter;
        this.initXStream();
    }

    public PortletDataContextImpl(long companyId, long groupId, Map<String, String[]> parameterMap, Set<String> primaryKeys, UserIdStrategy userIdStrategy, ZipReader zipReader) {
        this._companyId = companyId;
        this._groupId = groupId;
        this._scopeGroupId = groupId;
        this._parameterMap = parameterMap;
        this._primaryKeys = primaryKeys;
        this._dataStrategy = MapUtil.getString(parameterMap, (String)"DATA_STRATEGY", (String)"DATA_STRATEGY_MIRROR");
        this._userIdStrategy = userIdStrategy;
        this._zipReader = zipReader;
        this._zipWriter = null;
        this.initXStream();
    }

    public void addComments(Class<?> classObj, long classPK) throws SystemException {
        List messages = MBMessageLocalServiceUtil.getMessages((String)classObj.getName(), (long)classPK);
        if (messages.size() == 0) {
            return;
        }
        for (MBMessage message : messages) {
            message.setUserUuid(message.getUserUuid());
            this.addRatingsEntries(MBMessage.class, message.getPrimaryKey());
        }
        this._commentsMap.put(this.getPrimaryKeyString(classObj, classPK), messages);
    }

    public void addComments(String className, long classPK, List<MBMessage> messages) {
        this._commentsMap.put(this.getPrimaryKeyString(className, classPK), messages);
    }

    public boolean addPrimaryKey(Class<?> classObj, String primaryKey) {
        boolean value = this.hasPrimaryKey(classObj, primaryKey);
        if (!value) {
            this._primaryKeys.add(this.getPrimaryKeyString(classObj, primaryKey));
        }
        return value;
    }

    public void addRatingsEntries(Class<?> classObj, long classPK) throws SystemException {
        List ratingsEntries = RatingsEntryLocalServiceUtil.getEntries((String)classObj.getName(), (long)classPK);
        if (ratingsEntries.size() == 0) {
            return;
        }
        for (RatingsEntry entry : ratingsEntries) {
            entry.setUserUuid(entry.getUserUuid());
        }
        this._ratingsEntriesMap.put(this.getPrimaryKeyString(classObj, classPK), ratingsEntries);
    }

    public void addRatingsEntries(String className, long classPK, List<RatingsEntry> ratingsEntries) {
        this._ratingsEntriesMap.put(this.getPrimaryKeyString(className, classPK), ratingsEntries);
    }

    public void addTagsCategories(Class<?> classObj, long classPK) throws SystemException {
        String[] tagsCategories = TagsEntryLocalServiceUtil.getEntryNames((String)classObj.getName(), (long)classPK, (boolean)false);
        if (tagsCategories.length == 0) {
            return;
        }
        this._tagsCategoriesMap.put(this.getPrimaryKeyString(classObj, classPK), tagsCategories);
    }

    public void addTagsCategories(String className, long classPK, String[] tagsCategories) {
        this._tagsCategoriesMap.put(this.getPrimaryKeyString(className, classPK), tagsCategories);
    }

    public void addTagsEntries(Class<?> classObj, long classPK) throws SystemException {
        String[] tagsEntries = TagsEntryLocalServiceUtil.getEntryNames((String)classObj.getName(), (long)classPK, (boolean)true);
        if (tagsEntries.length == 0) {
            return;
        }
        this._tagsEntriesMap.put(this.getPrimaryKeyString(classObj, classPK), tagsEntries);
    }

    public void addTagsEntries(String className, long classPK, String[] tagsEntries) {
        this._tagsEntriesMap.put(this.getPrimaryKeyString(className, classPK), tagsEntries);
    }

    public void addZipEntry(String path, byte[] bytes) throws SystemException {
        try {
            this.getZipWriter().addEntry(path, bytes);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public void addZipEntry(String path, InputStream is) throws SystemException {
        try {
            this.getZipWriter().addEntry(path, is);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public void addZipEntry(String path, Object object) throws SystemException {
        this.addZipEntry(path, this.toXML(object));
    }

    public void addZipEntry(String path, String s) throws SystemException {
        try {
            this.getZipWriter().addEntry(path, s);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public void addZipEntry(String path, StringBuilder sb) throws SystemException {
        try {
            this.getZipWriter().addEntry(path, sb);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public Object fromXML(byte[] bytes) {
        return this._xStream.fromXML(new String(bytes));
    }

    public Object fromXML(String xml) {
        return this._xStream.fromXML(xml);
    }

    public boolean getBooleanParameter(String namespace, String name) {
        boolean defaultValue = MapUtil.getBoolean(this.getParameterMap(), (String)"PORTLET_DATA_CONTROL_DEFAULT", (boolean)true);
        return MapUtil.getBoolean(this.getParameterMap(), (String)PortletDataHandlerControl.getNamespacedControlName((String)namespace, (String)name), (boolean)defaultValue);
    }

    public ClassLoader getClassLoader() {
        return this._xStream.getClassLoader();
    }

    public Map<String, List<MBMessage>> getComments() {
        return this._commentsMap;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public String getDataStrategy() {
        return this._dataStrategy;
    }

    public Date getEndDate() {
        return this._endDate;
    }

    public long getGroupId() {
        return this._groupId;
    }

    public String getLayoutPath(long layoutId) {
        return this.getRootPath() + "/layouts/" + layoutId;
    }

    public Map<?, ?> getNewPrimaryKeysMap(Class<?> classObj) {
        Map<?, ?> map = this._newPrimaryKeysMaps.get(classObj.getName());
        if (map == null) {
            map = new HashMap();
            this._newPrimaryKeysMaps.put(classObj.getName(), map);
        }
        return map;
    }

    public long getOldPlid() {
        return this._oldPlid;
    }

    public Map<String, String[]> getParameterMap() {
        return this._parameterMap;
    }

    public long getPlid() {
        return this._plid;
    }

    public String getPortletPath(String portletId) {
        return this.getRootPath() + "/portlets/" + portletId;
    }

    public Set<String> getPrimaryKeys() {
        return this._primaryKeys;
    }

    public Map<String, List<RatingsEntry>> getRatingsEntries() {
        return this._ratingsEntriesMap;
    }

    public String getRootPath() {
        return "/groups/" + this.getScopeGroupId();
    }

    public long getScopeGroupId() {
        return this._scopeGroupId;
    }

    public long getScopeLayoutId() {
        return this._scopeLayoutId;
    }

    public long getSourceGroupId() {
        return this._sourceGroupId;
    }

    public String getSourceLayoutPath(long layoutId) {
        return this.getSourceRootPath() + "/layouts/" + layoutId;
    }

    public String getSourcePortletPath(String portletId) {
        return this.getSourceRootPath() + "/portlets/" + portletId;
    }

    public String getSourceRootPath() {
        return "/groups/" + this.getSourceGroupId();
    }

    public Date getStartDate() {
        return this._startDate;
    }

    public Map<String, String[]> getTagsCategories() {
        return this._tagsCategoriesMap;
    }

    public String[] getTagsCategories(Class<?> classObj, long classPK) {
        return this._tagsCategoriesMap.get(this.getPrimaryKeyString(classObj, classPK));
    }

    public Map<String, String[]> getTagsEntries() {
        return this._tagsEntriesMap;
    }

    public String[] getTagsEntries(Class<?> classObj, long classPK) {
        return this._tagsEntriesMap.get(this.getPrimaryKeyString(classObj, classPK));
    }

    public String[] getTagsEntries(String className, long classPK) {
        return this._tagsEntriesMap.get(this.getPrimaryKeyString(className, classPK));
    }

    public long getUserId(String userUuid) throws SystemException {
        return this._userIdStrategy.getUserId(userUuid);
    }

    public UserIdStrategy getUserIdStrategy() {
        return this._userIdStrategy;
    }

    public List<String> getZipEntries() {
        return this.getZipReader().getEntries();
    }

    public byte[] getZipEntryAsByteArray(String path) {
        return this.getZipReader().getEntryAsByteArray(path);
    }

    public InputStream getZipEntryAsInputStream(String path) {
        return this.getZipReader().getEntryAsInputStream(path);
    }

    public Object getZipEntryAsObject(String path) {
        return this.fromXML(this.getZipEntryAsString(path));
    }

    public String getZipEntryAsString(String path) {
        return this.getZipReader().getEntryAsString(path);
    }

    public List<String> getZipFolderEntries() {
        return this.getZipFolderEntries("/");
    }

    public List<String> getZipFolderEntries(String path) {
        return this.getZipReader().getFolderEntries(path);
    }

    public ZipReader getZipReader() {
        return this._zipReader;
    }

    public ZipWriter getZipWriter() {
        return this._zipWriter;
    }

    public boolean hasDateRange() {
        return this._startDate != null;
    }

    public boolean hasNotUniquePerLayout(String dataKey) {
        return this._notUniquePerLayout.contains(dataKey);
    }

    public boolean hasPrimaryKey(Class<?> classObj, String primaryKey) {
        return this._primaryKeys.contains(this.getPrimaryKeyString(classObj, primaryKey));
    }

    public void importComments(Class<?> classObj, long classPK, long newClassPK, long groupId) throws PortalException, SystemException {
        HashMap<Long, Long> messagePKs = new HashMap<Long, Long>();
        HashMap<Long, Long> threadPKs = new HashMap<Long, Long>();
        List<MBMessage> messages = this._commentsMap.get(this.getPrimaryKeyString(classObj, classPK));
        if (messages == null) {
            return;
        }
        MBDiscussion discussion = null;
        try {
            discussion = MBDiscussionLocalServiceUtil.getDiscussion((String)classObj.getName(), (long)newClassPK);
        }
        catch (NoSuchDiscussionException nsde) {
            // empty catch block
        }
        for (MBMessage message : messages) {
            long userId = this.getUserId(message.getUserUuid());
            long parentMessageId = MapUtil.getLong(messagePKs, (long)message.getParentMessageId(), (long)message.getParentMessageId());
            long threadId = MapUtil.getLong(threadPKs, (long)message.getThreadId(), (long)message.getThreadId());
            if (message.getParentMessageId() == 0L && discussion != null) {
                MBThread thread = MBThreadLocalServiceUtil.getThread((long)discussion.getThreadId());
                long rootMessageId = thread.getRootMessageId();
                messagePKs.put(message.getMessageId(), rootMessageId);
                threadPKs.put(message.getThreadId(), thread.getThreadId());
            } else {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setScopeGroupId(groupId);
                MBMessage newMessage = MBMessageLocalServiceUtil.addDiscussionMessage((long)userId, (String)message.getUserName(), (String)classObj.getName(), (long)newClassPK, (long)threadId, (long)parentMessageId, (String)message.getSubject(), (String)message.getBody(), (ServiceContext)serviceContext);
                messagePKs.put(message.getMessageId(), newMessage.getMessageId());
                threadPKs.put(message.getThreadId(), newMessage.getThreadId());
            }
            this.importRatingsEntries(MBMessage.class, message.getPrimaryKey(), (Long)messagePKs.get(message.getPrimaryKey()));
        }
    }

    public void importRatingsEntries(Class<?> classObj, long classPK, long newClassPK) throws PortalException, SystemException {
        List<RatingsEntry> ratingsEntries = this._ratingsEntriesMap.get(this.getPrimaryKeyString(classObj, classPK));
        if (ratingsEntries == null) {
            return;
        }
        for (RatingsEntry ratingsEntry : ratingsEntries) {
            long userId = this.getUserId(ratingsEntry.getUserUuid());
            RatingsEntryLocalServiceUtil.updateEntry((long)userId, (String)classObj.getName(), (long)newClassPK, (double)ratingsEntry.getScore());
        }
    }

    public boolean isPathNotProcessed(String path) {
        return !this.addPrimaryKey(String.class, path);
    }

    public boolean isPrivateLayout() {
        return this._privateLayout;
    }

    public boolean isWithinDateRange(Date modifiedDate) {
        if (!this.hasDateRange()) {
            return true;
        }
        return this._startDate.compareTo(modifiedDate) <= 0 && this._endDate.after(modifiedDate);
    }

    public void putNotUniquePerLayout(String dataKey) {
        this._notUniquePerLayout.add(dataKey);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._xStream.setClassLoader(classLoader);
    }

    public void setGroupId(long groupId) {
        this._groupId = groupId;
    }

    public void setOldPlid(long oldPlid) {
        this._oldPlid = oldPlid;
    }

    public void setPlid(long plid) {
        this._plid = plid;
    }

    public void setPrivateLayout(boolean privateLayout) {
        this._privateLayout = privateLayout;
    }

    public void setScopeGroupId(long scopeGroupId) {
        this._scopeGroupId = scopeGroupId;
    }

    public void setScopeLayoutId(long scopeLayoutId) {
        this._scopeLayoutId = scopeLayoutId;
    }

    public void setSourceGroupId(long sourceGroupId) {
        this._sourceGroupId = sourceGroupId;
    }

    public String toXML(Object object) {
        return this._xStream.toXML(object);
    }

    protected String getPrimaryKeyString(Class<?> classObj, long classPK) {
        return this.getPrimaryKeyString(classObj.getName(), String.valueOf(classPK));
    }

    protected String getPrimaryKeyString(Class<?> classObj, String primaryKey) {
        return this.getPrimaryKeyString(classObj.getName(), primaryKey);
    }

    protected String getPrimaryKeyString(String className, long classPK) {
        return this.getPrimaryKeyString(className, String.valueOf(classPK));
    }

    protected String getPrimaryKeyString(String className, String primaryKey) {
        StringBuilder sb = new StringBuilder();
        sb.append(className);
        sb.append("#");
        sb.append(primaryKey);
        return sb.toString();
    }

    protected void initXStream() {
        this._xStream = new XStream();
        this._xStream.alias("BlogsEntry", BlogsEntryImpl.class);
        this._xStream.alias("BookmarksFolder", BookmarksFolderImpl.class);
        this._xStream.alias("BookmarksEntry", BookmarksEntryImpl.class);
        this._xStream.alias("CalEvent", CalEventImpl.class);
        this._xStream.alias("DLFolder", DLFolderImpl.class);
        this._xStream.alias("DLFileEntry", DLFileEntryImpl.class);
        this._xStream.alias("DLFileShortcut", DLFileShortcutImpl.class);
        this._xStream.alias("DLFileRank", DLFileRankImpl.class);
        this._xStream.alias("IGFolder", IGFolderImpl.class);
        this._xStream.alias("IGImage", IGImageImpl.class);
        this._xStream.alias("JournalArticle", JournalArticleImpl.class);
        this._xStream.alias("JournalFeed", JournalFeedImpl.class);
        this._xStream.alias("JournalStructure", JournalStructureImpl.class);
        this._xStream.alias("JournalTemplate", JournalTemplateImpl.class);
        this._xStream.alias("MBCategory", MBCategoryImpl.class);
        this._xStream.alias("MBMessage", MBMessageImpl.class);
        this._xStream.alias("MBMessageFlag", MBMessageFlagImpl.class);
        this._xStream.alias("MBBan", MBBanImpl.class);
        this._xStream.alias("PollsQuestion", PollsQuestionImpl.class);
        this._xStream.alias("PollsChoice", PollsChoiceImpl.class);
        this._xStream.alias("PollsVote", PollsVoteImpl.class);
        this._xStream.alias("RatingsEntry", RatingsEntryImpl.class);
        this._xStream.alias("WikiNode", WikiNodeImpl.class);
        this._xStream.alias("WikiPage", WikiPageImpl.class);
    }

    protected void validateDateRange(Date startDate, Date endDate) throws PortletDataException {
        if (startDate == null ^ endDate == null) {
            throw new PortletDataException("Both start and end dates must have valid values or be null");
        }
        if (startDate != null) {
            if (startDate.after(endDate) || startDate.equals(endDate)) {
                throw new PortletDataException("The start date cannot be after the end date");
            }
            Date now = new Date();
            if (startDate.after(now) || endDate.after(now)) {
                throw new PortletDataException("Dates must not be in the future");
            }
        }
    }
}

