/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.LayoutImportException;
import com.liferay.portal.NoSuchPortletPreferencesException;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactoryUtil;
import com.liferay.portal.lar.LayoutCache;
import com.liferay.portal.lar.PortletDataContext;
import com.liferay.portal.lar.PortletDataContextImpl;
import com.liferay.portal.lar.PortletDataHandler;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.PortletItem;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PermissionLocalServiceUtil;
import com.liferay.portal.service.PortletItemLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.ratings.model.RatingsEntry;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.time.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletExporter {
    private static Log _log = LogFactoryUtil.getLog(PortletExporter.class);

    public byte[] exportPortletInfo(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        File file = this.exportPortletInfoAsFile(plid, groupId, portletId, parameterMap, startDate, endDate);
        try {
            byte[] byArray = FileUtil.getBytes((File)file);
            return byArray;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        finally {
            file.delete();
        }
    }

    public File exportPortletInfoAsFile(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        Group scopeGroup;
        boolean exportPermissions = MapUtil.getBoolean(parameterMap, (String)"PERMISSIONS");
        boolean exportPortletArchivedSetups = MapUtil.getBoolean(parameterMap, (String)"PORTLET_ARCHIVED_SETUPS");
        boolean exportPortletData = MapUtil.getBoolean(parameterMap, (String)("PORTLET_DATA_" + PortletConstants.getRootPortletId((String)portletId)));
        boolean exportPortletDataAll = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA_ALL");
        boolean exportPortletSetup = MapUtil.getBoolean(parameterMap, (String)"PORTLET_SETUP");
        boolean exportPortletUserPreferences = MapUtil.getBoolean(parameterMap, (String)"PORTLET_USER_PREFERENCES");
        boolean exportUserPermissions = MapUtil.getBoolean(parameterMap, (String)"USER_PERMISSIONS");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export permissions " + exportPermissions));
            _log.debug((Object)("Export portlet archived setups " + exportPortletArchivedSetups));
            _log.debug((Object)("Export portlet data " + exportPortletData));
            _log.debug((Object)("Export all portlet data " + exportPortletDataAll));
            _log.debug((Object)("Export portlet setup " + exportPortletSetup));
            _log.debug((Object)("Export portlet user preferences " + exportPortletUserPreferences));
            _log.debug((Object)("Export user permissions " + exportUserPermissions));
        }
        if (exportPortletDataAll) {
            exportPortletData = true;
        }
        StopWatch stopWatch = null;
        if (_log.isInfoEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        LayoutCache layoutCache = new LayoutCache();
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        String type = layout.getType();
        if (!(type.equals("control_panel") || type.equals("panel") || type.equals("portlet"))) {
            throw new LayoutImportException("Layout type " + type + " is not valid");
        }
        long companyId = layout.getCompanyId();
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
        ZipWriter zipWriter = ZipWriterFactoryUtil.getZipWriter();
        long scopeGroupId = groupId;
        PortletPreferences jxPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
        long scopeLayoutId = GetterUtil.getLong((String)jxPreferences.getValue("lfr-scope-layout-id", null));
        if (scopeLayoutId != 0L && (scopeGroup = layout.getScopeGroup()) != null) {
            scopeGroupId = scopeGroup.getGroupId();
        }
        PortletDataContextImpl context = new PortletDataContextImpl(companyId, scopeGroupId, parameterMap, new HashSet<String>(), startDate, endDate, zipWriter);
        context.setPlid(plid);
        context.setOldPlid(plid);
        context.setScopeLayoutId(scopeLayoutId);
        Document doc = SAXReaderUtil.createDocument();
        Element root = doc.addElement("root");
        Element header = root.addElement("header");
        header.addAttribute("build-number", String.valueOf(ReleaseInfo.getBuildNumber()));
        header.addAttribute("export-date", Time.getRFC822());
        if (context.hasDateRange()) {
            header.addAttribute("start-date", String.valueOf(context.getStartDate()));
            header.addAttribute("end-date", String.valueOf(context.getEndDate()));
        }
        header.addAttribute("type", "portlet");
        header.addAttribute("group-id", String.valueOf(scopeGroupId));
        header.addAttribute("private-layout", String.valueOf(layout.isPrivateLayout()));
        header.addAttribute("root-portlet-id", PortletConstants.getRootPortletId((String)portletId));
        this.exportPortlet(context, layoutCache, portletId, layout, root, defaultUserId, exportPermissions, exportPortletArchivedSetups, exportPortletData, exportPortletSetup, exportPortletUserPreferences, exportUserPermissions);
        this.exportCategories(context, root);
        this.exportComments(context, root);
        this.exportRatings(context, root);
        this.exportTags(context, root);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Exporting portlet took " + stopWatch.getTime() + " ms"));
        }
        try {
            context.addZipEntry("/manifest.xml", doc.formattedString());
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        return zipWriter.getFile();
    }

    protected void exportCategories(PortletDataContext context, Element parentEl) throws SystemException {
        try {
            Document doc = SAXReaderUtil.createDocument();
            Element root = doc.addElement("categories");
            Set categoriesEntries = context.getTagsCategories().entrySet();
            for (Map.Entry entry : categoriesEntries) {
                String[] categoryEntry = ((String)entry.getKey()).split("#");
                Element asset = root.addElement("asset");
                asset.addAttribute("class-name", categoryEntry[0]);
                asset.addAttribute("class-pk", categoryEntry[1]);
                asset.addAttribute("entries", StringUtil.merge((Object[])((Object[])entry.getValue())));
            }
            context.addZipEntry(context.getRootPath() + "/categories.xml", doc.formattedString());
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected void exportComments(PortletDataContext context, Element parentEl) throws SystemException {
        try {
            Document doc = SAXReaderUtil.createDocument();
            Element root = doc.addElement("comments");
            Map commentsMap = context.getComments();
            for (Map.Entry entry : commentsMap.entrySet()) {
                String[] comment = ((String)entry.getKey()).split("#");
                String path = this.getCommentsPath(context, comment[0], comment[1]);
                Element asset = root.addElement("asset");
                asset.addAttribute("path", path);
                asset.addAttribute("class-name", comment[0]);
                asset.addAttribute("class-pk", comment[1]);
                List messages = (List)entry.getValue();
                for (MBMessage message : messages) {
                    path = this.getCommentsPath(context, comment[0], comment[1], message);
                    if (!context.isPathNotProcessed(path)) continue;
                    context.addZipEntry(path, (Object)message);
                }
            }
            context.addZipEntry(context.getRootPath() + "/comments.xml", doc.formattedString());
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    protected Element exportGroupPermissions(long companyId, long groupId, String resourceName, String resourcePrimKey, Element parentEl, String elName) throws SystemException {
        Element el = parentEl.addElement(elName);
        List permissions = PermissionLocalServiceUtil.getGroupPermissions((long)groupId, (long)companyId, (String)resourceName, (int)4, (String)resourcePrimKey);
        List<String> actions = ResourceActionsUtil.getActions(permissions);
        for (int i = 0; i < actions.size(); ++i) {
            String action = actions.get(i);
            Element actionKeyEl = el.addElement("action-key");
            actionKeyEl.addText(action);
        }
        return el;
    }

    protected void exportGroupRoles(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String entityName, Element parentEl) throws SystemException {
        List<Role> roles = layoutCache.getGroupRoles_4(groupId);
        Element groupEl = this.exportRoles(companyId, resourceName, 2, String.valueOf(groupId), parentEl, entityName + "-roles", roles);
        if (groupEl.elements().isEmpty()) {
            parentEl.remove(groupEl);
        }
    }

    protected void exportInheritedPermissions(LayoutCache layoutCache, long companyId, String resourceName, String resourcePrimKey, Element parentEl, String entityName) throws SystemException {
        Element entityPermissionsEl = SAXReaderUtil.createElement((String)(entityName + "-permissions"));
        Map<String, Long> entityMap = layoutCache.getEntityMap(companyId, entityName);
        for (Map.Entry<String, Long> entry : entityMap.entrySet()) {
            String name = entry.getKey().toString();
            long entityGroupId = entry.getValue();
            Element entityEl = this.exportGroupPermissions(companyId, entityGroupId, resourceName, resourcePrimKey, entityPermissionsEl, entityName + "-actions");
            if (entityEl.elements().isEmpty()) {
                entityPermissionsEl.remove(entityEl);
                continue;
            }
            entityEl.addAttribute("name", name);
        }
        if (!entityPermissionsEl.elements().isEmpty()) {
            parentEl.add(entityPermissionsEl);
        }
    }

    protected void exportInheritedRoles(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String entityName, Element parentEl) throws SystemException {
        Element entityRolesEl = SAXReaderUtil.createElement((String)(entityName + "-roles"));
        Map<String, Long> entityMap = layoutCache.getEntityMap(companyId, entityName);
        for (Map.Entry<String, Long> entry : entityMap.entrySet()) {
            String name = entry.getKey().toString();
            long entityGroupId = entry.getValue();
            List<Role> entityRoles = layoutCache.getGroupRoles_4(entityGroupId);
            Element entityEl = this.exportRoles(companyId, resourceName, 2, String.valueOf(groupId), entityRolesEl, entityName, entityRoles);
            if (entityEl.elements().isEmpty()) {
                entityRolesEl.remove(entityEl);
                continue;
            }
            entityEl.addAttribute("name", name);
        }
        if (!entityRolesEl.elements().isEmpty()) {
            parentEl.add(entityRolesEl);
        }
    }

    protected void exportPermissions_5(LayoutCache layoutCache, long groupId, String resourceName, long resourceId, Element permissionsEl) throws PortalException, SystemException {
        List<Role> roles = layoutCache.getGroupRoles_5(groupId, resourceName);
        for (Role role : roles) {
            if (role.getName().equals("Administrator")) continue;
            Element roleEl = permissionsEl.addElement("role");
            roleEl.addAttribute("name", role.getName());
            roleEl.addAttribute("description", role.getDescription());
            roleEl.addAttribute("type", String.valueOf(role.getType()));
            List permissions = PermissionLocalServiceUtil.getRolePermissions((long)role.getRoleId(), (long)resourceId);
            List<String> actions = ResourceActionsUtil.getActions(permissions);
            for (String action : actions) {
                Element actionKeyEl = roleEl.addElement("action-key");
                actionKeyEl.addText(action);
            }
        }
    }

    protected void exportPermissions_6(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String resourcePrimKey, Element permissionsEl, boolean portletActions) throws PortalException, SystemException {
        List<Role> roles = layoutCache.getGroupRoles_5(groupId, resourceName);
        for (Role role : roles) {
            if (role.getName().equals("Administrator")) continue;
            Element roleEl = permissionsEl.addElement("role");
            roleEl.addAttribute("name", role.getName());
            roleEl.addAttribute("description", role.getDescription());
            roleEl.addAttribute("type", String.valueOf(role.getType()));
            List<String> actionIds = null;
            actionIds = portletActions ? ResourceActionsUtil.getPortletResourceActions(resourceName) : ResourceActionsUtil.getModelResourceActions(resourceName);
            List actions = ResourcePermissionLocalServiceUtil.getAvailableResourcePermissionActionIds((long)companyId, (String)resourceName, (int)4, (String)resourcePrimKey, (long)role.getRoleId(), actionIds);
            for (String action : actions) {
                Element actionKeyEl = roleEl.addElement("action-key");
                actionKeyEl.addText(action);
            }
        }
    }

    protected void exportPortlet(PortletDataContext context, LayoutCache layoutCache, String portletId, Layout layout, Element parentEl, long defaultUserId, boolean exportPermissions, boolean exportPortletArchivedSetups, boolean exportPortletData, boolean exportPortletSetup, boolean exportPortletUserPreferences, boolean exportUserPermissions) throws PortalException, SystemException {
        long companyId = context.getCompanyId();
        long groupId = context.getGroupId();
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)context.getCompanyId(), (String)portletId);
        if (portlet == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not export portlet " + portletId + " because the portlet does not exist"));
            }
            return;
        }
        if (!portlet.isInstanceable() && !portlet.isPreferencesUniquePerLayout() && context.hasNotUniquePerLayout(portletId)) {
            return;
        }
        Document doc = SAXReaderUtil.createDocument();
        Element portletEl = doc.addElement("portlet");
        portletEl.addAttribute("portlet-id", portletId);
        portletEl.addAttribute("root-portlet-id", PortletConstants.getRootPortletId((String)portletId));
        portletEl.addAttribute("old-plid", String.valueOf(layout.getPlid()));
        portletEl.addAttribute("scope-layout-id", String.valueOf(context.getScopeLayoutId()));
        PortletPreferences jxPreferences = PortletPreferencesFactoryUtil.getPortletSetup((Layout)layout, (String)portletId, (String)"");
        if (exportPortletData) {
            if (!portlet.isPreferencesUniquePerLayout()) {
                String dataKey = portletId + "@" + context.getScopeLayoutId();
                if (!context.hasNotUniquePerLayout(dataKey)) {
                    context.putNotUniquePerLayout(dataKey);
                    this.exportPortletData(context, portlet, layout, jxPreferences, portletEl);
                }
            } else {
                this.exportPortletData(context, portlet, layout, jxPreferences, portletEl);
            }
        }
        if (exportPortletSetup) {
            this.exportPortletPreferences(context, 0L, 3, false, layout, portletId, portletEl);
            this.exportPortletPreferences(context, groupId, 2, false, layout, portletId, portletEl);
            this.exportPortletPreferences(context, companyId, 1, false, layout, portletId, portletEl);
        }
        if (exportPortletUserPreferences) {
            this.exportPortletPreferences(context, defaultUserId, 4, true, layout, portletId, portletEl);
            try {
                com.liferay.portal.model.PortletPreferences groupPortletPreferences = PortletPreferencesLocalServiceUtil.getPortletPreferences((long)groupId, (int)2, (long)0L, (String)portletId);
                this.exportPortletPreference(context, groupId, 2, false, groupPortletPreferences, portletId, 0L, portletEl);
            }
            catch (NoSuchPortletPreferencesException nsppe) {
                // empty catch block
            }
        }
        if (exportPortletArchivedSetups) {
            String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
            List portletItems = PortletItemLocalServiceUtil.getPortletItems((long)groupId, (String)rootPortletId, (String)com.liferay.portal.model.PortletPreferences.class.getName());
            for (PortletItem portletItem : portletItems) {
                long ownerId = portletItem.getPortletItemId();
                int ownerType = 5;
                this.exportPortletPreferences(context, ownerId, ownerType, false, null, portletItem.getPortletId(), portletEl);
            }
        }
        Group guestGroup = GroupLocalServiceUtil.getGroup((long)companyId, (String)"Guest");
        if (exportPermissions) {
            Element permissionsEl = portletEl.addElement("permissions");
            String resourceName = PortletConstants.getRootPortletId((String)portletId);
            String resourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
                this.exportPortletPermissions_5(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsEl);
            } else if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                this.exportPortletPermissions_6(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsEl);
            } else {
                this.exportPortletPermissions_4(layoutCache, companyId, groupId, guestGroup, resourceName, resourcePrimKey, permissionsEl, exportUserPermissions);
                Element rolesEl = portletEl.addElement("roles");
                this.exportPortletRoles(layoutCache, companyId, groupId, portletId, rolesEl);
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath(portletId));
        sb.append("/");
        sb.append(layout.getPlid());
        sb.append("/portlet.xml");
        String path = sb.toString();
        Element el = parentEl.addElement("portlet");
        el.addAttribute("portlet-id", portletId);
        el.addAttribute("layout-id", String.valueOf(layout.getLayoutId()));
        el.addAttribute("path", path);
        if (context.isPathNotProcessed(path)) {
            block21: {
                try {
                    context.addZipEntry(path, doc.formattedString());
                }
                catch (IOException ioe) {
                    if (!_log.isWarnEnabled()) break block21;
                    _log.warn((Object)ioe.getMessage());
                }
            }
            context.addPrimaryKey(String.class, path);
        }
    }

    protected void exportPortletData(PortletDataContext context, Portlet portlet, Layout layout, PortletPreferences portletPreferences, Element parentEl) throws SystemException {
        PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
        if (portletDataHandler == null) {
            return;
        }
        String portletId = portlet.getPortletId();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Exporting data for " + portletId));
        }
        String data = null;
        long groupId = context.getGroupId();
        context.setGroupId(context.getScopeGroupId());
        try {
            data = portletDataHandler.exportData(context, portletId, portletPreferences);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            context.setGroupId(groupId);
        }
        if (Validator.isNull((String)data)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Not exporting data for " + portletId + " because null data was returned"));
            }
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath(portletId));
        if (portlet.isPreferencesUniquePerLayout()) {
            sb.append("/");
            sb.append(layout.getPlid());
        }
        sb.append("/portlet-data.xml");
        Element portletDataEl = parentEl.addElement("portlet-data");
        portletDataEl.addAttribute("path", sb.toString());
        context.addZipEntry(sb.toString(), data);
    }

    protected void exportPortletPermissions_4(LayoutCache layoutCache, long companyId, long groupId, Group guestGroup, String resourceName, String resourcePrimKey, Element permissionsEl, boolean exportUserPermissions) throws SystemException {
        this.exportGroupPermissions(companyId, groupId, resourceName, resourcePrimKey, permissionsEl, "community-actions");
        if (groupId != guestGroup.getGroupId()) {
            this.exportGroupPermissions(companyId, guestGroup.getGroupId(), resourceName, resourcePrimKey, permissionsEl, "guest-actions");
        }
        if (exportUserPermissions) {
            this.exportUserPermissions(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsEl);
        }
        this.exportInheritedPermissions(layoutCache, companyId, resourceName, resourcePrimKey, permissionsEl, "organization");
        this.exportInheritedPermissions(layoutCache, companyId, resourceName, resourcePrimKey, permissionsEl, "user-group");
    }

    protected void exportPortletPermissions_5(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String resourcePrimKey, Element permissionsEl) throws PortalException, SystemException {
        boolean portletActions = true;
        Resource resource = layoutCache.getResource(companyId, groupId, resourceName, 4, resourcePrimKey, portletActions);
        this.exportPermissions_5(layoutCache, groupId, resourceName, resource.getResourceId(), permissionsEl);
    }

    protected void exportPortletPermissions_6(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String resourcePrimKey, Element permissionsEl) throws PortalException, SystemException {
        boolean portletActions = true;
        this.exportPermissions_6(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsEl, portletActions);
    }

    protected void exportPortletPreference(PortletDataContext context, long ownerId, int ownerType, boolean defaultUser, com.liferay.portal.model.PortletPreferences portletPreferences, String portletId, long plid, Element parentEl) throws SystemException {
        try {
            Document preferencesDoc = SAXReaderUtil.read((String)portletPreferences.getPreferences());
            Element root = preferencesDoc.getRootElement();
            root.addAttribute("owner-id", String.valueOf(ownerId));
            root.addAttribute("owner-type", String.valueOf(ownerType));
            root.addAttribute("default-user", String.valueOf(defaultUser));
            root.addAttribute("plid", String.valueOf(plid));
            root.addAttribute("portlet-id", portletId);
            if (ownerType == 5) {
                PortletItem portletItem = PortletItemLocalServiceUtil.getPortletItem((long)ownerId);
                User user = UserLocalServiceUtil.getUserById((long)portletItem.getUserId());
                root.addAttribute("archive-user-uuid", user.getUuid());
                root.addAttribute("archive-name", portletItem.getName());
            }
            String path = this.getPortletPreferencesPath(context, portletId, ownerId, ownerType, plid);
            parentEl.addElement("portlet-preferences").addAttribute("path", path);
            if (context.isPathNotProcessed(path)) {
                context.addZipEntry(path, preferencesDoc.formattedString());
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected void exportPortletPreferences(PortletDataContext context, long ownerId, int ownerType, boolean defaultUser, Layout layout, String portletId, Element parentEl) throws PortalException, SystemException {
        com.liferay.portal.model.PortletPreferences portletPreferences = null;
        long plid = 0L;
        if (layout != null) {
            plid = layout.getPlid();
        }
        if (ownerType == 1 || ownerType == 2 || ownerType == 5) {
            plid = 0L;
        }
        try {
            portletPreferences = PortletPreferencesLocalServiceUtil.getPortletPreferences((long)ownerId, (int)ownerType, (long)plid, (String)portletId);
            LayoutTypePortlet layoutTypePortlet = null;
            if (layout != null) {
                layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            }
            if (layoutTypePortlet == null || layoutTypePortlet.hasPortletId(portletId)) {
                this.exportPortletPreference(context, ownerId, ownerType, defaultUser, portletPreferences, portletId, plid, parentEl);
            }
        }
        catch (NoSuchPortletPreferencesException nsppe) {
            // empty catch block
        }
    }

    protected void exportPortletRoles(LayoutCache layoutCache, long companyId, long groupId, String portletId, Element rolesEl) throws SystemException {
        String resourceName = PortletConstants.getRootPortletId((String)portletId);
        Element portletEl = rolesEl.addElement("portlet");
        portletEl.addAttribute("portlet-id", portletId);
        this.exportGroupRoles(layoutCache, companyId, groupId, resourceName, "community", portletEl);
        this.exportUserRoles(layoutCache, companyId, groupId, resourceName, portletEl);
        this.exportInheritedRoles(layoutCache, companyId, groupId, resourceName, "organization", portletEl);
        this.exportInheritedRoles(layoutCache, companyId, groupId, resourceName, "user-group", portletEl);
        if (portletEl.elements().isEmpty()) {
            rolesEl.remove(portletEl);
        }
    }

    protected void exportRatings(PortletDataContext context, Element parentEl) throws SystemException {
        try {
            Document doc = SAXReaderUtil.createDocument();
            Element root = doc.addElement("ratings");
            Map ratingsEntriesMap = context.getRatingsEntries();
            for (Map.Entry entry : ratingsEntriesMap.entrySet()) {
                String[] ratingsEntry = ((String)entry.getKey()).split("#");
                String ratingPath = this.getRatingsPath(context, ratingsEntry[0], ratingsEntry[1]);
                Element asset = root.addElement("asset");
                asset.addAttribute("path", ratingPath);
                asset.addAttribute("class-name", ratingsEntry[0]);
                asset.addAttribute("class-pk", ratingsEntry[1]);
                List ratingsEntries = (List)entry.getValue();
                for (RatingsEntry rating : ratingsEntries) {
                    ratingPath = this.getRatingsPath(context, ratingsEntry[0], ratingsEntry[1], rating);
                    context.addZipEntry(ratingPath, (Object)rating);
                }
            }
            context.addZipEntry(context.getRootPath() + "/ratings.xml", doc.formattedString());
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected Element exportRoles(long companyId, String resourceName, int scope, String resourcePrimKey, Element parentEl, String elName, List<Role> roles) throws SystemException {
        Element el = parentEl.addElement(elName);
        Map resourceRoles = RoleLocalServiceUtil.getResourceRoles((long)companyId, (String)resourceName, (int)scope, (String)resourcePrimKey);
        for (Map.Entry entry : resourceRoles.entrySet()) {
            String roleName = ((String)entry.getKey()).toString();
            if (!this.hasRole(roles, roleName)) continue;
            Element roleEl = el.addElement("role");
            roleEl.addAttribute("name", roleName);
            List actions = (List)entry.getValue();
            for (int i = 0; i < actions.size(); ++i) {
                String action = (String)actions.get(i);
                Element actionKeyEl = roleEl.addElement("action-key");
                actionKeyEl.addText(action);
                actionKeyEl.addAttribute("scope", String.valueOf(scope));
            }
        }
        return el;
    }

    protected void exportTags(PortletDataContext context, Element parentEl) throws SystemException {
        try {
            Document doc = SAXReaderUtil.createDocument();
            Element root = doc.addElement("tags");
            Map tagsEntries = context.getTagsEntries();
            for (Map.Entry entry : tagsEntries.entrySet()) {
                String[] tagsEntry = ((String)entry.getKey()).split("#");
                Element asset = root.addElement("asset");
                asset.addAttribute("class-name", tagsEntry[0]);
                asset.addAttribute("class-pk", tagsEntry[1]);
                asset.addAttribute("entries", StringUtil.merge((Object[])((Object[])entry.getValue())));
            }
            context.addZipEntry(context.getRootPath() + "/tags.xml", doc.formattedString());
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected void exportUserPermissions(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String resourcePrimKey, Element parentEl) throws SystemException {
        StopWatch stopWatch = null;
        if (_log.isDebugEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        Element userPermissionsEl = SAXReaderUtil.createElement((String)"user-permissions");
        List<User> users = layoutCache.getGroupUsers(groupId);
        for (User user : users) {
            String uuid = user.getUuid();
            Element userActionsEl = SAXReaderUtil.createElement((String)"user-actions");
            List permissions = PermissionLocalServiceUtil.getUserPermissions((long)user.getUserId(), (long)companyId, (String)resourceName, (int)4, (String)resourcePrimKey);
            List<String> actions = ResourceActionsUtil.getActions(permissions);
            for (String action : actions) {
                Element actionKeyEl = userActionsEl.addElement("action-key");
                actionKeyEl.addText(action);
            }
            if (userActionsEl.elements().isEmpty()) continue;
            userActionsEl.addAttribute("uuid", uuid);
            userPermissionsEl.add(userActionsEl);
        }
        if (!userPermissionsEl.elements().isEmpty()) {
            parentEl.add(userPermissionsEl);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export user permissions for {" + resourceName + ", " + resourcePrimKey + "} with " + users.size() + " users takes " + stopWatch.getTime() + " ms"));
        }
    }

    protected void exportUserRoles(LayoutCache layoutCache, long companyId, long groupId, String resourceName, Element parentEl) throws SystemException {
        Element userRolesEl = SAXReaderUtil.createElement((String)"user-roles");
        List<User> users = layoutCache.getGroupUsers(groupId);
        for (User user : users) {
            long userId = user.getUserId();
            String uuid = user.getUuid();
            List<Role> userRoles = layoutCache.getUserRoles(userId);
            Element userEl = this.exportRoles(companyId, resourceName, 2, String.valueOf(groupId), userRolesEl, "user", userRoles);
            if (userEl.elements().isEmpty()) {
                userRolesEl.remove(userEl);
                continue;
            }
            userEl.addAttribute("uuid", uuid);
        }
        if (!userRolesEl.elements().isEmpty()) {
            parentEl.add(userRolesEl);
        }
    }

    protected String getCommentsPath(PortletDataContext context, String className, String classPK) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getRootPath());
        sb.append("/comments/");
        sb.append(PortalUtil.getClassNameId((String)className));
        sb.append('/');
        sb.append(classPK);
        sb.append('/');
        return sb.toString();
    }

    protected String getCommentsPath(PortletDataContext context, String className, String classPK, MBMessage message) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getRootPath());
        sb.append("/comments/");
        sb.append(PortalUtil.getClassNameId((String)className));
        sb.append('/');
        sb.append(classPK);
        sb.append('/');
        sb.append(message.getMessageId());
        sb.append(".xml");
        return sb.toString();
    }

    protected String getPortletDataPath(PortletDataContext context, String portletId) {
        return context.getPortletPath(portletId) + "/portlet-data.xml";
    }

    protected String getPortletPreferencesPath(PortletDataContext context, String portletId, long ownerId, int ownerType, long plid) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath(portletId));
        sb.append("/preferences/");
        if (ownerType == 1) {
            sb.append("company/");
        } else if (ownerType == 2) {
            sb.append("group/");
        } else if (ownerType == 3) {
            sb.append("layout/");
        } else if (ownerType == 4) {
            sb.append("user/");
        } else if (ownerType == 5) {
            sb.append("archived/");
        }
        sb.append(ownerId);
        sb.append('/');
        sb.append(plid);
        sb.append('/');
        sb.append("portlet-preferences.xml");
        return sb.toString();
    }

    protected String getRatingsPath(PortletDataContext context, String className, String classPK) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getRootPath());
        sb.append("/ratings/");
        sb.append(PortalUtil.getClassNameId((String)className));
        sb.append('/');
        sb.append(classPK);
        sb.append('/');
        return sb.toString();
    }

    protected String getRatingsPath(PortletDataContext context, String className, String classPK, RatingsEntry rating) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getRootPath());
        sb.append("/ratings/");
        sb.append(PortalUtil.getClassNameId((String)className));
        sb.append('/');
        sb.append(classPK);
        sb.append('/');
        sb.append(rating.getEntryId());
        sb.append(".xml");
        return sb.toString();
    }

    protected boolean hasRole(List<Role> roles, String roleName) {
        if (roles == null || roles.size() == 0) {
            return false;
        }
        for (Role role : roles) {
            if (!role.getName().equals(roleName)) continue;
            return true;
        }
        return false;
    }
}

