/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.LARFileException;
import com.liferay.portal.LARTypeException;
import com.liferay.portal.LayoutImportException;
import com.liferay.portal.PortalException;
import com.liferay.portal.PortletIdException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactoryUtil;
import com.liferay.portal.lar.AlwaysCurrentUserIdStrategy;
import com.liferay.portal.lar.CurrentUserIdStrategy;
import com.liferay.portal.lar.PortletDataContext;
import com.liferay.portal.lar.PortletDataContextImpl;
import com.liferay.portal.lar.PortletDataHandler;
import com.liferay.portal.lar.UserIdStrategy;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.PortletItem;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.PortletPreferencesImpl;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PortletItemLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.persistence.PortletPreferencesUtil;
import com.liferay.portal.service.persistence.UserUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.PortletPreferencesSerializer;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.ratings.model.RatingsEntry;
import com.liferay.portlet.social.util.SocialActivityThreadLocal;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.time.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletImporter {
    private static Log _log = LogFactoryUtil.getLog(PortletImporter.class);

    public void importPortletInfo(long userId, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        boolean deletePortletData = MapUtil.getBoolean(parameterMap, (String)"DELETE_PORTLET_DATA");
        boolean importPortletData = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA");
        boolean importPortletArchivedSetups = MapUtil.getBoolean(parameterMap, (String)"PORTLET_ARCHIVED_SETUPS");
        boolean importPortletSetup = MapUtil.getBoolean(parameterMap, (String)"PORTLET_SETUP");
        boolean importUserPreferences = MapUtil.getBoolean(parameterMap, (String)"PORTLET_USER_PREFERENCES");
        String userIdStrategy = MapUtil.getString(parameterMap, (String)"USER_ID_STRATEGY");
        StopWatch stopWatch = null;
        if (_log.isInfoEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        long companyId = layout.getCompanyId();
        User user = UserUtil.findByPrimaryKey((long)userId);
        UserIdStrategy strategy = this.getUserIdStrategy(user, userIdStrategy);
        ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
        PortletDataContextImpl context = new PortletDataContextImpl(companyId, groupId, parameterMap, new HashSet<String>(), strategy, zipReader);
        context.setPlid(plid);
        context.setPrivateLayout(layout.isPrivateLayout());
        Element root = null;
        String xml = context.getZipEntryAsString("/manifest.xml");
        try {
            Document doc = SAXReaderUtil.read((String)xml);
            root = doc.getRootElement();
        }
        catch (Exception e) {
            throw new LARFileException("Cannot locate a manifest in this LAR file.");
        }
        Element header = root.element("header");
        int buildNumber = ReleaseInfo.getBuildNumber();
        int importBuildNumber = GetterUtil.getInteger((String)header.attributeValue("build-number"));
        if (buildNumber != importBuildNumber) {
            throw new LayoutImportException("LAR build number " + importBuildNumber + " does not match " + "portal build number " + buildNumber);
        }
        String type = header.attributeValue("type");
        if (!type.equals("portlet")) {
            throw new LARTypeException("Invalid type of LAR file (" + type + ")");
        }
        String rootPortletId = header.attributeValue("root-portlet-id");
        if (!PortletConstants.getRootPortletId((String)portletId).equals(rootPortletId)) {
            throw new PortletIdException("Invalid portlet id " + rootPortletId);
        }
        long sourceGroupId = GetterUtil.getLong((String)header.attributeValue("group-id"));
        context.setSourceGroupId(sourceGroupId);
        this.readCategories(context, root);
        this.readComments(context, root);
        this.readRatings(context, root);
        this.readTags(context, root);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Deleting portlet data");
        }
        if (deletePortletData) {
            this.deletePortletData((PortletDataContext)context, portletId, plid);
        }
        Element portletRefEl = root.element("portlet");
        Element portletEl = null;
        try {
            Document portletDoc = SAXReaderUtil.read((String)context.getZipEntryAsString(portletRefEl.attributeValue("path")));
            portletEl = portletDoc.getRootElement();
        }
        catch (DocumentException de) {
            throw new SystemException((Throwable)de);
        }
        this.importPortletPreferences(context, layout.getCompanyId(), groupId, layout, portletId, portletEl, importPortletSetup, importPortletArchivedSetups, importUserPreferences, true);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Importing portlet data");
        }
        if (importPortletData) {
            Element portletDataRefEl = portletEl.element("portlet-data");
            if (portletDataRefEl != null) {
                this.importPortletData((PortletDataContext)context, portletId, plid, portletDataRefEl);
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)"Could not import portlet data because it cannot be found in the input");
            }
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Importing portlet data takes " + stopWatch.getTime() + " ms"));
        }
        zipReader.close();
    }

    protected void deletePortletData(PortletDataContext context, String portletId, long plid) throws SystemException {
        String xml;
        long ownerId = 0L;
        int ownerType = 3;
        com.liferay.portal.model.PortletPreferences portletPreferences = PortletPreferencesUtil.fetchByO_O_P_P((long)ownerId, (int)ownerType, (long)plid, (String)portletId);
        if (portletPreferences == null) {
            portletPreferences = new PortletPreferencesImpl();
        }
        if ((xml = this.deletePortletData(context, portletId, portletPreferences)) != null) {
            PortletPreferencesLocalServiceUtil.updatePreferences((long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        }
    }

    protected String deletePortletData(PortletDataContext context, String portletId, com.liferay.portal.model.PortletPreferences portletPreferences) throws SystemException {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)context.getCompanyId(), (String)portletId);
        if (portlet == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not delete portlet data for " + portletId + " because the portlet does not exist"));
            }
            return null;
        }
        PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
        if (portletDataHandler == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not delete portlet data for " + portletId + " because the portlet does not have a " + "PortletDataHandler"));
            }
            return null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Deleting data for " + portletId));
        }
        com.liferay.portlet.PortletPreferencesImpl preferencesImpl = (com.liferay.portlet.PortletPreferencesImpl)PortletPreferencesSerializer.fromDefaultXML(portletPreferences.getPreferences());
        try {
            preferencesImpl = (com.liferay.portlet.PortletPreferencesImpl)portletDataHandler.deleteData(context, portletId, (PortletPreferences)preferencesImpl);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            context.setGroupId(context.getScopeGroupId());
        }
        if (preferencesImpl == null) {
            return null;
        }
        return PortletPreferencesSerializer.toXML(preferencesImpl);
    }

    protected UserIdStrategy getUserIdStrategy(User user, String userIdStrategy) {
        if ("ALWAYS_CURRENT_USER_ID".equals(userIdStrategy)) {
            return new AlwaysCurrentUserIdStrategy(user);
        }
        return new CurrentUserIdStrategy(user);
    }

    protected void importPortletData(PortletDataContext context, String portletId, long plid, Element portletDataRefEl) throws SystemException {
        String xml;
        long ownerId = 0L;
        int ownerType = 3;
        com.liferay.portal.model.PortletPreferences portletPreferences = PortletPreferencesUtil.fetchByO_O_P_P((long)ownerId, (int)ownerType, (long)plid, (String)portletId);
        if (portletPreferences == null) {
            portletPreferences = new PortletPreferencesImpl();
        }
        if ((xml = this.importPortletData(context, portletId, portletPreferences, portletDataRefEl)) != null) {
            PortletPreferencesLocalServiceUtil.updatePreferences((long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        }
    }

    protected String importPortletData(PortletDataContext context, String portletId, com.liferay.portal.model.PortletPreferences portletPreferences, Element portletDataRefEl) throws SystemException {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)context.getCompanyId(), (String)portletId);
        if (portlet == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not import portlet data for " + portletId + " because the portlet does not exist"));
            }
            return null;
        }
        PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
        if (portletDataHandler == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not import portlet data for " + portletId + " because the portlet does not have a " + "PortletDataHandler"));
            }
            return null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Importing data for " + portletId));
        }
        long groupId = context.getGroupId();
        long scopeLayoutId = context.getScopeLayoutId();
        if (scopeLayoutId == 0L) {
            scopeLayoutId = GetterUtil.getLong((String)portletDataRefEl.getParent().attributeValue("scope-layout-id"));
        }
        if (scopeLayoutId > 0L) {
            try {
                Layout scopeLayout = LayoutLocalServiceUtil.getLayout((long)context.getGroupId(), (boolean)context.isPrivateLayout(), (long)scopeLayoutId);
                Group scopeGroup = null;
                if (scopeLayout.hasScopeGroup()) {
                    scopeGroup = scopeLayout.getScopeGroup();
                } else {
                    String name = String.valueOf(scopeLayout.getPlid());
                    scopeGroup = GroupLocalServiceUtil.addGroup((long)context.getUserId(null), (String)Layout.class.getName(), (long)scopeLayout.getPlid(), (String)name, null, (int)0, null, (boolean)true, null);
                }
                context.setGroupId(scopeGroup.getGroupId());
            }
            catch (PortalException pe) {
                // empty catch block
            }
        }
        com.liferay.portlet.PortletPreferencesImpl preferencesImpl = null;
        if (portletPreferences != null) {
            preferencesImpl = (com.liferay.portlet.PortletPreferencesImpl)PortletPreferencesSerializer.fromDefaultXML(portletPreferences.getPreferences());
        }
        String portletData = context.getZipEntryAsString(portletDataRefEl.attributeValue("path"));
        try {
            SocialActivityThreadLocal.setEnabled(false);
            preferencesImpl = (com.liferay.portlet.PortletPreferencesImpl)portletDataHandler.importData(context, portletId, (PortletPreferences)preferencesImpl, portletData);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            context.setGroupId(groupId);
            SocialActivityThreadLocal.setEnabled(true);
        }
        if (preferencesImpl == null) {
            return null;
        }
        return PortletPreferencesSerializer.toXML(preferencesImpl);
    }

    protected void importPortletPreferences(PortletDataContext context, long companyId, long groupId, Layout layout, String portletId, Element parentEl, boolean importPortletSetup, boolean importPortletArchivedSetups, boolean importUserPreferences, boolean preserveScopeLayoutId) throws PortalException, SystemException {
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
        long plid = 0L;
        long scopeLayoutId = 0L;
        if (layout != null) {
            plid = layout.getPlid();
            if (preserveScopeLayoutId && portletId != null) {
                PortletPreferences jxPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
                scopeLayoutId = GetterUtil.getLong((String)jxPreferences.getValue("lfr-scope-layout-id", null));
                context.setScopeLayoutId(scopeLayoutId);
            }
        }
        List preferencesEls = parentEl.elements("portlet-preferences");
        for (Element preferencesEl : preferencesEls) {
            String path = preferencesEl.attributeValue("path");
            if (!context.isPathNotProcessed(path)) continue;
            Element el = null;
            String xml = null;
            try {
                xml = context.getZipEntryAsString(path);
                Document preferencesDoc = SAXReaderUtil.read((String)xml);
                el = preferencesDoc.getRootElement();
            }
            catch (DocumentException de) {
                throw new SystemException((Throwable)de);
            }
            long ownerId = GetterUtil.getLong((String)el.attributeValue("owner-id"));
            int ownerType = GetterUtil.getInteger((String)el.attributeValue("owner-type"));
            if (ownerType == 1 || (ownerType == 2 || ownerType == 3) && !importPortletSetup || ownerType == 5 && !importPortletArchivedSetups || ownerType == 4 && ownerId != 0L && !importUserPreferences) continue;
            if (ownerType == 2) {
                plid = 0L;
                ownerId = context.getGroupId();
            }
            boolean defaultUser = GetterUtil.getBoolean((String)el.attributeValue("default-user"));
            if (portletId == null) {
                portletId = el.attributeValue("portlet-id");
            }
            if (ownerType == 5) {
                portletId = PortletConstants.getRootPortletId((String)portletId);
                String userUuid = el.attributeValue("archive-user-uuid");
                String name = el.attributeValue("archive-name");
                long userId = context.getUserId(userUuid);
                PortletItem portletItem = PortletItemLocalServiceUtil.updatePortletItem((long)userId, (long)groupId, (String)name, (String)portletId, (String)com.liferay.portal.model.PortletPreferences.class.getName());
                plid = 0L;
                ownerId = portletItem.getPortletItemId();
            }
            if (defaultUser) {
                ownerId = defaultUserId;
            }
            PortletPreferencesLocalServiceUtil.updatePreferences((long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        }
        if (preserveScopeLayoutId && layout != null) {
            PortletPreferences jxPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
            try {
                jxPreferences.setValue("lfr-scope-layout-id", String.valueOf(scopeLayoutId));
                jxPreferences.store();
            }
            catch (Exception e) {
                throw new PortalException((Throwable)e);
            }
            finally {
                context.setScopeLayoutId(scopeLayoutId);
            }
        }
    }

    protected void readComments(PortletDataContext context, Element parentEl) throws SystemException {
        try {
            String xml = context.getZipEntryAsString(context.getSourceRootPath() + "/comments.xml");
            if (xml == null) {
                return;
            }
            Document doc = SAXReaderUtil.read((String)xml);
            Element root = doc.getRootElement();
            List assets = root.elements("asset");
            for (Element asset : assets) {
                String path = asset.attributeValue("path");
                String className = asset.attributeValue("class-name");
                long classPK = GetterUtil.getLong((String)asset.attributeValue("class-pk"));
                List zipFolderEntries = context.getZipFolderEntries(path);
                ArrayList<MBMessage> messages = new ArrayList<MBMessage>();
                for (String zipFolderEntry : zipFolderEntries) {
                    MBMessage message = (MBMessage)context.getZipEntryAsObject(zipFolderEntry);
                    if (message == null) continue;
                    messages.add(message);
                }
                context.addComments(className, classPK, messages);
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected void readRatings(PortletDataContext context, Element parentEl) throws SystemException {
        try {
            String xml = context.getZipEntryAsString(context.getSourceRootPath() + "/ratings.xml");
            if (xml == null) {
                return;
            }
            Document doc = SAXReaderUtil.read((String)xml);
            Element root = doc.getRootElement();
            List assets = root.elements("asset");
            for (Element asset : assets) {
                String path = asset.attributeValue("path");
                String className = asset.attributeValue("class-name");
                long classPK = GetterUtil.getLong((String)asset.attributeValue("class-pk"));
                List zipFolderEntries = context.getZipFolderEntries(path);
                ArrayList<RatingsEntry> ratingsEntries = new ArrayList<RatingsEntry>();
                for (String zipFolderEntry : zipFolderEntries) {
                    RatingsEntry ratingsEntry = (RatingsEntry)context.getZipEntryAsObject(zipFolderEntry);
                    if (ratingsEntry == null) continue;
                    ratingsEntries.add(ratingsEntry);
                }
                context.addRatingsEntries(className, new Long(classPK).longValue(), ratingsEntries);
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected void readCategories(PortletDataContext context, Element parentEl) throws SystemException {
        try {
            String xml = context.getZipEntryAsString(context.getSourceRootPath() + "/categories.xml");
            if (xml == null) {
                return;
            }
            Document doc = SAXReaderUtil.read((String)xml);
            Element root = doc.getRootElement();
            List assets = root.elements("asset");
            for (Element asset : assets) {
                String className = GetterUtil.getString((String)asset.attributeValue("class-name"));
                long classPK = GetterUtil.getLong((String)asset.attributeValue("class-pk"));
                String entries = GetterUtil.getString((String)asset.attributeValue("entries"));
                context.addTagsCategories(className, new Long(classPK).longValue(), StringUtil.split((String)entries));
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected void readTags(PortletDataContext context, Element parentEl) throws SystemException {
        try {
            String xml = context.getZipEntryAsString(context.getSourceRootPath() + "/tags.xml");
            if (xml == null) {
                return;
            }
            Document doc = SAXReaderUtil.read((String)xml);
            Element root = doc.getRootElement();
            List assets = root.elements("asset");
            for (Element asset : assets) {
                String className = GetterUtil.getString((String)asset.attributeValue("class-name"));
                long classPK = GetterUtil.getLong((String)asset.attributeValue("class-pk"));
                String entries = GetterUtil.getString((String)asset.attributeValue("entries"));
                context.addTagsEntries(className, new Long(classPK).longValue(), StringUtil.split((String)entries));
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }
}

