/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.liveusers.messaging;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.liveusers.LiveUsers;

public class LiveUsersMessageListener
implements MessageListener {
    private static Log _log = LogFactoryUtil.getLog(LiveUsersMessageListener.class);

    public void receive(Message message) {
        try {
            this.doReceive(message);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to process message " + message), (Throwable)e);
        }
    }

    protected void doCommandSignIn(JSONObject jsonObj) throws Exception {
        long companyId = jsonObj.getLong("companyId");
        long userId = jsonObj.getLong("userId");
        String sessionId = jsonObj.getString("sessionId");
        String remoteAddr = jsonObj.getString("remoteAddr");
        String remoteHost = jsonObj.getString("remoteHost");
        String userAgent = jsonObj.getString("userAgent");
        LiveUsers.signIn(companyId, userId, sessionId, remoteAddr, remoteHost, userAgent);
    }

    protected void doCommandSignOut(JSONObject jsonObj) throws Exception {
        long companyId = jsonObj.getLong("companyId");
        long userId = jsonObj.getLong("userId");
        String sessionId = jsonObj.getString("sessionId");
        LiveUsers.signOut(companyId, userId, sessionId);
    }

    protected void doReceive(Message message) throws Exception {
        JSONObject jsonObj = (JSONObject)message.getPayload();
        String command = jsonObj.getString("command");
        if (command.equals("signIn")) {
            this.doCommandSignIn(jsonObj);
        } else if (command.equals("signOut")) {
            this.doCommandSignOut(jsonObj);
        }
    }
}

