/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReader;
import com.liferay.portal.model.ModelHints;
import com.liferay.portal.service.ClassNameLocalServiceUtil;
import com.liferay.portal.util.PropsUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelHintsImpl
implements ModelHints {
    private static final String _ELEMENTS_SUFFIX = "_ELEMENTS";
    private static final String _TYPE_SUFFIX = "_TYPE";
    private static final String _LOCALIZATION_SUFFIX = "_LOCALIZATION";
    private static final String _HINTS_SUFFIX = "_HINTS";
    private static Log _log = LogFactoryUtil.getLog(ModelHintsImpl.class);
    private Map<String, Map<String, String>> _hintCollections;
    private Map<String, Map<String, String>> _defaultHints;
    private Map<String, Object> _modelFields;
    private Set<String> _models;
    private SAXReader _saxReader;

    public void afterPropertiesSet() {
        this._hintCollections = new HashMap<String, Map<String, String>>();
        this._defaultHints = new HashMap<String, Map<String, String>>();
        this._modelFields = new HashMap<String, Object>();
        this._models = new TreeSet<String>();
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            String[] configs = StringUtil.split((String)PropsUtil.get("model.hints.configs"));
            for (int i = 0; i < configs.length; ++i) {
                this.read(classLoader, configs[i]);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public Map<String, String> getDefaultHints(String model) {
        return this._defaultHints.get(model);
    }

    public Element getFieldsEl(String model, String field) {
        Map fields = (Map)this._modelFields.get(model);
        if (fields == null) {
            return null;
        }
        Element fieldsEl = (Element)fields.get(field + _ELEMENTS_SUFFIX);
        if (fieldsEl == null) {
            return null;
        }
        return fieldsEl;
    }

    public List<String> getModels() {
        return ListUtil.fromCollection(this._models);
    }

    public String getType(String model, String field) {
        Map fields = (Map)this._modelFields.get(model);
        if (fields == null) {
            return null;
        }
        return (String)fields.get(field + _TYPE_SUFFIX);
    }

    public Map<String, String> getHints(String model, String field) {
        Map fields = (Map)this._modelFields.get(model);
        if (fields == null) {
            return null;
        }
        return (Map)fields.get(field + _HINTS_SUFFIX);
    }

    public boolean isLocalized(String model, String field) {
        Map fields = (Map)this._modelFields.get(model);
        if (fields == null) {
            return false;
        }
        return (Boolean)fields.get(field + _LOCALIZATION_SUFFIX);
    }

    public void read(ClassLoader classLoader, String source) throws Exception {
        String name;
        String xml;
        block15: {
            xml = null;
            try {
                xml = StringUtil.read((ClassLoader)classLoader, (String)source);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block15;
                _log.warn((Object)("Cannot load " + source));
            }
        }
        if (xml == null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Loading " + source));
        }
        Document doc = this._saxReader.read(xml);
        Element root = doc.getRootElement();
        for (Element hintCollection : root.elements("hint-collection")) {
            name = hintCollection.attributeValue("name");
            Map<String, String> hints = this._hintCollections.get(name);
            if (hints == null) {
                hints = new HashMap<String, String>();
                this._hintCollections.put(name, hints);
            }
            for (Element hint : hintCollection.elements("hint")) {
                String hintName = hint.attributeValue("name");
                String hintValue = hint.getText();
                hints.put(hintName, hintValue);
            }
        }
        for (Element model : root.elements("model")) {
            HashMap<String, Object> fields;
            name = model.attributeValue("name");
            if (classLoader != ModelHintsImpl.class.getClassLoader()) {
                ClassNameLocalServiceUtil.getClassName((String)name);
            }
            HashMap<String, String> defaultHints = new HashMap<String, String>();
            this._defaultHints.put(name, defaultHints);
            Element defaultHintsEl = model.element("default-hints");
            if (defaultHintsEl != null) {
                for (Element hint : defaultHintsEl.elements("hint")) {
                    String hintName = hint.attributeValue("name");
                    String hintValue = hint.getText();
                    defaultHints.put(hintName, hintValue);
                }
            }
            if ((fields = (HashMap<String, Object>)this._modelFields.get(name)) == null) {
                fields = new HashMap<String, Object>();
                this._modelFields.put(name, fields);
            }
            this._models.add(name);
            for (Element field : model.elements("field")) {
                String fieldName = field.attributeValue("name");
                String fieldType = field.attributeValue("type");
                boolean fieldLocalized = GetterUtil.getBoolean((String)field.attributeValue("localized"));
                HashMap<String, String> fieldHints = new HashMap<String, String>();
                fieldHints.putAll(defaultHints);
                for (Element hintCollection : field.elements("hint-collection")) {
                    Map<String, String> hints = this._hintCollections.get(hintCollection.attributeValue("name"));
                    fieldHints.putAll(hints);
                }
                for (Element hint : field.elements("hint")) {
                    String hintName = hint.attributeValue("name");
                    String hintValue = hint.getText();
                    fieldHints.put(hintName, hintValue);
                }
                fields.put(fieldName + _ELEMENTS_SUFFIX, field);
                fields.put(fieldName + _TYPE_SUFFIX, fieldType);
                fields.put(fieldName + _LOCALIZATION_SUFFIX, fieldLocalized);
                fields.put(fieldName + _HINTS_SUFFIX, fieldHints);
            }
        }
    }

    public void setSAXReader(SAXReader saxReader) {
        this._saxReader = saxReader;
    }

    public String trimString(String model, String field, String value) {
        if (value == null) {
            return value;
        }
        Map<String, String> hints = this.getHints(model, field);
        if (hints == null) {
            return value;
        }
        int maxLength = GetterUtil.getInteger((String)"75");
        maxLength = GetterUtil.getInteger((String)hints.get("max-length"), (int)maxLength);
        if (value.length() > maxLength) {
            return value.substring(0, maxLength);
        }
        return value;
    }
}

