/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.SafeProperties;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ColorScheme;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.util.Properties;

public class ColorSchemeImpl
implements ColorScheme {
    private static Log _log = LogFactoryUtil.getLog(ColorScheme.class);
    private String _colorSchemeId;
    private String _name;
    private String _cssClass;
    private String _colorSchemeImagesPath = "${images-path}/color_schemes/${css-class}";
    private boolean _defaultCs;
    private Properties _settingsProperties = new SafeProperties();

    public static String getDefaultRegularColorSchemeId() {
        return PropsValues.DEFAULT_REGULAR_COLOR_SCHEME_ID;
    }

    public static String getDefaultWapColorSchemeId() {
        return PropsValues.DEFAULT_WAP_COLOR_SCHEME_ID;
    }

    public static ColorScheme getNullColorScheme() {
        return new ColorSchemeImpl(ColorSchemeImpl.getDefaultRegularColorSchemeId(), "", "");
    }

    public ColorSchemeImpl() {
    }

    public ColorSchemeImpl(String colorSchemeId) {
        this._colorSchemeId = colorSchemeId;
    }

    public ColorSchemeImpl(String colorSchemeId, String name, String cssClass) {
        this._colorSchemeId = colorSchemeId;
        this._name = name;
        this._cssClass = cssClass;
    }

    public String getColorSchemeId() {
        return this._colorSchemeId;
    }

    public String getName() {
        if (Validator.isNull((String)this._name)) {
            return this._colorSchemeId;
        }
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public boolean getDefaultCs() {
        return this._defaultCs;
    }

    public boolean isDefaultCs() {
        return this._defaultCs;
    }

    public void setDefaultCs(boolean defaultCs) {
        this._defaultCs = defaultCs;
    }

    public String getCssClass() {
        return this._cssClass;
    }

    public void setCssClass(String cssClass) {
        this._cssClass = cssClass;
    }

    public String getColorSchemeImagesPath() {
        return this._colorSchemeImagesPath;
    }

    public String getColorSchemeThumbnailPath() {
        int pos;
        if (Validator.isNotNull((String)this._cssClass) && Validator.isNotNull((String)this._colorSchemeImagesPath) && (pos = this._cssClass.indexOf(" ")) > 0 && this._colorSchemeImagesPath.endsWith(this._cssClass.substring(0, pos))) {
            String subclassPath = StringUtil.replace((String)this._cssClass, (String)" ", (String)"/");
            return this._colorSchemeImagesPath + subclassPath.substring(pos);
        }
        return this._colorSchemeImagesPath;
    }

    public void setColorSchemeImagesPath(String colorSchemeImagesPath) {
        this._colorSchemeImagesPath = colorSchemeImagesPath;
    }

    public String getSettings() {
        return PropertiesUtil.toString((Properties)this._settingsProperties);
    }

    public void setSettings(String settings) {
        this._settingsProperties.clear();
        try {
            PropertiesUtil.load((Properties)this._settingsProperties, (String)settings);
            PropertiesUtil.trimKeys((Properties)this._settingsProperties);
        }
        catch (IOException ioe) {
            _log.error((Throwable)ioe);
        }
    }

    public Properties getSettingsProperties() {
        return this._settingsProperties;
    }

    public void setSettingsProperties(Properties settingsProperties) {
        this._settingsProperties = settingsProperties;
    }

    public String getSetting(String key) {
        if (key.endsWith("-bg")) {
            return "#FFFFFF";
        }
        return "#000000";
    }

    public int compareTo(ColorScheme colorScheme) {
        return this.getName().compareTo(colorScheme.getName());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        ColorScheme colorScheme = null;
        try {
            colorScheme = (ColorScheme)obj;
        }
        catch (ClassCastException cce) {
            return false;
        }
        String colorSchemeId = colorScheme.getColorSchemeId();
        return this.getColorSchemeId().equals(colorSchemeId);
    }
}

