/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Account;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Shard;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.AccountImpl;
import com.liferay.portal.model.impl.CompanyModelImpl;
import com.liferay.portal.service.AccountLocalServiceUtil;
import com.liferay.portal.service.ShardLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.security.Key;
import java.util.Locale;
import java.util.TimeZone;

public class CompanyImpl
extends CompanyModelImpl
implements Company {
    private static Log _log = LogFactoryUtil.getLog(CompanyImpl.class);
    private Key _keyObj = null;

    public int compareTo(Company company) {
        String webId1 = this.getWebId();
        String webId2 = company.getWebId();
        if (webId1.equals(PropsValues.COMPANY_DEFAULT_WEB_ID)) {
            return -1;
        }
        if (webId2.equals(PropsValues.COMPANY_DEFAULT_WEB_ID)) {
            return 1;
        }
        return webId1.compareTo(webId2);
    }

    public Account getAccount() {
        Account account = null;
        try {
            account = AccountLocalServiceUtil.getAccount((long)this.getCompanyId(), (long)this.getAccountId());
        }
        catch (Exception e) {
            account = new AccountImpl();
            _log.error((Object)e, (Throwable)e);
        }
        return account;
    }

    public String getAdminName() {
        return "Administrator";
    }

    public String getAuthType() throws SystemException {
        return PrefsPropsUtil.getString(this.getCompanyId(), "company.security.auth.type", PropsValues.COMPANY_SECURITY_AUTH_TYPE);
    }

    public User getDefaultUser() {
        User defaultUser = null;
        try {
            defaultUser = UserLocalServiceUtil.getDefaultUser((long)this.getCompanyId());
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return defaultUser;
    }

    public String getDefaultWebId() {
        return PropsValues.COMPANY_DEFAULT_WEB_ID;
    }

    public String getEmailAddress() {
        return "admin@" + this.getMx();
    }

    public Key getKeyObj() {
        String key;
        if (this._keyObj == null && Validator.isNotNull((String)(key = this.getKey()))) {
            this._keyObj = (Key)Base64.stringToObject((String)key);
        }
        return this._keyObj;
    }

    public Locale getLocale() {
        return this.getDefaultUser().getLocale();
    }

    public String getName() {
        return this.getAccount().getName();
    }

    public String getShardName() {
        String shardName = PropsValues.SHARD_DEFAULT_NAME;
        try {
            Shard shard = ShardLocalServiceUtil.getShard((String)Company.class.getName(), (long)this.getCompanyId());
            shardName = shard.getName();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return shardName;
    }

    public String getShortName() {
        return this.getName();
    }

    public TimeZone getTimeZone() {
        return this.getDefaultUser().getTimeZone();
    }

    public boolean hasCompanyMx(String emailAddress) {
        int pos = (emailAddress = emailAddress.trim().toLowerCase()).indexOf("@");
        if (pos == -1) {
            return false;
        }
        String mx = emailAddress.substring(pos + 1, emailAddress.length());
        if (mx.equals(this.getMx())) {
            return true;
        }
        try {
            String[] mailHostNames = PrefsPropsUtil.getStringArray(this.getCompanyId(), "admin.mail.host.names", "\n", PropsValues.ADMIN_MAIL_HOST_NAMES);
            for (int i = 0; i < mailHostNames.length; ++i) {
                if (!mx.equalsIgnoreCase(mailHostNames[i])) continue;
                return true;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return false;
    }

    public boolean isAutoLogin() throws SystemException {
        return PrefsPropsUtil.getBoolean(this.getCompanyId(), "company.security.auto.login", PropsValues.COMPANY_SECURITY_AUTO_LOGIN);
    }

    public boolean isCommunityLogo() throws SystemException {
        return PrefsPropsUtil.getBoolean(this.getCompanyId(), "company.security.community.logo", PropsValues.COMPANY_SECURITY_COMMUNITY_LOGO);
    }

    public boolean isSendPassword() throws SystemException {
        return PrefsPropsUtil.getBoolean(this.getCompanyId(), "company.security.send.password", PropsValues.COMPANY_SECURITY_SEND_PASSWORD);
    }

    public boolean isStrangers() throws SystemException {
        return PrefsPropsUtil.getBoolean(this.getCompanyId(), "company.security.strangers", PropsValues.COMPANY_SECURITY_STRANGERS);
    }

    public boolean isStrangersVerify() throws SystemException {
        return PrefsPropsUtil.getBoolean(this.getCompanyId(), "company.security.strangers.verify", PropsValues.COMPANY_SECURITY_STRANGERS_VERIFY);
    }

    public boolean isStrangersWithMx() throws SystemException {
        return PrefsPropsUtil.getBoolean(this.getCompanyId(), "company.security.strangers.with.mx", PropsValues.COMPANY_SECURITY_STRANGERS_WITH_MX);
    }

    public void setKey(String key) {
        this._keyObj = null;
        super.setKey(key);
    }

    public void setKeyObj(Key keyObj) {
        this._keyObj = keyObj;
        super.setKey(Base64.objectToString((Object)keyObj));
    }
}

