/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.GroupConstants;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.model.impl.GroupModelImpl;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.UserGroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupImpl
extends GroupModelImpl
implements Group {
    private static Log _log = LogFactoryUtil.getLog(GroupImpl.class);
    private Group _stagingGroup;
    private Group _liveGroup;
    private UnicodeProperties _typeSettingsProperties = null;

    public boolean isCommunity() {
        return this.hasClassName(Group.class);
    }

    public boolean isLayout() {
        return this.hasClassName(Layout.class);
    }

    public boolean isOrganization() {
        return this.hasClassName(Organization.class);
    }

    public boolean isUser() {
        return this.hasClassName(User.class);
    }

    public boolean isUserGroup() {
        return this.hasClassName(UserGroup.class);
    }

    public Group getLiveGroup() {
        if (!this.isStagingGroup()) {
            return null;
        }
        try {
            if (this._liveGroup == null) {
                this._liveGroup = GroupLocalServiceUtil.getGroup((long)this.getLiveGroupId());
            }
            return this._liveGroup;
        }
        catch (Exception e) {
            _log.error((Object)("Error getting live group for " + this.getLiveGroupId()), (Throwable)e);
            return null;
        }
    }

    public Group getStagingGroup() {
        if (this.isStagingGroup()) {
            return null;
        }
        try {
            if (this._stagingGroup == null) {
                this._stagingGroup = GroupLocalServiceUtil.getStagingGroup((long)this.getGroupId());
            }
            return this._stagingGroup;
        }
        catch (Exception e) {
            _log.error((Object)("Error getting staging group for " + this.getGroupId()), (Throwable)e);
            return null;
        }
    }

    public boolean hasStagingGroup() {
        if (this.isStagingGroup()) {
            return false;
        }
        if (this._stagingGroup != null) {
            return true;
        }
        try {
            return GroupLocalServiceUtil.hasStagingGroup((long)this.getGroupId());
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isStagingGroup() {
        return this.getLiveGroupId() != 0L;
    }

    public String getDescriptiveName() {
        String name = this.getName();
        try {
            if (this.isLayout()) {
                Layout layout = LayoutLocalServiceUtil.getLayout((long)this.getClassPK());
                name = layout.getName(LocaleUtil.getDefault());
            } else if (this.isOrganization()) {
                long organizationId = this.getClassPK();
                Organization organization = OrganizationLocalServiceUtil.getOrganization((long)organizationId);
                name = organization.getName();
            } else if (this.isUser()) {
                long userId = this.getClassPK();
                User user = UserLocalServiceUtil.getUserById((long)userId);
                name = user.getFullName();
            } else if (this.isUserGroup()) {
                long userGroupId = this.getClassPK();
                UserGroup userGroup = UserGroupLocalServiceUtil.getUserGroup((long)userGroupId);
                name = userGroup.getName();
            }
        }
        catch (Exception e) {
            _log.error((Object)("Error getting descriptive name for " + this.getGroupId()), (Throwable)e);
        }
        return name;
    }

    public String getTypeLabel() {
        return GroupConstants.getTypeLabel((int)this.getType());
    }

    @Override
    public String getTypeSettings() {
        if (this._typeSettingsProperties == null) {
            return super.getTypeSettings();
        }
        return this._typeSettingsProperties.toString();
    }

    @Override
    public void setTypeSettings(String typeSettings) {
        this._typeSettingsProperties = null;
        super.setTypeSettings(typeSettings);
    }

    public UnicodeProperties getTypeSettingsProperties() {
        if (this._typeSettingsProperties == null) {
            this._typeSettingsProperties = new UnicodeProperties(true);
            try {
                this._typeSettingsProperties.load(super.getTypeSettings());
            }
            catch (IOException ioe) {
                _log.error((Object)ioe, (Throwable)ioe);
            }
        }
        return this._typeSettingsProperties;
    }

    public void setTypeSettingsProperties(UnicodeProperties typeSettingsProperties) {
        this._typeSettingsProperties = typeSettingsProperties;
        super.setTypeSettings(this._typeSettingsProperties.toString());
    }

    public String getTypeSettingsProperty(String key) {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        return typeSettingsProperties.getProperty(key);
    }

    public String getPathFriendlyURL(boolean privateLayout, ThemeDisplay themeDisplay) {
        if (privateLayout) {
            if (this.isUser()) {
                return themeDisplay.getPathFriendlyURLPrivateUser();
            }
            return themeDisplay.getPathFriendlyURLPrivateGroup();
        }
        return themeDisplay.getPathFriendlyURLPublic();
    }

    public long getDefaultPrivatePlid() {
        return this.getDefaultPlid(true);
    }

    public int getPrivateLayoutsPageCount() {
        try {
            LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)this.getGroupId(), (boolean)true);
            return layoutSet.getPageCount();
        }
        catch (Exception e) {
            _log.error((Throwable)e);
            return 0;
        }
    }

    public boolean hasPrivateLayouts() {
        return this.getPrivateLayoutsPageCount() > 0;
    }

    public long getDefaultPublicPlid() {
        return this.getDefaultPlid(false);
    }

    public int getPublicLayoutsPageCount() {
        try {
            LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)this.getGroupId(), (boolean)false);
            return layoutSet.getPageCount();
        }
        catch (Exception e) {
            _log.error((Throwable)e);
            return 0;
        }
    }

    public boolean hasPublicLayouts() {
        return this.getPublicLayoutsPageCount() > 0;
    }

    public boolean isWorkflowEnabled() {
        return GetterUtil.getBoolean((String)this.getTypeSettingsProperty("workflowEnabled"));
    }

    public int getWorkflowStages() {
        return GetterUtil.getInteger((String)this.getTypeSettingsProperty("workflowStages"), (int)PropsValues.TASKS_DEFAULT_STAGES);
    }

    public String getWorkflowRoleNames() {
        return GetterUtil.getString((String)this.getTypeSettingsProperty("workflowRoleNames"), (String)PropsValues.TASKS_DEFAULT_ROLE_NAMES);
    }

    protected long getDefaultPlid(boolean privateLayout) {
        block3: {
            try {
                List layouts = LayoutLocalServiceUtil.getLayouts((long)this.getGroupId(), (boolean)privateLayout, (long)0L, (int)0, (int)1);
                if (layouts.size() > 0) {
                    Layout layout = (Layout)layouts.get(0);
                    return layout.getPlid();
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)e.getMessage());
            }
        }
        return 0L;
    }

    protected boolean hasClassName(Class<?> classObj) {
        long classNameId = this.getClassNameId();
        return classNameId == PortalUtil.getClassNameId(classObj);
    }
}

