/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.job.Scheduler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.poller.PollerProcessor;
import com.liferay.portal.kernel.pop.MessageListener;
import com.liferay.portal.kernel.portlet.ConfigurationAction;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.portlet.PortletLayoutListener;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.OpenSearch;
import com.liferay.portal.kernel.servlet.URLEncoder;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.lar.PortletDataHandler;
import com.liferay.portal.model.PluginSetting;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.PortletFilter;
import com.liferay.portal.model.PortletInfo;
import com.liferay.portal.model.PublicRenderParameter;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.PortletModelImpl;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.webdav.WebDAVStorage;
import com.liferay.portlet.ControlPanelEntry;
import com.liferay.portlet.PortletBagImpl;
import com.liferay.portlet.PortletQNameUtil;
import com.liferay.portlet.social.model.SocialActivityInterpreter;
import com.liferay.portlet.social.model.SocialRequestInterpreter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletImpl
extends PortletModelImpl
implements Portlet {
    private static Log _log = LogFactoryUtil.getLog(PortletImpl.class);
    private PluginPackage _pluginPackage;
    private PluginSetting _defaultPluginSetting;
    private long _timestamp;
    private String _icon;
    private String _virtualPath;
    private String _strutsPath;
    private String _portletName;
    private String _displayName;
    private String _portletClass;
    private String _configurationActionClass;
    private String _indexerClass;
    private String _openSearchClass;
    private String _schedulerClass;
    private String _portletURLClass;
    private String _friendlyURLMapperClass;
    private String _urlEncoderClass;
    private String _portletDataHandlerClass;
    private String _portletLayoutListenerClass;
    private String _pollerProcessorClass;
    private String _popMessageListenerClass;
    private String _socialActivityInterpreterClass;
    private String _socialRequestInterpreterClass;
    private String _webDAVStorageToken;
    private String _webDAVStorageClass;
    private String _defaultPreferences;
    private String _preferencesValidator;
    private boolean _preferencesCompanyWide;
    private boolean _preferencesUniquePerLayout = true;
    private boolean _preferencesOwnedByGroup = true;
    private String _controlPanelEntryCategory;
    private double _controlPanelEntryWeight = 100.0;
    private String _controlPanelEntryClass;
    private boolean _useDefaultTemplate = true;
    private boolean _showPortletAccessDenied = PropsValues.LAYOUT_SHOW_PORTLET_ACCESS_DENIED;
    private boolean _showPortletInactive = PropsValues.LAYOUT_SHOW_PORTLET_INACTIVE;
    private boolean _actionURLRedirect;
    private boolean _restoreCurrentView = true;
    private boolean _maximizeEdit;
    private boolean _maximizeHelp;
    private boolean _popUpPrint = true;
    private boolean _layoutCacheable;
    private boolean _instanceable;
    private boolean _scopeable;
    private String _userPrincipalStrategy = "userId";
    private boolean _privateRequestAttributes = true;
    private boolean _privateSessionAttributes = true;
    private int _renderWeight = 1;
    private boolean _ajaxable = true;
    private List<String> _headerPortalCss;
    private List<String> _headerPortletCss;
    private List<String> _headerPortalJavaScript;
    private List<String> _headerPortletJavaScript;
    private List<String> _footerPortalCss;
    private List<String> _footerPortletCss;
    private List<String> _footerPortalJavaScript;
    private List<String> _footerPortletJavaScript;
    private String _cssClassWrapper = "";
    private String _facebookIntegration = "iframe";
    private boolean _addDefaultResource;
    private String[] _rolesArray;
    private Set<String> _unlinkedRoles;
    private Map<String, String> _roleMappers;
    private boolean _system;
    private boolean _include = true;
    private Map<String, String> _initParams;
    private Integer _expCache;
    private Map<String, Set<String>> _portletModes;
    private Map<String, Set<String>> _windowStates;
    private Set<String> _supportedLocales;
    private String _resourceBundle;
    private PortletInfo _portletInfo;
    private Map<String, PortletFilter> _portletFilters;
    private Set<QName> _processingEvents = new HashSet<QName>();
    private Map<String, QName> _processingEventsByQName = new HashMap<String, QName>();
    private Set<QName> _publishingEvents = new HashSet<QName>();
    private Set<PublicRenderParameter> _publicRenderParameters = new HashSet<PublicRenderParameter>();
    private Map<String, PublicRenderParameter> _publicRenderParametersByIdentifier = new HashMap<String, PublicRenderParameter>();
    private Map<String, PublicRenderParameter> _publicRenderParametersByQName = new HashMap<String, PublicRenderParameter>();
    private PortletApp _portletApp;
    private Map<String, Portlet> _clonedInstances;
    private boolean _staticPortlet;
    private boolean _staticPortletStart;
    private boolean _undeployedPortlet = false;

    public PortletImpl() {
    }

    public PortletImpl(long companyId, String portletId) {
        this.setCompanyId(companyId);
        this.setPortletId(portletId);
        this.setStrutsPath(portletId);
        this.setActive(true);
        this._headerPortalCss = new ArrayList<String>();
        this._headerPortletCss = new ArrayList<String>();
        this._headerPortalJavaScript = new ArrayList<String>();
        this._headerPortletJavaScript = new ArrayList<String>();
        this._footerPortalCss = new ArrayList<String>();
        this._footerPortletCss = new ArrayList<String>();
        this._footerPortalJavaScript = new ArrayList<String>();
        this._footerPortletJavaScript = new ArrayList<String>();
        this._unlinkedRoles = new HashSet<String>();
        this._roleMappers = new LinkedHashMap<String, String>();
        this._initParams = new HashMap<String, String>();
        this._portletModes = new HashMap<String, Set<String>>();
        this._windowStates = new HashMap<String, Set<String>>();
        this._supportedLocales = new HashSet<String>();
        this._portletFilters = new LinkedHashMap<String, PortletFilter>();
        this._processingEvents = new HashSet<QName>();
        this._publishingEvents = new HashSet<QName>();
        this._publicRenderParameters = new HashSet<PublicRenderParameter>();
    }

    public PortletImpl(String portletId, PluginPackage pluginPackage, PluginSetting pluginSetting, long companyId, long timestamp, String icon, String virtualPath, String strutsPath, String portletName, String displayName, String portletClass, String configurationActionClass, String indexerClass, String openSearchClass, String schedulerClass, String portletURLClass, String friendlyURLMapperClass, String urlEncoderClass, String portletDataHandlerClass, String portletLayoutListenerClass, String pollerProcessorClass, String popMessageListenerClass, String socialActivityInterpreterClass, String socialRequestInterpreterClass, String webDAVStorageToken, String webDAVStorageClass, String controlPanelEntryCategory, double controlPanelEntryWeight, String controlPanelClass, String defaultPreferences, String preferencesValidator, boolean preferencesCompanyWide, boolean preferencesUniquePerLayout, boolean preferencesOwnedByGroup, boolean useDefaultTemplate, boolean showPortletAccessDenied, boolean showPortletInactive, boolean actionURLRedirect, boolean restoreCurrentView, boolean maximizeEdit, boolean maximizeHelp, boolean popUpPrint, boolean layoutCacheable, boolean instanceable, boolean scopeable, String userPrincipalStrategy, boolean privateRequestAttributes, boolean privateSessionAttributes, int renderWeight, boolean ajaxable, List<String> headerPortalCss, List<String> headerPortletCss, List<String> headerPortalJavaScript, List<String> headerPortletJavaScript, List<String> footerPortalCss, List<String> footerPortletCss, List<String> footerPortalJavaScript, List<String> footerPortletJavaScript, String cssClassWrapper, String facebookIntegration, boolean addDefaultResource, String roles, Set<String> unlinkedRoles, Map<String, String> roleMappers, boolean system, boolean active, boolean include, Map<String, String> initParams, Integer expCache, Map<String, Set<String>> portletModes, Map<String, Set<String>> windowStates, Set<String> supportedLocales, String resourceBundle, PortletInfo portletInfo, Map<String, PortletFilter> portletFilters, Set<QName> processingEvents, Set<QName> publishingEvents, Set<PublicRenderParameter> publicRenderParameters, PortletApp portletApp) {
        this.setPortletId(portletId);
        this._pluginPackage = pluginPackage;
        this._defaultPluginSetting = pluginSetting;
        this.setCompanyId(companyId);
        this._timestamp = timestamp;
        this._icon = icon;
        this._virtualPath = virtualPath;
        this._strutsPath = strutsPath;
        this._portletName = portletName;
        this._displayName = displayName;
        this._portletClass = portletClass;
        this._configurationActionClass = configurationActionClass;
        this._indexerClass = indexerClass;
        this._openSearchClass = openSearchClass;
        this._schedulerClass = schedulerClass;
        this._portletURLClass = portletURLClass;
        this._friendlyURLMapperClass = friendlyURLMapperClass;
        this._urlEncoderClass = urlEncoderClass;
        this._portletDataHandlerClass = portletDataHandlerClass;
        this._portletLayoutListenerClass = portletLayoutListenerClass;
        this._pollerProcessorClass = pollerProcessorClass;
        this._popMessageListenerClass = popMessageListenerClass;
        this._socialActivityInterpreterClass = socialActivityInterpreterClass;
        this._socialRequestInterpreterClass = socialRequestInterpreterClass;
        this._webDAVStorageToken = webDAVStorageToken;
        this._webDAVStorageClass = webDAVStorageClass;
        this._controlPanelEntryCategory = controlPanelEntryCategory;
        this._controlPanelEntryWeight = controlPanelEntryWeight;
        this._controlPanelEntryClass = controlPanelClass;
        this._defaultPreferences = defaultPreferences;
        this._preferencesValidator = preferencesValidator;
        this._preferencesCompanyWide = preferencesCompanyWide;
        this._preferencesUniquePerLayout = preferencesUniquePerLayout;
        this._preferencesOwnedByGroup = preferencesOwnedByGroup;
        this._useDefaultTemplate = useDefaultTemplate;
        this._showPortletAccessDenied = showPortletAccessDenied;
        this._showPortletInactive = showPortletInactive;
        this._actionURLRedirect = actionURLRedirect;
        this._restoreCurrentView = restoreCurrentView;
        this._maximizeEdit = maximizeEdit;
        this._maximizeHelp = maximizeHelp;
        this._popUpPrint = popUpPrint;
        this._layoutCacheable = layoutCacheable;
        this._instanceable = instanceable;
        this._scopeable = scopeable;
        this._userPrincipalStrategy = userPrincipalStrategy;
        this._privateRequestAttributes = privateRequestAttributes;
        this._privateSessionAttributes = privateSessionAttributes;
        this._renderWeight = renderWeight;
        this._ajaxable = ajaxable;
        this._headerPortalCss = headerPortalCss;
        this._headerPortletCss = headerPortletCss;
        this._headerPortalJavaScript = headerPortalJavaScript;
        this._headerPortletJavaScript = headerPortletJavaScript;
        this._footerPortalCss = footerPortalCss;
        this._footerPortletCss = footerPortletCss;
        this._footerPortalJavaScript = footerPortalJavaScript;
        this._footerPortletJavaScript = footerPortletJavaScript;
        this._cssClassWrapper = cssClassWrapper;
        this._facebookIntegration = facebookIntegration;
        this._scopeable = scopeable;
        this._addDefaultResource = addDefaultResource;
        this.setRoles(roles);
        this._unlinkedRoles = unlinkedRoles;
        this._roleMappers = roleMappers;
        this._system = system;
        this.setActive(active);
        this._include = include;
        this._initParams = initParams;
        this._expCache = expCache;
        this._portletModes = portletModes;
        this._windowStates = windowStates;
        this._supportedLocales = supportedLocales;
        this._resourceBundle = resourceBundle;
        this._portletInfo = portletInfo;
        this._portletFilters = portletFilters;
        this.setProcessingEvents(processingEvents);
        this.setPublishingEvents(publishingEvents);
        this.setPublicRenderParameters(publicRenderParameters);
        this._portletApp = portletApp;
        if (this._instanceable) {
            this._clonedInstances = new Hashtable<String, Portlet>();
        }
    }

    public String getRootPortletId() {
        return PortletConstants.getRootPortletId((String)this.getPortletId());
    }

    public String getInstanceId() {
        return PortletConstants.getInstanceId((String)this.getPortletId());
    }

    public String getPluginId() {
        return this.getRootPortletId();
    }

    public String getPluginType() {
        return "portlet";
    }

    public PluginPackage getPluginPackage() {
        return this._pluginPackage;
    }

    public void setPluginPackage(PluginPackage pluginPackage) {
        this._pluginPackage = pluginPackage;
    }

    public PluginSetting getDefaultPluginSetting() {
        return this._defaultPluginSetting;
    }

    public void setDefaultPluginSetting(PluginSetting pluginSetting) {
        this._defaultPluginSetting = pluginSetting;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public void setTimestamp(long timestamp) {
        this._timestamp = timestamp;
    }

    public String getIcon() {
        return this._icon;
    }

    public void setIcon(String icon) {
        this._icon = icon;
    }

    public String getVirtualPath() {
        return this._virtualPath;
    }

    public void setVirtualPath(String virtualPath) {
        if (this._portletApp.isWARFile() && Validator.isNull((String)virtualPath)) {
            virtualPath = PropsValues.PORTLET_VIRTUAL_PATH;
        }
        this._virtualPath = virtualPath;
    }

    public String getStrutsPath() {
        return this._strutsPath;
    }

    public void setStrutsPath(String strutsPath) {
        this._strutsPath = strutsPath;
    }

    public String getPortletName() {
        return this._portletName;
    }

    public void setPortletName(String portletName) {
        this._portletName = portletName;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public String getPortletClass() {
        return this._portletClass;
    }

    public void setPortletClass(String portletClass) {
        this._portletClass = portletClass;
    }

    public String getConfigurationActionClass() {
        return this._configurationActionClass;
    }

    public void setConfigurationActionClass(String configurationActionClass) {
        this._configurationActionClass = configurationActionClass;
    }

    public ConfigurationAction getConfigurationActionInstance() {
        if (Validator.isNull((String)this.getConfigurationActionClass())) {
            return null;
        }
        if (this._portletApp.isWARFile()) {
            PortletBag portletBag = PortletBagPool.get((String)this.getRootPortletId());
            return portletBag.getConfigurationActionInstance();
        }
        return (ConfigurationAction)InstancePool.get((String)this.getConfigurationActionClass());
    }

    public String getIndexerClass() {
        return this._indexerClass;
    }

    public void setIndexerClass(String indexerClass) {
        this._indexerClass = indexerClass;
    }

    public Indexer getIndexerInstance() {
        if (Validator.isNull((String)this.getIndexerClass())) {
            return null;
        }
        if (this._portletApp.isWARFile()) {
            PortletBag portletBag = PortletBagPool.get((String)this.getRootPortletId());
            return portletBag.getIndexerInstance();
        }
        return (Indexer)InstancePool.get((String)this.getIndexerClass());
    }

    public String getOpenSearchClass() {
        return this._openSearchClass;
    }

    public void setOpenSearchClass(String openSearchClass) {
        this._openSearchClass = openSearchClass;
    }

    public OpenSearch getOpenSearchInstance() {
        if (Validator.isNull((String)this.getOpenSearchClass())) {
            return null;
        }
        if (this._portletApp.isWARFile()) {
            PortletBag portletBag = PortletBagPool.get((String)this.getRootPortletId());
            return portletBag.getOpenSearchInstance();
        }
        return (OpenSearch)InstancePool.get((String)this.getOpenSearchClass());
    }

    public String getSchedulerClass() {
        return this._schedulerClass;
    }

    public void setSchedulerClass(String schedulerClass) {
        this._schedulerClass = schedulerClass;
    }

    public Scheduler getSchedulerInstance() {
        if (Validator.isNull((String)this.getSchedulerClass())) {
            return null;
        }
        if (this._portletApp.isWARFile()) {
            PortletBag portletBag = PortletBagPool.get((String)this.getRootPortletId());
            return portletBag.getSchedulerInstance();
        }
        return (Scheduler)InstancePool.get((String)this.getSchedulerClass());
    }

    public String getPortletURLClass() {
        return this._portletURLClass;
    }

    public void setPortletURLClass(String portletURLClass) {
        this._portletURLClass = portletURLClass;
    }

    public String getFriendlyURLMapperClass() {
        return this._friendlyURLMapperClass;
    }

    public void setFriendlyURLMapperClass(String friendlyURLMapperClass) {
        this._friendlyURLMapperClass = friendlyURLMapperClass;
    }

    public FriendlyURLMapper getFriendlyURLMapperInstance() {
        if (Validator.isNull((String)this.getFriendlyURLMapperClass())) {
            return null;
        }
        if (this._portletApp.isWARFile()) {
            PortletBag portletBag = PortletBagPool.get((String)this.getRootPortletId());
            return portletBag.getFriendlyURLMapperInstance();
        }
        return (FriendlyURLMapper)InstancePool.get((String)this.getFriendlyURLMapperClass());
    }

    public String getURLEncoderClass() {
        return this._urlEncoderClass;
    }

    public void setURLEncoderClass(String urlEncoderClass) {
        this._urlEncoderClass = urlEncoderClass;
    }

    public URLEncoder getURLEncoderInstance() {
        if (Validator.isNull((String)this.getURLEncoderClass())) {
            return null;
        }
        if (this._portletApp.isWARFile()) {
            PortletBag portletBag = PortletBagPool.get((String)this.getRootPortletId());
            return portletBag.getURLEncoderInstance();
        }
        return (URLEncoder)InstancePool.get((String)this.getURLEncoderClass());
    }

    public String getPortletDataHandlerClass() {
        return this._portletDataHandlerClass;
    }

    public void setPortletDataHandlerClass(String portletDataHandlerClass) {
        this._portletDataHandlerClass = portletDataHandlerClass;
    }

    public PortletDataHandler getPortletDataHandlerInstance() {
        if (Validator.isNull((String)this.getPortletDataHandlerClass())) {
            return null;
        }
        if (this._portletApp.isWARFile()) {
            PortletBagImpl portletBagImpl = (PortletBagImpl)PortletBagPool.get((String)this.getRootPortletId());
            return portletBagImpl.getPortletDataHandlerInstance();
        }
        return (PortletDataHandler)InstancePool.get((String)this.getPortletDataHandlerClass());
    }

    public PortletLayoutListener getPortletLayoutListener() {
        if (Validator.isNull((String)this.getPortletLayoutListenerClass())) {
            return null;
        }
        return (PortletLayoutListener)InstancePool.get((String)this.getPortletLayoutListenerClass());
    }

    public String getPortletLayoutListenerClass() {
        return this._portletLayoutListenerClass;
    }

    public void setPortletLayoutListenerClass(String portletLayoutListenerClass) {
        this._portletLayoutListenerClass = portletLayoutListenerClass;
    }

    public PortletLayoutListener getPortletLayoutListenerInstance() {
        if (Validator.isNull((String)this.getPortletLayoutListenerClass())) {
            return null;
        }
        if (this._portletApp.isWARFile()) {
            PortletBag portletBag = PortletBagPool.get((String)this.getRootPortletId());
            return portletBag.getPortletLayoutListenerInstance();
        }
        return (PortletLayoutListener)InstancePool.get((String)this.getPortletLayoutListenerClass());
    }

    public String getPollerProcessorClass() {
        return this._pollerProcessorClass;
    }

    public void setPollerProcessorClass(String pollerProcessorClass) {
        this._pollerProcessorClass = pollerProcessorClass;
    }

    public PollerProcessor getPollerProcessorInstance() {
        if (Validator.isNull((String)this.getPollerProcessorClass())) {
            return null;
        }
        if (this._portletApp.isWARFile()) {
            PortletBag portletBag = PortletBagPool.get((String)this.getRootPortletId());
            return portletBag.getPollerProcessorInstance();
        }
        return (PollerProcessor)InstancePool.get((String)this.getPollerProcessorClass());
    }

    public String getPopMessageListenerClass() {
        return this._popMessageListenerClass;
    }

    public void setPopMessageListenerClass(String popMessageListenerClass) {
        this._popMessageListenerClass = popMessageListenerClass;
    }

    public MessageListener getPopMessageListenerInstance() {
        if (Validator.isNull((String)this.getPopMessageListenerClass())) {
            return null;
        }
        if (this._portletApp.isWARFile()) {
            PortletBag portletBag = PortletBagPool.get((String)this.getRootPortletId());
            return portletBag.getPopMessageListenerInstance();
        }
        return (MessageListener)InstancePool.get((String)this.getPopMessageListenerClass());
    }

    public String getSocialActivityInterpreterClass() {
        return this._socialActivityInterpreterClass;
    }

    public void setSocialActivityInterpreterClass(String socialActivityInterpreterClass) {
        this._socialActivityInterpreterClass = socialActivityInterpreterClass;
    }

    public SocialActivityInterpreter getSocialActivityInterpreterInstance() {
        if (Validator.isNull((String)this.getSocialActivityInterpreterClass())) {
            return null;
        }
        if (this._portletApp.isWARFile()) {
            PortletBagImpl portletBagImpl = (PortletBagImpl)PortletBagPool.get((String)this.getRootPortletId());
            return portletBagImpl.getSocialActivityInterpreterInstance();
        }
        return (SocialActivityInterpreter)InstancePool.get((String)this.getSocialActivityInterpreterClass());
    }

    public String getSocialRequestInterpreterClass() {
        return this._socialRequestInterpreterClass;
    }

    public void setSocialRequestInterpreterClass(String socialRequestInterpreterClass) {
        this._socialRequestInterpreterClass = socialRequestInterpreterClass;
    }

    public SocialRequestInterpreter getSocialRequestInterpreterInstance() {
        if (Validator.isNull((String)this.getSocialRequestInterpreterClass())) {
            return null;
        }
        if (this._portletApp.isWARFile()) {
            PortletBagImpl portletBagImpl = (PortletBagImpl)PortletBagPool.get((String)this.getRootPortletId());
            return portletBagImpl.getSocialRequestInterpreterInstance();
        }
        return (SocialRequestInterpreter)InstancePool.get((String)this.getSocialRequestInterpreterClass());
    }

    public String getWebDAVStorageToken() {
        return this._webDAVStorageToken;
    }

    public void setWebDAVStorageToken(String webDAVStorageToken) {
        this._webDAVStorageToken = webDAVStorageToken;
    }

    public String getWebDAVStorageClass() {
        return this._webDAVStorageClass;
    }

    public void setWebDAVStorageClass(String webDAVStorageClass) {
        this._webDAVStorageClass = webDAVStorageClass;
    }

    public WebDAVStorage getWebDAVStorageInstance() {
        if (Validator.isNull((String)this.getWebDAVStorageClass())) {
            return null;
        }
        if (this._portletApp.isWARFile()) {
            PortletBagImpl portletBagImpl = (PortletBagImpl)PortletBagPool.get((String)this.getRootPortletId());
            return portletBagImpl.getWebDAVStorageInstance();
        }
        return (WebDAVStorage)InstancePool.get((String)this.getWebDAVStorageClass());
    }

    public String getControlPanelEntryCategory() {
        return this._controlPanelEntryCategory;
    }

    public void setControlPanelEntryCategory(String controlPanelEntryCategory) {
        this._controlPanelEntryCategory = controlPanelEntryCategory;
    }

    public double getControlPanelEntryWeight() {
        return this._controlPanelEntryWeight;
    }

    public void setControlPanelEntryWeight(double controlPanelEntryWeight) {
        this._controlPanelEntryWeight = controlPanelEntryWeight;
    }

    public String getControlPanelEntryClass() {
        return this._controlPanelEntryClass;
    }

    public void setControlPanelEntryClass(String controlPanelEntryClass) {
        this._controlPanelEntryClass = controlPanelEntryClass;
    }

    public ControlPanelEntry getControlPanelEntryInstance() {
        if (Validator.isNull((String)this.getControlPanelEntryClass())) {
            return null;
        }
        if (this._portletApp.isWARFile()) {
            PortletBagImpl portletBagImpl = (PortletBagImpl)PortletBagPool.get((String)this.getRootPortletId());
            return portletBagImpl.getControlPanelEntryInstance();
        }
        return (ControlPanelEntry)InstancePool.get((String)this.getControlPanelEntryClass());
    }

    public String getDefaultPreferences() {
        if (Validator.isNull((String)this._defaultPreferences)) {
            return "<portlet-preferences />";
        }
        return this._defaultPreferences;
    }

    public void setDefaultPreferences(String defaultPreferences) {
        this._defaultPreferences = defaultPreferences;
    }

    public String getPreferencesValidator() {
        return this._preferencesValidator;
    }

    public void setPreferencesValidator(String preferencesValidator) {
        this._preferencesValidator = preferencesValidator != null ? preferencesValidator.trim() : null;
    }

    public boolean getPreferencesCompanyWide() {
        return this._preferencesCompanyWide;
    }

    public boolean isPreferencesCompanyWide() {
        return this._preferencesCompanyWide;
    }

    public void setPreferencesCompanyWide(boolean preferencesCompanyWide) {
        this._preferencesCompanyWide = preferencesCompanyWide;
    }

    public boolean getPreferencesUniquePerLayout() {
        return this._preferencesUniquePerLayout;
    }

    public boolean isPreferencesUniquePerLayout() {
        return this._preferencesUniquePerLayout;
    }

    public void setPreferencesUniquePerLayout(boolean preferencesUniquePerLayout) {
        this._preferencesUniquePerLayout = preferencesUniquePerLayout;
    }

    public boolean getPreferencesOwnedByGroup() {
        return this._preferencesOwnedByGroup;
    }

    public boolean isPreferencesOwnedByGroup() {
        return this._preferencesOwnedByGroup;
    }

    public void setPreferencesOwnedByGroup(boolean preferencesOwnedByGroup) {
        this._preferencesOwnedByGroup = preferencesOwnedByGroup;
    }

    public boolean getUseDefaultTemplate() {
        return this._useDefaultTemplate;
    }

    public boolean isUseDefaultTemplate() {
        return this._useDefaultTemplate;
    }

    public void setUseDefaultTemplate(boolean useDefaultTemplate) {
        this._useDefaultTemplate = useDefaultTemplate;
    }

    public boolean getShowPortletAccessDenied() {
        return this._showPortletAccessDenied;
    }

    public boolean isShowPortletAccessDenied() {
        return this._showPortletAccessDenied;
    }

    public void setShowPortletAccessDenied(boolean showPortletAccessDenied) {
        this._showPortletAccessDenied = showPortletAccessDenied;
    }

    public boolean getShowPortletInactive() {
        return this._showPortletInactive;
    }

    public boolean isShowPortletInactive() {
        return this._showPortletInactive;
    }

    public void setShowPortletInactive(boolean showPortletInactive) {
        this._showPortletInactive = showPortletInactive;
    }

    public boolean getActionURLRedirect() {
        return this._actionURLRedirect;
    }

    public boolean isActionURLRedirect() {
        return this._actionURLRedirect;
    }

    public void setActionURLRedirect(boolean actionURLRedirect) {
        this._actionURLRedirect = actionURLRedirect;
    }

    public boolean getRestoreCurrentView() {
        return this._restoreCurrentView;
    }

    public boolean isRestoreCurrentView() {
        return this._restoreCurrentView;
    }

    public void setRestoreCurrentView(boolean restoreCurrentView) {
        this._restoreCurrentView = restoreCurrentView;
    }

    public boolean getMaximizeEdit() {
        return this._maximizeEdit;
    }

    public boolean isMaximizeEdit() {
        return this._maximizeEdit;
    }

    public void setMaximizeEdit(boolean maximizeEdit) {
        this._maximizeEdit = maximizeEdit;
    }

    public boolean getMaximizeHelp() {
        return this._maximizeHelp;
    }

    public boolean isMaximizeHelp() {
        return this._maximizeHelp;
    }

    public void setMaximizeHelp(boolean maximizeHelp) {
        this._maximizeHelp = maximizeHelp;
    }

    public boolean getPopUpPrint() {
        return this._popUpPrint;
    }

    public boolean isPopUpPrint() {
        return this._popUpPrint;
    }

    public void setPopUpPrint(boolean popUpPrint) {
        this._popUpPrint = popUpPrint;
    }

    public boolean getLayoutCacheable() {
        return this._layoutCacheable;
    }

    public boolean isLayoutCacheable() {
        return this._layoutCacheable;
    }

    public void setLayoutCacheable(boolean layoutCacheable) {
        this._layoutCacheable = layoutCacheable;
    }

    public boolean getInstanceable() {
        return this._instanceable;
    }

    public boolean isInstanceable() {
        return this._instanceable;
    }

    public void setInstanceable(boolean instanceable) {
        this._instanceable = instanceable;
    }

    public boolean getScopeable() {
        return this._scopeable;
    }

    public boolean isScopeable() {
        return this._scopeable;
    }

    public void setScopeable(boolean scopeable) {
        this._scopeable = scopeable;
    }

    public String getUserPrincipalStrategy() {
        return this._userPrincipalStrategy;
    }

    public void setUserPrincipalStrategy(String userPrincipalStrategy) {
        if (Validator.isNotNull((String)userPrincipalStrategy)) {
            this._userPrincipalStrategy = userPrincipalStrategy;
        }
    }

    public boolean getPrivateRequestAttributes() {
        return this._privateRequestAttributes;
    }

    public boolean isPrivateRequestAttributes() {
        return this._privateRequestAttributes;
    }

    public void setPrivateRequestAttributes(boolean privateRequestAttributes) {
        this._privateRequestAttributes = privateRequestAttributes;
    }

    public boolean getPrivateSessionAttributes() {
        return this._privateSessionAttributes;
    }

    public boolean isPrivateSessionAttributes() {
        return this._privateSessionAttributes;
    }

    public void setPrivateSessionAttributes(boolean privateSessionAttributes) {
        this._privateSessionAttributes = privateSessionAttributes;
    }

    public int getRenderWeight() {
        return this._renderWeight;
    }

    public void setRenderWeight(int renderWeight) {
        this._renderWeight = renderWeight;
    }

    public boolean getAjaxable() {
        return this._ajaxable;
    }

    public boolean isAjaxable() {
        return this._ajaxable;
    }

    public void setAjaxable(boolean ajaxable) {
        this._ajaxable = ajaxable;
    }

    public List<String> getHeaderPortalCss() {
        return this._headerPortalCss;
    }

    public void setHeaderPortalCss(List<String> headerPortalCss) {
        this._headerPortalCss = headerPortalCss;
    }

    public List<String> getHeaderPortletCss() {
        return this._headerPortletCss;
    }

    public void setHeaderPortletCss(List<String> headerPortletCss) {
        this._headerPortletCss = headerPortletCss;
    }

    public List<String> getHeaderPortalJavaScript() {
        return this._headerPortalJavaScript;
    }

    public void setHeaderPortalJavaScript(List<String> headerPortalJavaScript) {
        this._headerPortalJavaScript = headerPortalJavaScript;
    }

    public List<String> getHeaderPortletJavaScript() {
        return this._headerPortletJavaScript;
    }

    public void setHeaderPortletJavaScript(List<String> headerPortletJavaScript) {
        this._headerPortletJavaScript = headerPortletJavaScript;
    }

    public List<String> getFooterPortalCss() {
        return this._footerPortalCss;
    }

    public void setFooterPortalCss(List<String> footerPortalCss) {
        this._footerPortalCss = footerPortalCss;
    }

    public List<String> getFooterPortletCss() {
        return this._footerPortletCss;
    }

    public void setFooterPortletCss(List<String> footerPortletCss) {
        this._footerPortletCss = footerPortletCss;
    }

    public List<String> getFooterPortalJavaScript() {
        return this._footerPortalJavaScript;
    }

    public void setFooterPortalJavaScript(List<String> footerPortalJavaScript) {
        this._footerPortalJavaScript = footerPortalJavaScript;
    }

    public List<String> getFooterPortletJavaScript() {
        return this._footerPortletJavaScript;
    }

    public void setFooterPortletJavaScript(List<String> footerPortletJavaScript) {
        this._footerPortletJavaScript = footerPortletJavaScript;
    }

    public String getCssClassWrapper() {
        return this._cssClassWrapper;
    }

    public void setCssClassWrapper(String cssClassWrapper) {
        this._cssClassWrapper = cssClassWrapper;
    }

    public String getFacebookIntegration() {
        return this._facebookIntegration;
    }

    public void setFacebookIntegration(String facebookIntegration) {
        if (Validator.isNotNull((String)facebookIntegration)) {
            this._facebookIntegration = facebookIntegration;
        }
    }

    public boolean getAddDefaultResource() {
        return this._addDefaultResource;
    }

    public boolean isAddDefaultResource() {
        return this._addDefaultResource;
    }

    public void setAddDefaultResource(boolean addDefaultResource) {
        this._addDefaultResource = addDefaultResource;
    }

    @Override
    public void setRoles(String roles) {
        this._rolesArray = StringUtil.split((String)roles);
        super.setRoles(roles);
    }

    public String[] getRolesArray() {
        return this._rolesArray;
    }

    public void setRolesArray(String[] rolesArray) {
        this._rolesArray = rolesArray;
        super.setRoles(StringUtil.merge((Object[])rolesArray));
    }

    public Set<String> getUnlinkedRoles() {
        return this._unlinkedRoles;
    }

    public void setUnlinkedRoles(Set<String> unlinkedRoles) {
        this._unlinkedRoles = unlinkedRoles;
    }

    public Map<String, String> getRoleMappers() {
        return this._roleMappers;
    }

    public void setRoleMappers(Map<String, String> roleMappers) {
        this._roleMappers = roleMappers;
    }

    public void linkRoles() {
        ArrayList<String> linkedRoles = new ArrayList<String>();
        for (String unlinkedRole : this._unlinkedRoles) {
            String roleLink = this._roleMappers.get(unlinkedRole);
            if (Validator.isNotNull((String)roleLink)) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Linking role for portlet [" + this.getPortletId() + "] with role-name [" + unlinkedRole + "] to role-link [" + roleLink + "]"));
                }
                linkedRoles.add(roleLink);
                continue;
            }
            _log.error((Object)("Unable to link role for portlet [" + this.getPortletId() + "] with role-name [" + unlinkedRole + "] because role-link is null"));
        }
        Object[] array = linkedRoles.toArray(new String[linkedRoles.size()]);
        Arrays.sort(array);
        this.setRolesArray((String[])array);
    }

    public boolean hasRoleWithName(String roleName) {
        if (this._rolesArray == null || this._rolesArray.length == 0) {
            return false;
        }
        for (int i = 0; i < this._rolesArray.length; ++i) {
            if (!this._rolesArray[i].equalsIgnoreCase(roleName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAddPortletPermission(long userId) {
        try {
            if (this._rolesArray == null || this._rolesArray.length == 0) {
                return true;
            }
            if (RoleLocalServiceUtil.hasUserRoles((long)userId, (long)this.getCompanyId(), (String[])this._rolesArray, (boolean)true)) {
                return true;
            }
            if (RoleLocalServiceUtil.hasUserRole((long)userId, (long)this.getCompanyId(), (String)"Administrator", (boolean)true)) {
                return true;
            }
            User user = UserLocalServiceUtil.getUserById((long)userId);
            if (user.isDefaultUser() && this.hasRoleWithName("Guest")) {
                return true;
            }
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
        return false;
    }

    public boolean getSystem() {
        return this._system;
    }

    public boolean isSystem() {
        return this._system;
    }

    public void setSystem(boolean system) {
        this._system = system;
    }

    public boolean getInclude() {
        return this._include;
    }

    public boolean isInclude() {
        return this._include;
    }

    public void setInclude(boolean include) {
        this._include = include;
    }

    public Map<String, String> getInitParams() {
        return this._initParams;
    }

    public void setInitParams(Map<String, String> initParams) {
        this._initParams = initParams;
    }

    public Integer getExpCache() {
        return this._expCache;
    }

    public void setExpCache(Integer expCache) {
        this._expCache = expCache;
    }

    public Map<String, Set<String>> getPortletModes() {
        return this._portletModes;
    }

    public void setPortletModes(Map<String, Set<String>> portletModes) {
        this._portletModes = portletModes;
    }

    public boolean hasPortletMode(String mimeType, PortletMode portletMode) {
        Set<String> mimeTypePortletModes;
        if (mimeType == null) {
            mimeType = "text/html";
        }
        if ((mimeTypePortletModes = this._portletModes.get(mimeType)) == null) {
            return false;
        }
        return mimeTypePortletModes.contains(portletMode.toString());
    }

    public Set<String> getAllPortletModes() {
        TreeSet<String> allPortletModes = new TreeSet<String>();
        for (Map.Entry<String, Set<String>> entry : this._portletModes.entrySet()) {
            Set<String> mimeTypePortletModes = entry.getValue();
            for (String portletMode : mimeTypePortletModes) {
                allPortletModes.add(portletMode);
            }
        }
        return allPortletModes;
    }

    public boolean hasMultipleMimeTypes() {
        return this._portletModes.size() > 1;
    }

    public Map<String, Set<String>> getWindowStates() {
        return this._windowStates;
    }

    public void setWindowStates(Map<String, Set<String>> windowStates) {
        this._windowStates = windowStates;
    }

    public boolean hasWindowState(String mimeType, WindowState windowState) {
        Set<String> mimeTypeWindowStates;
        if (mimeType == null) {
            mimeType = "text/html";
        }
        if ((mimeTypeWindowStates = this._windowStates.get(mimeType)) == null) {
            return false;
        }
        return mimeTypeWindowStates.contains(windowState.toString());
    }

    public Set<String> getAllWindowStates() {
        TreeSet<String> allWindowStates = new TreeSet<String>();
        for (Map.Entry<String, Set<String>> entry : this._windowStates.entrySet()) {
            Set<String> mimeTypeWindowStates = entry.getValue();
            for (String windowState : mimeTypeWindowStates) {
                allWindowStates.add(windowState);
            }
        }
        return allWindowStates;
    }

    public Set<String> getSupportedLocales() {
        return this._supportedLocales;
    }

    public void setSupportedLocales(Set<String> supportedLocales) {
        this._supportedLocales = supportedLocales;
    }

    public String getResourceBundle() {
        return this._resourceBundle;
    }

    public void setResourceBundle(String resourceBundle) {
        this._resourceBundle = resourceBundle;
    }

    public PortletInfo getPortletInfo() {
        return this._portletInfo;
    }

    public void setPortletInfo(PortletInfo portletInfo) {
        this._portletInfo = portletInfo;
    }

    public Map<String, PortletFilter> getPortletFilters() {
        return this._portletFilters;
    }

    public void setPortletFilters(Map<String, PortletFilter> portletFilters) {
        this._portletFilters = portletFilters;
    }

    public void addProcessingEvent(QName processingEvent) {
        this._processingEvents.add(processingEvent);
        this._processingEventsByQName.put(PortletQNameUtil.getKey((QName)processingEvent), processingEvent);
    }

    public QName getProcessingEvent(String uri, String localPart) {
        return this._processingEventsByQName.get(PortletQNameUtil.getKey((String)uri, (String)localPart));
    }

    public Set<QName> getProcessingEvents() {
        return this._processingEvents;
    }

    public void setProcessingEvents(Set<QName> processingEvents) {
        for (QName processingEvent : processingEvents) {
            this.addProcessingEvent(processingEvent);
        }
    }

    public void addPublishingEvent(QName publishingEvent) {
        this._publishingEvents.add(publishingEvent);
    }

    public Set<QName> getPublishingEvents() {
        return this._publishingEvents;
    }

    public void setPublishingEvents(Set<QName> publishingEvents) {
        for (QName publishingEvent : publishingEvents) {
            this.addPublishingEvent(publishingEvent);
        }
    }

    public void addPublicRenderParameter(PublicRenderParameter publicRenderParameter) {
        this._publicRenderParameters.add(publicRenderParameter);
        this._publicRenderParametersByIdentifier.put(publicRenderParameter.getIdentifier(), publicRenderParameter);
        this._publicRenderParametersByQName.put(PortletQNameUtil.getKey((QName)publicRenderParameter.getQName()), publicRenderParameter);
    }

    public PublicRenderParameter getPublicRenderParameter(String identifier) {
        return this._publicRenderParametersByIdentifier.get(identifier);
    }

    public PublicRenderParameter getPublicRenderParameter(String uri, String localPart) {
        return this._publicRenderParametersByQName.get(PortletQNameUtil.getKey((String)uri, (String)localPart));
    }

    public Set<PublicRenderParameter> getPublicRenderParameters() {
        return this._publicRenderParameters;
    }

    public void setPublicRenderParameters(Set<PublicRenderParameter> publicRenderParameters) {
        for (PublicRenderParameter publicRenderParameter : publicRenderParameters) {
            this.addPublicRenderParameter(publicRenderParameter);
        }
    }

    public String getContextPath() {
        String virtualPath = this.getVirtualPath();
        if (Validator.isNotNull((String)virtualPath)) {
            return virtualPath;
        }
        if (this._portletApp.isWARFile()) {
            StringBuilder sb = new StringBuilder();
            sb.append("/");
            sb.append(this._portletApp.getServletContextName());
            return sb.toString();
        }
        return PortalUtil.getPathContext();
    }

    public PortletApp getPortletApp() {
        return this._portletApp;
    }

    public void setPortletApp(PortletApp portletApp) {
        this._portletApp = portletApp;
    }

    public Portlet getClonedInstance(String portletId) {
        if (this._clonedInstances == null) {
            return null;
        }
        Portlet clonedInstance = this._clonedInstances.get(portletId);
        if (clonedInstance == null) {
            clonedInstance = (Portlet)this.clone();
            clonedInstance.setPortletId(portletId);
        }
        return clonedInstance;
    }

    public boolean getStatic() {
        return this._staticPortlet;
    }

    public boolean isStatic() {
        return this._staticPortlet;
    }

    public void setStatic(boolean staticPortlet) {
        this._staticPortlet = staticPortlet;
    }

    public boolean getStaticStart() {
        return this._staticPortletStart;
    }

    public boolean isStaticStart() {
        return this._staticPortletStart;
    }

    public void setStaticStart(boolean staticPortletStart) {
        this._staticPortletStart = staticPortletStart;
    }

    public boolean getStaticEnd() {
        return !this._staticPortletStart;
    }

    public boolean isStaticEnd() {
        return !this._staticPortletStart;
    }

    public boolean getUndeployedPortlet() {
        return this._undeployedPortlet;
    }

    public boolean isUndeployedPortlet() {
        return this._undeployedPortlet;
    }

    public void setUndeployedPortlet(boolean undeployedPortlet) {
        this._undeployedPortlet = undeployedPortlet;
    }

    @Override
    public Object clone() {
        PortletImpl portlet = new PortletImpl(this.getPortletId(), this.getPluginPackage(), this.getDefaultPluginSetting(), this.getCompanyId(), this.getTimestamp(), this.getIcon(), this.getVirtualPath(), this.getStrutsPath(), this.getPortletName(), this.getDisplayName(), this.getPortletClass(), this.getConfigurationActionClass(), this.getIndexerClass(), this.getOpenSearchClass(), this.getSchedulerClass(), this.getPortletURLClass(), this.getFriendlyURLMapperClass(), this.getURLEncoderClass(), this.getPortletDataHandlerClass(), this.getPortletLayoutListenerClass(), this.getPollerProcessorClass(), this.getPopMessageListenerClass(), this.getSocialActivityInterpreterClass(), this.getSocialRequestInterpreterClass(), this.getWebDAVStorageToken(), this.getWebDAVStorageClass(), this.getControlPanelEntryCategory(), this.getControlPanelEntryWeight(), this.getControlPanelEntryClass(), this.getDefaultPreferences(), this.getPreferencesValidator(), this.isPreferencesCompanyWide(), this.isPreferencesUniquePerLayout(), this.isPreferencesOwnedByGroup(), this.isUseDefaultTemplate(), this.isShowPortletAccessDenied(), this.isShowPortletInactive(), this.isActionURLRedirect(), this.isRestoreCurrentView(), this.isMaximizeEdit(), this.isMaximizeHelp(), this.isPopUpPrint(), this.isLayoutCacheable(), this.isInstanceable(), this.isScopeable(), this.getUserPrincipalStrategy(), this.isPrivateRequestAttributes(), this.isPrivateSessionAttributes(), this.getRenderWeight(), this.isAjaxable(), this.getHeaderPortalCss(), this.getHeaderPortletCss(), this.getHeaderPortalJavaScript(), this.getHeaderPortletJavaScript(), this.getFooterPortalCss(), this.getFooterPortletCss(), this.getFooterPortalJavaScript(), this.getFooterPortletJavaScript(), this.getCssClassWrapper(), this.getFacebookIntegration(), this.isAddDefaultResource(), this.getRoles(), this.getUnlinkedRoles(), this.getRoleMappers(), this.isSystem(), this.isActive(), this.isInclude(), this.getInitParams(), this.getExpCache(), this.getPortletModes(), this.getWindowStates(), this.getSupportedLocales(), this.getResourceBundle(), this.getPortletInfo(), this.getPortletFilters(), this.getProcessingEvents(), this.getPublishingEvents(), this.getPublicRenderParameters(), this.getPortletApp());
        portlet.setId(this.getId());
        return portlet;
    }

    @Override
    public int compareTo(Portlet portlet) {
        return this.getPortletId().compareTo(portlet.getPortletId());
    }

    @Override
    public boolean equals(Object obj) {
        Portlet portlet = (Portlet)obj;
        return this.getPortletId().equals(portlet.getPortletId());
    }
}

