/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.ContactConstants;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.PasswordPolicy;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.model.impl.ContactImpl;
import com.liferay.portal.model.impl.UserModelImpl;
import com.liferay.portal.security.auth.EmailAddressGenerator;
import com.liferay.portal.security.auth.EmailAddressGeneratorFactory;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.ContactLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.PasswordPolicyLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserGroupLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.UniqueList;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserImpl
extends UserModelImpl
implements User {
    private static Log _log = LogFactoryUtil.getLog(UserImpl.class);
    private Locale _locale;
    private boolean _passwordModified;
    private String _passwordUnencrypted;
    private TimeZone _timeZone;

    public Date getBirthday() {
        return this.getContact().getBirthday();
    }

    public String getCompanyMx() {
        String companyMx = null;
        try {
            Company company = CompanyLocalServiceUtil.getCompanyById((long)this.getCompanyId());
            companyMx = company.getMx();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return companyMx;
    }

    public Contact getContact() {
        Contact contact = null;
        try {
            contact = ContactLocalServiceUtil.getContact((long)this.getContactId());
        }
        catch (Exception e) {
            contact = new ContactImpl();
            _log.error((Object)e, (Throwable)e);
        }
        return contact;
    }

    public String getDisplayEmailAddress() {
        String emailAddress = super.getEmailAddress();
        EmailAddressGenerator emailAddressGenerator = EmailAddressGeneratorFactory.getInstance();
        if (emailAddressGenerator.isFake(emailAddress)) {
            emailAddress = "";
        }
        return emailAddress;
    }

    public String getDisplayURL(ThemeDisplay themeDisplay) {
        return this.getDisplayURL(themeDisplay.getPortalURL(), themeDisplay.getPathMain());
    }

    public String getDisplayURL(String portalURL, String mainPath) {
        try {
            int publicLayoutsPageCount;
            Group group = this.getGroup();
            if (group != null && (publicLayoutsPageCount = group.getPublicLayoutsPageCount()) > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(portalURL);
                sb.append(mainPath);
                sb.append("/my_places/view?groupId=");
                sb.append(group.getGroupId());
                sb.append("&privateLayout=0");
                return sb.toString();
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return "";
    }

    public boolean getFemale() {
        return !this.getMale();
    }

    public String getFullName() {
        return ContactConstants.getFullName((String)this.getFirstName(), (String)this.getMiddleName(), (String)this.getLastName());
    }

    public Group getGroup() {
        Group group = null;
        try {
            group = GroupLocalServiceUtil.getUserGroup((long)this.getCompanyId(), (long)this.getUserId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return group;
    }

    public long[] getGroupIds() {
        List<Group> groups = this.getGroups();
        long[] groupIds = new long[groups.size()];
        for (int i = 0; i < groups.size(); ++i) {
            Group group = groups.get(i);
            groupIds[i] = group.getGroupId();
        }
        return groupIds;
    }

    public List<Group> getGroups() {
        try {
            return GroupLocalServiceUtil.getUserGroups((long)this.getUserId());
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get groups for user " + this.getUserId()));
            }
            return new ArrayList<Group>();
        }
    }

    public Locale getLocale() {
        return this._locale;
    }

    public String getLogin() throws PortalException, SystemException {
        String login = null;
        Company company = CompanyLocalServiceUtil.getCompanyById((long)this.getCompanyId());
        if (company.getAuthType().equals("emailAddress")) {
            login = this.getEmailAddress();
        } else if (company.getAuthType().equals("screenName")) {
            login = this.getScreenName();
        } else if (company.getAuthType().equals("userId")) {
            login = String.valueOf(this.getUserId());
        }
        return login;
    }

    public boolean getMale() {
        return this.getContact().getMale();
    }

    public List<Group> getMyPlaces() {
        return this.getMyPlaces(-1);
    }

    public List<Group> getMyPlaces(int max) {
        Object myPlaces;
        block8: {
            myPlaces = new UniqueList();
            try {
                if (this.isDefaultUser()) {
                    return myPlaces;
                }
                int start = -1;
                int end = -1;
                if (max != -1) {
                    start = 0;
                    end = max;
                }
                LinkedHashMap<String, Long> groupParams = new LinkedHashMap<String, Long>();
                groupParams.put("usersGroups", new Long(this.getUserId()));
                myPlaces.addAll(GroupLocalServiceUtil.search((long)this.getCompanyId(), null, null, groupParams, (int)start, (int)end));
                LinkedHashMap<String, Long> organizationParams = new LinkedHashMap<String, Long>();
                organizationParams.put("usersOrgs", new Long(this.getUserId()));
                List userOrgs = OrganizationLocalServiceUtil.search((long)this.getCompanyId(), (long)-1L, null, null, null, null, organizationParams, (int)start, (int)end);
                for (Organization organization : userOrgs) {
                    myPlaces.add(0, organization.getGroup());
                    if (PropsValues.ORGANIZATIONS_MEMBERSHIP_STRICT) continue;
                    for (Organization ancestorOrganization : organization.getAncestors()) {
                        myPlaces.add(0, ancestorOrganization.getGroup());
                    }
                }
                if (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_ENABLED || PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_ENABLED) {
                    Group userGroup = this.getGroup();
                    myPlaces.add(0, userGroup);
                }
                if (max != -1 && myPlaces.size() > max) {
                    myPlaces = ListUtil.subList((List)myPlaces, (int)start, (int)end);
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block8;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return myPlaces;
    }

    public long[] getOrganizationIds() {
        List<Organization> organizations = this.getOrganizations();
        long[] organizationIds = new long[organizations.size()];
        for (int i = 0; i < organizations.size(); ++i) {
            Organization organization = organizations.get(i);
            organizationIds[i] = organization.getOrganizationId();
        }
        return organizationIds;
    }

    public List<Organization> getOrganizations() {
        try {
            return OrganizationLocalServiceUtil.getUserOrganizations((long)this.getUserId());
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get organizations for user " + this.getUserId()));
            }
            return new ArrayList<Organization>();
        }
    }

    public boolean getPasswordModified() {
        return this._passwordModified;
    }

    public PasswordPolicy getPasswordPolicy() throws PortalException, SystemException {
        PasswordPolicy passwordPolicy = PasswordPolicyLocalServiceUtil.getPasswordPolicyByUserId((long)this.getUserId());
        return passwordPolicy;
    }

    public String getPasswordUnencrypted() {
        return this._passwordUnencrypted;
    }

    public int getPrivateLayoutsPageCount() {
        try {
            Group group = this.getGroup();
            if (group == null) {
                return 0;
            }
            return group.getPrivateLayoutsPageCount();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return 0;
        }
    }

    public int getPublicLayoutsPageCount() {
        try {
            Group group = this.getGroup();
            if (group == null) {
                return 0;
            }
            return group.getPublicLayoutsPageCount();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return 0;
        }
    }

    public Set<String> getReminderQueryQuestions() throws PortalException, SystemException {
        TreeSet<String> questions = new TreeSet<String>();
        List organizations = OrganizationLocalServiceUtil.getUserOrganizations((long)this.getUserId(), (boolean)true);
        for (Organization organization : organizations) {
            Set organizationQuestions = organization.getReminderQueryQuestions(this.getLanguageId());
            if (organizationQuestions.size() == 0) {
                for (Organization parentOrganization = organization.getParentOrganization(); organizationQuestions.size() == 0 && parentOrganization != null; parentOrganization = parentOrganization.getParentOrganization()) {
                    organizationQuestions = parentOrganization.getReminderQueryQuestions(this.getLanguageId());
                }
            }
            questions.addAll(organizationQuestions);
        }
        if (questions.size() == 0) {
            Set defaultQuestions = SetUtil.fromArray((Object[])PropsUtil.getArray("users.reminder.queries.questions"));
            questions.addAll(defaultQuestions);
        }
        return questions;
    }

    public long[] getRoleIds() {
        List<Role> roles = this.getRoles();
        long[] roleIds = new long[roles.size()];
        for (int i = 0; i < roles.size(); ++i) {
            Role role = roles.get(i);
            roleIds[i] = role.getRoleId();
        }
        return roleIds;
    }

    public List<Role> getRoles() {
        try {
            return RoleLocalServiceUtil.getUserRoles((long)this.getUserId());
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get roles for user " + this.getUserId()));
            }
            return new ArrayList<Role>();
        }
    }

    public long[] getUserGroupIds() {
        List<UserGroup> userGroups = this.getUserGroups();
        long[] userGroupIds = new long[userGroups.size()];
        for (int i = 0; i < userGroups.size(); ++i) {
            UserGroup userGroup = userGroups.get(i);
            userGroupIds[i] = userGroup.getUserGroupId();
        }
        return userGroupIds;
    }

    public List<UserGroup> getUserGroups() {
        try {
            return UserGroupLocalServiceUtil.getUserUserGroups((long)this.getUserId());
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get user groups for user " + this.getUserId()));
            }
            return new ArrayList<UserGroup>();
        }
    }

    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    public boolean hasCompanyMx() {
        return this.hasCompanyMx(this.getEmailAddress());
    }

    public boolean hasCompanyMx(String emailAddress) {
        if (Validator.isNull((String)emailAddress)) {
            return false;
        }
        try {
            Company company = CompanyLocalServiceUtil.getCompanyById((long)this.getCompanyId());
            return company.hasCompanyMx(emailAddress);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public boolean hasMyPlaces() {
        block6: {
            try {
                if (this.isDefaultUser()) {
                    return false;
                }
                LinkedHashMap<String, Long> groupParams = new LinkedHashMap<String, Long>();
                groupParams.put("usersGroups", new Long(this.getUserId()));
                int count = GroupLocalServiceUtil.searchCount((long)this.getCompanyId(), null, null, groupParams);
                if (count > 0) {
                    return true;
                }
                count = OrganizationLocalServiceUtil.getUserOrganizationsCount((long)this.getUserId());
                if (count > 0) {
                    return true;
                }
                if (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_ENABLED || PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_ENABLED) {
                    return true;
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return false;
    }

    public boolean hasOrganization() {
        return this.getOrganizations().size() > 0;
    }

    public boolean hasPrivateLayouts() {
        return this.getPrivateLayoutsPageCount() > 0;
    }

    public boolean hasPublicLayouts() {
        return this.getPublicLayoutsPageCount() > 0;
    }

    public boolean isFemale() {
        return this.getFemale();
    }

    public boolean isMale() {
        return this.getMale();
    }

    public boolean isPasswordModified() {
        return this._passwordModified;
    }

    @Override
    public void setLanguageId(String languageId) {
        this._locale = LocaleUtil.fromLanguageId((String)languageId);
        super.setLanguageId(LocaleUtil.toLanguageId((Locale)this._locale));
    }

    public void setPasswordModified(boolean passwordModified) {
        this._passwordModified = passwordModified;
    }

    public void setPasswordUnencrypted(String passwordUnencrypted) {
        this._passwordUnencrypted = passwordUnencrypted;
    }

    @Override
    public void setTimeZoneId(String timeZoneId) {
        if (Validator.isNull((String)timeZoneId)) {
            timeZoneId = TimeZoneUtil.getDefault().getID();
        }
        this._timeZone = TimeZone.getTimeZone(timeZoneId);
        super.setTimeZoneId(timeZoneId);
    }
}

